(** Generic utilities. *)

(*
    il4c  --  Compiler for the IL4 Lisp-ahtava langauge
    Copyright (C) 2007 Jere Sanisalo

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*)

(** Executes the first function and guarantees the second function is run (even on exceptions). *)
val finally : (unit -> 'a) -> (unit -> unit) -> 'a

(** Converts a char into a string. *)
val string_of_char : char -> string

(** Converts a char list into a string. *)
val string_of_chars : char list -> string

(** Returns the any non-unique object in the list or None. *)
val get_nonunique_item : 'a list -> 'a option

(** Replaces the association list item with the given item. Preserves order. Throws Not_found if the value is not found. *)
val assoc_replace : ('a * 'b) -> ('a * 'b) list -> ('a * 'b) list

(** Replaces or inserts the association list item with the given item.
    New items are inserted to the start, otherwise order is presrved. *)
val assoc_replace_or_insert : ('a * 'b) -> ('a * 'b) list -> ('a * 'b) list

(** Converts a string into a char list. *)
val string_to_chars : string -> char list

(** List iterator that gives the item index while iterating. *)
val list_iteri : (int -> 'a -> unit) -> 'a list -> unit

(** List mapping with an index. *)
val list_mapi : (int -> 'a -> 'b) -> 'a list -> 'b list

(** Returns the index of the item in the list. Throws Not_found if item not in list. *)
val list_idx : 'a list -> 'a -> int

(** Returns the index of the first item in the list that the predicate is true. Throws Not_found if all are false. *)
val list_find_idx : ('a -> bool) -> 'a list -> int

(** Writes a text file *)
val write_file : string -> string -> unit

(** Writes a file with the line strings being in a list. *)
val write_file_lines : string -> string list -> unit
