(** Parses an il4 file. *)

(*
    il4c  --  Compiler for the IL4 Lisp-ahtava langauge
    Copyright (C) 2007 Jere Sanisalo

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*)

type item =
	| Atom of string * Pos_obj.range
	| Int of int32 * Pos_obj.range
	| Float of float * Pos_obj.range
	| Str of string * Pos_obj.range
	| Items of item_list * Pos_obj.range
and item_list = item list

(** Parses an IL4 file. *)
val parse : string -> item_list


(** Returns the item range. *)
val range_of_item : item -> Pos_obj.range

(** Returns the item as an atom. Throws an exception on error. *)
val atom_of_item : item -> string

(** Returns the item as an int. Throws an exception on error. *)
val int_of_item : item -> int32

(** Returns the item as a float. Throws an exception on error. *)
val float_of_item : item -> float

(** Returns the item as a string. Throws an exception on error. *)
val string_of_item : item -> string

(** Returns the item as a list of items. Throws an exception on error. *)
val items_of_item : item -> item_list
