/*
 * Startup, window creation, and render loop.
 *
 * Coded by:
 *  s_tec
 */

//#define FULLSCREEN
#include <windows.h>
#include <gl/gl.h>
#include "screen.h"

/*
 * External declarations:
 */
void demo_init();
int  demo_render(DWORD t, DWORD dt);
void music();
extern HWAVEOUT wave_handle; /* Used to find the current time */

/*
 * Data structures:
 */
MMTIME main_time = {TIME_SAMPLES, 0};

#ifdef FULLSCREEN
DEVMODE s_main_mode = {
  "",                             /* dmDeviceName[CCHDEVICENAME] */
  0,                              /* dmSpecVersion */
  0,                              /* dmDriverVersion */
  sizeof(DEVMODE),                /* dmSize */
  0,                              /* dmDriverExtra */
  DM_PELSWIDTH | DM_PELSHEIGHT,   /* dmFields */
  0, 0, 0, 0, 0, 0, 0, 0,         /* Paper stuff */
  0,                              /* dmColor */
  0,                              /* dmDuplex */
  0,                              /* dmYResolution */
  0,                              /* dmTTOption */
  0,                              /* dmCollate */
  "",                             /* dmFormName[CCHFORMNAME] */
  0,                              /* dmLogPixels */
  0,                              /* dmBitsPerPel */
  MAIN_X,                         /* dmPelsWidth */
  MAIN_Y,                         /* dmPelsHeight */
  0,                              /* dmDisplayFlags */
  0                               /* dmDisplayFrequency */
};
#endif

PIXELFORMATDESCRIPTOR s_main_pfd = {
  0,                              /* nSize */
  0,                              /* nVersion */
  PFD_DRAW_TO_WINDOW | PFD_DOUBLEBUFFER | PFD_SUPPORT_OPENGL, /* dwFlags */
  PFD_TYPE_RGBA,                  /* iPixelType */
  0,                              /* cColorBits */
  0, 0,                           /* cRedBits,   cRedShift */
  0, 0,                           /* cGreenBits, cGreenShift */
  0, 0,                           /* cBlueBits,  cBlueShift */
  0, 0,                           /* cAlphaBits, cAlphaShift */
  0,                              /* cAccumBits */
  0,                              /* cAccumRedBits */
  0,                              /* cAccumGreenBits */
  0,                              /* cAccumBlueBits */
  0,                              /* cAccumAlphaBits */
  16,                             /* cDepthBits */
  0,                              /* cStencilBits */
  0,                              /* cAuxBuffers */
  PFD_MAIN_PLANE,                 /* iLayerType */
  0,                              /* bReserved */
  0,                              /* dwLayerMask */
  0,                              /* dwVisibleMask */
  0                               /* dwDamageMask */
};

/**
 * Startup code
 */
void main()
{
  HDC dc;
  DWORD t = 0;
  DWORD dt;

#ifdef FULLSCREEN
  /* Fullscreen setup: */
  ChangeDisplaySettings(&s_main_mode, CDS_FULLSCREEN);
  dc = GetDC(CreateWindowExA(
    0, "edit", 0,
    WS_POPUP|WS_VISIBLE|WS_CLIPSIBLINGS|WS_MAXIMIZE,
    0, 0, 0, 0, 0, 0, 0, 0));
#else
  /* Windowed setup: */
  dc = GetDC(CreateWindowExA(
    0, "edit", 0,
    WS_POPUP|WS_VISIBLE|WS_CLIPSIBLINGS,
    100, 100, MAIN_X, MAIN_Y, 0, 0, 0, 0));
#endif

  /* Set up OpenGL: */
  SetPixelFormat(dc, ChoosePixelFormat(dc, &s_main_pfd), &s_main_pfd);
  wglMakeCurrent(dc, wglCreateContext(dc));
  ShowCursor(FALSE);

  /* Set up the demo: */
  demo_init();
  music();

  /* Render loop: */
  do {
    waveOutGetPosition(wave_handle, &main_time, sizeof(main_time));
    dt = main_time.u.sample - t;
    t = main_time.u.sample;

    if (!demo_render(t + dt, dt))
      break;
    SwapBuffers(dc);
  } while (!GetAsyncKeyState(VK_ESCAPE));

  /* Clean up and exit: */
  ExitProcess(0);
}
