// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "AcidView.h"
#include "MainFrm.h"
#include "leftview.h"
#include "acidviewdoc.h"
#include "jumptodirectory.h"
#include "quickhelpdlg.h"
#include "ImageFactory.h"
#include "ImageData.h"
#include "Preferences.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#include <deque>

using namespace std;


deque<CString> CMainFrame::m_fileArray;

/////////////////////////////////////////////////////////////////////////////
// CMainFrame CFileFind

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

/*! \note ID_VIEW_FONT_LOADED added by hand */

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_COMMAND(ID_FILE_OPENNEXT, OnFileOpennext)
	ON_COMMAND(ID_FILE_OPENPREVIOUS, OnFileOpenprevious)
	ON_COMMAND(ID_SPEED_14400, OnSpeed14400)
	ON_COMMAND(ID_SPEED_2400, OnSpeed2400)
	ON_COMMAND(ID_SPEED_28800, OnSpeed28800)
	ON_COMMAND(ID_SPEED_4800, OnSpeed4800)
	ON_COMMAND(ID_SPEED_9600, OnSpeed9600)
	ON_COMMAND(ID_VIEW_DECREASERESOLUTION, OnViewDecreaseresolution)
	ON_COMMAND(ID_VIEW_INCREASERESOLUTION, OnViewIncreaseresolution)
	ON_COMMAND(ID_VIEW_SAUCE, OnViewSauce)
	ON_COMMAND(ID_VIEW_SIZE_160p, OnViewSize160p)
	ON_COMMAND(ID_VIEW_SIZE_320p, OnViewSize320p)
	ON_COMMAND(ID_VIEW_SIZE_80p, OnViewSize80p)
	ON_COMMAND(ID_VIEW_SIZE_NORMAL, OnViewSizeNormal)
	ON_COMMAND(ID_VIEW_SMOOTHSCROLL, OnViewSmoothscroll)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SMOOTHSCROLL, OnUpdateViewSmoothscroll)
	ON_COMMAND(ID_FILE_JUMPTODIR, OnFileJumptodir)
	ON_COMMAND(ID_FILE_SETFILEMASK, OnFileSetfilemask)
	ON_COMMAND(ID_SPEED_57600, OnSpeed57600)
	ON_COMMAND(ID_SPEED_38400, OnSpeed38400)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SIZE_NORMAL, OnUpdateViewSizeNormal)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SAUCE, OnUpdateViewSauce)
	ON_COMMAND(ID_FILE_REFRESH, OnFileRefresh)
	ON_UPDATE_COMMAND_UI(ID_SPEED_2400, OnUpdateSpeed2400)
	ON_COMMAND(ID_FILE_REFRESHWITHMODEM, OnFileRefreshwithmodem)
	ON_UPDATE_COMMAND_UI(ID_SPEED_ALWAYSON, OnUpdateSpeedAlwayson)
	ON_COMMAND(ID_SPEED_ALWAYSON, OnSpeedAlwayson)
	ON_COMMAND(ID_VIEW_25LINES, OnView25lines)
	ON_UPDATE_COMMAND_UI(ID_VIEW_25LINES, OnUpdateView25lines)
	ON_COMMAND(ID_VIEW_50LINES, OnView50lines)
	ON_COMMAND(ID_VIEW_ACIDVIEW, OnViewAcidview)
	ON_COMMAND(ID_VIEW_AMIGA, OnViewAmiga)
	ON_COMMAND(ID_ENABLE_RIP, OnEnableRip)
	ON_COMMAND(ID_VIEW_PROPS, OnViewProps)
	ON_COMMAND(ID_HELP_QUICKHELP, OnHelpQuickhelp)
	ON_COMMAND(ID_TOGGLE_LINE_MODE, OnToggleLineMode)
	ON_COMMAND(ID_TOGGLE_SPEED, OnToggleSpeed)
	ON_COMMAND(ID_FILE_GOBACK, OnFileGoback)
	ON_COMMAND(ID_FILE_GOFORWARD, OnFileGoforward)
	ON_COMMAND(ID_FILE_SAVEASAVI, OnFileSaveasavi)
	ON_UPDATE_COMMAND_UI(ID_FILE_SAVEASAVI, OnUpdateFileSaveasavi)
	ON_COMMAND(ID_FILE_SAVEASPNG, OnFileSaveaspng)
	ON_COMMAND(ID_VIEW_PALETTE_BLACKANDWHITE, OnViewPaletteBlackandwhite)
	ON_COMMAND(ID_VIEW_PALETTE_ICECOLORS, OnViewPaletteIcecolors)
	ON_UPDATE_COMMAND_UI(ID_VIEW_PALETTE_ICECOLORS, OnUpdateViewPaletteIcecolors)
	ON_COMMAND(ID_VIEW_PALETTE_LOADFROMXB, OnViewPaletteLoadfromxb)
	ON_COMMAND(ID_VIEW_PALETTE_NORMAL, OnViewPaletteNormal)
	ON_COMMAND(ID_VIEW_PALETTE_LOADED, OnViewPaletteLoaded)
	ON_COMMAND(ID_VIEW_FONT_LOADED, OnViewFontLoaded)
	ON_UPDATE_COMMAND_UI(ID_VIEW_PALETTE_NORMAL, OnUpdateViewPaletteNormal)
	ON_COMMAND(ID_VIEW_FONT_LOADFROMXB, OnViewFontLoadfromxb)
	ON_COMMAND(ID_VIEW_PALETTE_ASCII, OnViewPaletteAscii)
	ON_COMMAND(ID_VIEW_PREFERENCES, OnViewPreferences)
	ON_COMMAND(ID_VIEW_STARTSLIDESHOW, OnViewStartslideshow)
	ON_UPDATE_COMMAND_UI(ID_VIEW_STARTSLIDESHOW, OnUpdateViewStartslideshow)
	ON_COMMAND(ID_VIEW_9TH_COLUMN, OnView9thColumn)
	ON_COMMAND(ID_VIEW_FULLSCREEN, OnViewFullscreen)
	//}}AFX_MSG_MAP
	ON_REGISTERED_MESSAGE(WM_IMAGE_DONE, OnImageDone)
	ON_MESSAGE (WM_SETMESSAGESTRING, OnSetMessageString)
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR//,           // status line indicator
	//ID_INDICATOR_CAPS,
	//ID_INDICATOR_NUM,
	//ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame() :
	m_enableSlideShow(false)	
{
}

CMainFrame::~CMainFrame()
{
	m_fileArray.clear();
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // fail to create
	}

	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	if( !CFrameWnd::PreCreateWindow(cs) )
		return FALSE;

	CWinApp *pApp = AfxGetApp();
	cs.x = (int)pApp->GetProfileInt(_T("Settings"),_T("left"),cs.x);
	cs.y = (int)pApp->GetProfileInt(_T("Settings"),_T("top"),cs.y);
	cs.cx = (int)pApp->GetProfileInt(_T("Settings"),_T("width"),cs.cx);
	cs.cy = (int)pApp->GetProfileInt(_T("Settings"),_T("height"),cs.cy);

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers


BOOL CMainFrame::OnCreateClient(LPCREATESTRUCT lpcs, CCreateContext* pContext) 
{
	if (!m_wndSplitter.CreateStatic(this, 1, 2)) {
		return FALSE;
	}

	if (!m_wndSplitter.CreateView(0, 0, RUNTIME_CLASS(CLeftView), CSize(200, 100), pContext) ||
		!m_wndSplitter.CreateView(0, 1, RUNTIME_CLASS(CAcidViewView), CSize(100, 100), pContext))
	{
		m_wndSplitter.DestroyWindow();
		return FALSE;
	}
		
	CWinApp *pApp = AfxGetApp();
	m_slideShow.bRandom				= !!pApp->GetProfileInt(_T("SlideShow Settings"),_T("random"), 0);
	m_slideShow.bCycle				= !!pApp->GetProfileInt(_T("SlideShow Settings"),_T("cycle"), 0);
	m_slideShow.bSubdirectories		= !!pApp->GetProfileInt(_T("SlideShow Settings"),_T("subdirectories"), 0);
	m_slideShow.bStartFullscreen	= !!pApp->GetProfileInt(_T("SlideShow Settings"),_T("startFullscreen"), 0);
	m_slideShow.bCompressedFiles	= !!pApp->GetProfileInt(_T("SlideShow Settings"),_T("compressedFiles"), 0);
	m_slideShow.bUseTextFile		= !!pApp->GetProfileInt(_T("SlideShow Settings"),_T("useTextFile"), 0);
	m_slideShow.delay				= pApp->GetProfileInt(_T("SlideShow Settings"),_T("delay"), 3000);
	m_slideShow.textFile			= pApp->GetProfileString(_T("SlideShow Settings"),_T("textFile"), _T(""));
	m_slideShow.directory			= pApp->GetProfileString(_T("SlideShow Settings"),_T("directory"), _T(""));

	return TRUE;
 	//return CFrameWnd::OnCreateClient(lpcs, pContext);
}

BOOL CMainFrame::DestroyWindow() 
{
	CWinApp *pApp = AfxGetApp();
	WINDOWPLACEMENT pl;
	GetWindowPlacement(&pl);
	RECT r = pl.rcNormalPosition;

	pApp->WriteProfileInt(_T("Settings"),_T("left"),	r.left);
	pApp->WriteProfileInt(_T("Settings"),_T("top"),		r.top);
	pApp->WriteProfileInt(_T("Settings"),_T("width"),	r.right-r.left);
	pApp->WriteProfileInt(_T("Settings"),_T("height"),	r.bottom-r.top);
	pApp->WriteProfileInt(_T("Settings"),_T("showCmd"),	pl.showCmd);

	pApp->WriteProfileInt(_T("SlideShow Settings"),_T("random"),		m_slideShow.bRandom);
	pApp->WriteProfileInt(_T("SlideShow Settings"),_T("cycle"),			m_slideShow.bCycle);
	pApp->WriteProfileInt(_T("SlideShow Settings"),_T("startFullscreen"),m_slideShow.bStartFullscreen);
	pApp->WriteProfileInt(_T("SlideShow Settings"),_T("subdirectories"),m_slideShow.bSubdirectories);
	pApp->WriteProfileInt(_T("SlideShow Settings"),_T("compressedFiles"),m_slideShow.bCompressedFiles);
	pApp->WriteProfileInt(_T("SlideShow Settings"),_T("useTextFile"),	m_slideShow.bUseTextFile);
	pApp->WriteProfileInt(_T("SlideShow Settings"),_T("delay"),			m_slideShow.delay);
	pApp->WriteProfileString(_T("SlideShow Settings"),_T("textFile"),	m_slideShow.textFile);
	pApp->WriteProfileString(_T("SlideShow Settings"),_T("directory"),	m_slideShow.directory);
	
	return CFrameWnd::DestroyWindow();
}

CAcidViewView* CMainFrame::GetRightPane()
{
	CWnd* pWnd = m_wndSplitter.GetPane(0, 1);
	CAcidViewView* pView = DYNAMIC_DOWNCAST(CAcidViewView, pWnd);
	return pView;
}

CLeftView* CMainFrame::GetLeftPane()
{
	CWnd* pWnd = m_wndSplitter.GetPane(0, 0);
	CLeftView* pView = DYNAMIC_DOWNCAST(CLeftView, pWnd);
	return pView;
}

void CMainFrame::OnUpdateViewStyles(CCmdUI* pCmdUI)
{
	// TODO: customize or extend this code to handle choices on the
	// View menu.

	CAcidViewView* pView = GetRightPane(); 


	// if the right-hand pane hasn't been created or isn't a view,
	// disable commands in our range

	if (pView == NULL)
		pCmdUI->Enable(FALSE);
	else
	{
		DWORD dwStyle = pView->GetStyle() & LVS_TYPEMASK;

		// if the command is ID_VIEW_LINEUP, only enable command
		// when we're in LVS_ICON or LVS_SMALLICON mode

		if (pCmdUI->m_nID == ID_VIEW_LINEUP)
		{
			if (dwStyle == LVS_ICON || dwStyle == LVS_SMALLICON)
				pCmdUI->Enable();
			else
				pCmdUI->Enable(FALSE);
		}
		else
		{
			// otherwise, use dots to reflect the style of the view
			pCmdUI->Enable();
			BOOL bChecked = FALSE;

			switch (pCmdUI->m_nID)
			{
			case ID_VIEW_DETAILS:
				bChecked = (dwStyle == LVS_REPORT);
				break;

			case ID_VIEW_SMALLICON:
				bChecked = (dwStyle == LVS_SMALLICON);
				break;

			case ID_VIEW_LARGEICON:
				bChecked = (dwStyle == LVS_ICON);
				break;

			case ID_VIEW_LIST:
				bChecked = (dwStyle == LVS_LIST);
				break;

			default:
				bChecked = FALSE;
				break;
			}

			pCmdUI->SetRadio(bChecked ? 1 : 0);
		}
	}
}


void CMainFrame::OnViewStyle(UINT nCommandID)
{
	// TODO: customize or extend this code to handle choices on the
	// View menu.
	CAcidViewView* pView = GetRightPane();

	// if the right-hand pane has been created and is a CDirTreeDemoView,
	// process the menu commands...
	if (pView != NULL)
	{
		DWORD dwStyle = -1;

		switch (nCommandID)
		{
		case ID_VIEW_LINEUP:
			{
				// ask the list control to snap to grid
				//gz
				//CListCtrl& refListCtrl = pView->GetListCtrl();
				//refListCtrl.Arrange(LVA_SNAPTOGRID);
			}
			break;

		// other commands change the style on the list control
		case ID_VIEW_DETAILS:
			dwStyle = LVS_REPORT;
			break;

		case ID_VIEW_SMALLICON:
			dwStyle = LVS_SMALLICON;
			break;

		case ID_VIEW_LARGEICON:
			dwStyle = LVS_ICON;
			break;

		case ID_VIEW_LIST:
			dwStyle = LVS_LIST;
			break;
		}

		// change the style; window will repaint automatically
		if (dwStyle != -1)
			pView->ModifyStyle(LVS_TYPEMASK, dwStyle);
	}
}

//Menu Handlers
void CMainFrame::OnFileOpennext() {
	if (m_enableSlideShow) {
		openNextFile();
	} else {
		GetLeftPane()->OpenNext();
	}
}

void CMainFrame::OnFileOpenprevious() {
	if (!m_enableSlideShow) {
		GetLeftPane()->OpenPrevious();	
	}
}

//set the correct radio
void CMainFrame::OnUpdateSpeed2400(CCmdUI* pCmdUI) {
	GetRightPane()->SetSpeed(-2);		
}
void CMainFrame::OnSpeed2400() {	SetSpeed(2400);		}
void CMainFrame::OnSpeed4800() {	SetSpeed(4800);		}
void CMainFrame::OnSpeed9600() {	SetSpeed(9600);		}
void CMainFrame::OnSpeed14400(){	SetSpeed(14400);	}
void CMainFrame::OnSpeed28800(){	SetSpeed(28800);	}
void CMainFrame::OnSpeed38400(){	SetSpeed(38400);	}
void CMainFrame::OnSpeed57600(){	SetSpeed(57600);	}
void CMainFrame::SetSpeed(int i) {
	GetRightPane()->SetSpeed(i);
}

void CMainFrame::OnViewDecreaseresolution() {
	GetRightPane()->DecreaseResolution();
}

void CMainFrame::OnViewIncreaseresolution() {
	GetRightPane()->IncreaseResolution();
}

void CMainFrame::OnViewSauce() {
	GetRightPane()->ViewSauce();
}

void CMainFrame::OnViewSizeNormal() {	SetResolution(rNormal);		}
void CMainFrame::OnViewSize320p()	{	SetResolution(r320);		}
void CMainFrame::OnViewSize160p()	{	SetResolution(r160);		}
void CMainFrame::OnViewSize80p()	{	SetResolution(r80);			}
void CMainFrame::SetResolution(ViewResolution v) {
	GetRightPane()->SetResolution(v);
}

void CMainFrame::OnViewSmoothscroll() {
	GetRightPane()->SmoothScroll();
}

void CMainFrame::OnUpdateViewSmoothscroll(CCmdUI* pCmdUI) {
	pCmdUI->SetCheck(GetRightPane()->m_smoothScroll?TRUE:FALSE);	
}

void CMainFrame::OnViewFullscreen() {
	
	static WINDOWPLACEMENT pl;
	if (!GetRightPane()->m_fullScreen) {
	
		//hide folders
		GetLeftPane()->ShowWindow(SW_HIDE);
		m_wndStatusBar.ShowWindow(SW_HIDE);

		//maximize

		GetWindowPlacement(&pl);
		ShowWindow(SW_SHOWMAXIMIZED);
		ModifyStyle(WS_CAPTION|WS_BORDER, 0);
		
		m_oldMenu.Attach(GetMenu()->Detach());
		SetMenu(NULL);

		//go full screen
		GetRightPane()->FullScreen();	

		//if unsucessful, go back
		if (!GetRightPane()->m_fullScreen) {
			ModifyStyle(0, WS_CAPTION|WS_BORDER);
			SetWindowPlacement(&pl);
			GetLeftPane()->ShowWindow(SW_SHOW);	
			m_wndStatusBar.ShowWindow(SW_SHOW);
			SetMenu(&m_oldMenu);
			m_oldMenu.Detach();
			ShowCursor(TRUE);
		} else {
			SetWindowPos(&wndTopMost, 0, 0, GetRightPane()->m_fullScreenSize.cx, GetRightPane()->m_fullScreenSize.cy, SWP_SHOWWINDOW|SWP_NOZORDER); 
			ShowCursor(FALSE);
		}

	} else {
		//SetWindowPos(&wndTopMost, 0, 0, m_fullScreenSize.cx, m_fullScreenSize.cy, SWP_SHOWWINDOW|SWP_NOZORDER); 
		ModifyStyle(0, WS_CAPTION|WS_BORDER);
		GetRightPane()->FullScreen();	
		SetWindowPlacement(&pl);
		GetLeftPane()->ShowWindow(SW_SHOW);	
		m_wndStatusBar.ShowWindow(SW_SHOW);
		SetMenu(&m_oldMenu);
		m_oldMenu.Detach();
		ShowCursor(TRUE);
	}
}

void CMainFrame::OnFileJumptodir() 
{
	CJumpToDirectory dlg;

	CString s = GetRightPane()->GetDocument()->GetPathName();
	int i = s.ReverseFind('\\');

	//Set currently displayed directory
	dlg.m_jumpDir = s.Left(i)+'\\';

	//Get last five dirs from the registry
	CWinApp *app = AfxGetApp();
	CString temp;
	int numFound = 0;
	for (i=1; i<=5; i++) {		

		temp.Format("Dir%d", i);
		temp = app->GetProfileString("Recent Jump List", temp, "");

		//Add to the combo box if there		
		if (temp.GetLength()>0) 
			dlg.m_dirs[numFound++] = temp;
		else
			dlg.m_dirs[i-1] = "";
	}
	
	i = dlg.DoModal();

	if (i==IDOK) {

		//Attempt to go to dir
		CLeftView *pView = GetLeftPane();
		dlg.m_jumpDir.MakeLower();
		s = dlg.m_jumpDir;
		BOOL b = pView->JumpToDir(s);
		if (b==FALSE) {
			MessageBox("Cannot find directory.");
		} else {
						
			app->WriteProfileString("Recent Jump List", "Dir1", dlg.m_jumpDir);			
			CString key, val;
			int numFound = 1;
			for (int j=0; j<5 && numFound<5; j++) {						
				val = dlg.m_dirs[j];
				if (val.GetLength()>0 && val!=dlg.m_jumpDir) {
					numFound++;
					key.Format("Dir%d", numFound);
					app->WriteProfileString("Recent Jump List", key, val);			
				}
			}

			//Open the dir
			SetSelPath(s);
		}		
	} 
}

void CMainFrame::OnFileSetfilemask() {
	GetLeftPane()->SetFileMask();	
}

BOOL CMainFrame::SetSelPath(LPCTSTR strPath) {
	return GetLeftPane()->SetSelPath(strPath);
}

void CMainFrame::OnUpdateViewSizeNormal(CCmdUI* pCmdUI) {
	GetRightPane()->SetResolution(GetRightPane()->m_context->m_resolution);	
}

void CMainFrame::OnUpdateViewSauce(CCmdUI* pCmdUI) {
	GetRightPane()->UpdateViewSauce(pCmdUI);
}

void CMainFrame::OnViewProps() {
	GetRightPane()->GetDocument()->LoadANSISplash();
}

void CMainFrame::OnFileRefresh() {
	GetRightPane()->Refresh(false);
}

void CMainFrame::OnFileRefreshwithmodem() {
	GetRightPane()->Refresh(true);	
}

void CMainFrame::OnUpdateSpeedAlwayson(CCmdUI* pCmdUI) {
	GetRightPane()->UpdateSpeedAlwaysOn(pCmdUI);	
}

void CMainFrame::OnSpeedAlwayson() {
	GetRightPane()->SpeedAlwaysOn();	
}

void CMainFrame::OnUpdateView25lines(CCmdUI* pCmdUI) {
	GetRightPane()->UpdateFonts(pCmdUI);	
}

void CMainFrame::OnView25lines() {
	GetRightPane()->ChangeFont(DOS_FONT);
}

void CMainFrame::OnView50lines() {
	GetRightPane()->ChangeFont(DOS_8X8_FONT);
}

void CMainFrame::OnViewAcidview() {
	GetRightPane()->ChangeFont(ACIDVIEW_FONT);
}

void CMainFrame::OnViewAmiga() {
	GetRightPane()->ChangeFont(AMIGA_FONT);	
}

void CMainFrame::OnViewFontLoaded() {
	GetRightPane()->ChangeFont(LOADED_FONT);	
}

void CMainFrame::OnEnableRip() 
{
	GetRightPane()->GetDocument()->EnableRip();	
}

void CMainFrame::OnHelpQuickhelp() {
	CQuickHelpDlg dlg;
	dlg.DoModal();	
}

void CMainFrame::OnToggleLineMode() {
	GetRightPane()->ToggleLineMode();
}

void CMainFrame::OnToggleSpeed() {
	GetRightPane()->ToggleSpeed();	
}

void CMainFrame::OnFileGoback() 
{
	CAcidViewApp *app = (CAcidViewApp *)AfxGetApp();
	app->historyGoBack();
}

void CMainFrame::OnFileGoforward() 
{
	CAcidViewApp *app = (CAcidViewApp *)AfxGetApp();
	app->historyGoForward();
}

void CMainFrame::OnFileSaveasavi() 
{
	CSaveAsAvi dlg;
	dlg.m_context = GetRightPane()->m_context;
	dlg.m_image   = GetRightPane()->GetDocument()->m_image; 
	dlg.DoModal();
}

void CMainFrame::OnUpdateFileSaveasavi(CCmdUI* pCmdUI) 
{	
	CAcidImage *image = GetRightPane()->GetDocument()->m_image;
	if (image)
		pCmdUI->Enable(GetRightPane()->GetDocument()->m_image->m_data->m_animateable);
	else
		pCmdUI->Enable(FALSE);
}

void CMainFrame::OnFileSaveaspng() 
{
	CAcidViewDoc *doc = GetRightPane()->GetDocument();

	if (doc->m_image) {

		static char BASED_CODE szFilter[] = "PNG Files (*.png)|*.png|All Files (*.*)|*.*||";
		CFileDialog dlg(FALSE, "png", doc->GetPathName()+CString(".png"), OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, szFilter);
		
		if (dlg.DoModal()==IDOK) {
			CString filename = dlg.GetPathName();
			doc->m_context = GetRightPane()->m_context;
			doc->OnSaveDocument(filename);
		}
	}
}


void CMainFrame::OnViewPaletteIcecolors() {
	CImageContext *context = GetRightPane()->m_context;
	context->m_iceColors= !context->m_iceColors;	
}

void CMainFrame::OnUpdateViewPaletteIcecolors(CCmdUI* pCmdUI) {
	CImageContext *context = GetRightPane()->m_context;
	pCmdUI->SetCheck(context->m_iceColors);	
}

void CMainFrame::OnViewPaletteNormal() {
	GetRightPane()->ChangePalette(DOS_PALETTE);
}

void CMainFrame::OnViewPaletteLoaded() {
	GetRightPane()->ChangePalette(LOADED_PALETTE);
}

void CMainFrame::OnViewPaletteBlackandwhite() {
	GetRightPane()->ChangePalette(GRAYSCALE_PALETTE);
}

void CMainFrame::OnViewPaletteLoadfromxb() {

	static char BASED_CODE szFilter[] = "XBin Files (*.xb)|*.xb|All Files (*.*)|*.*||";
	CFileDialog dlg(TRUE, "xb", "", OFN_HIDEREADONLY | OFN_PATHMUSTEXIST, szFilter);	
	if (dlg.DoModal()==IDOK) {
		CString filename = dlg.GetPathName();
		CImageContext *context = GetRightPane()->m_context;
		context->loadPalette(filename);
		Invalidate();
	}	
}

void CMainFrame::OnUpdateViewPaletteNormal(CCmdUI* pCmdUI) {
	GetRightPane()->UpdateViewPalette(pCmdUI);	
}

void CMainFrame::OnViewFontLoadfromxb() 
{
	static char BASED_CODE szFilter[] = "XBin Files (*.xb)|*.xb|All Files (*.*)|*.*||";
	CFileDialog dlg(TRUE, "xb", "", OFN_HIDEREADONLY | OFN_PATHMUSTEXIST, szFilter);	
	if (dlg.DoModal()==IDOK) {
		CString filename = dlg.GetPathName();
		CImageContext *context = GetRightPane()->m_context;
		context->loadFont(filename);
		Invalidate();
	}		
}

void CMainFrame::OnViewPaletteAscii() {
	GetRightPane()->ChangePalette(ASCII_PALETTE);
	
}

void CMainFrame::OnViewPreferences() 
{
	CPreferences dlg;
	
	dlg.m_slideShow = m_slideShow;	
	CSize s = GetRightPane()->m_fullScreenSize;
	if (s.cx==640 && s.cy==400)
		dlg.m_fullscreen = 0;
	else if (s.cx==640 && s.cy==480)
		dlg.m_fullscreen = 1;
	else if (s.cx==1024 && s.cy==768)
		dlg.m_fullscreen = 2;
	else
		dlg.m_fullscreen = 3;

	if (dlg.DoModal()==IDOK) {

		m_slideShow = dlg.m_slideShow;
		switch(dlg.m_fullscreen) {
			case 0:		GetRightPane()->m_fullScreenSize = CSize(640, 400);		break;
			case 1:		GetRightPane()->m_fullScreenSize = CSize(640, 480);		break;
			case 2:		GetRightPane()->m_fullScreenSize = CSize(1024, 768);	break;
			default:	GetRightPane()->m_fullScreenSize = CSize(0, 0);			break;
		}

		if (dlg.m_bStartSlideShow) {
			m_enableSlideShow = false;
			OnViewStartslideshow();
		}
	}
}


void CMainFrame::loadFileList(CString filename, CString mask, BOOL textFile) {

	if (textFile) {
	
		CStdioFile file;		
		if (file.Open(filename, CFile::modeRead|CFile::typeText)) {
			
			CString line;	
			CString dir = "";
			int slash = filename.ReverseFind('\\');
			if (slash!=-1) {
				dir = filename.Left(slash);
			}
			
			while(file.ReadString(line)) {
				if (line.Left(1)!='#') {
					
					//If the line begins with '.', insert the directory of the text file
					if (line.Left(1)=='.') {
						line = dir+line.Right(line.GetLength()-1);
					}
					
					m_fileArray.push_back(line);
				}
			}
			
		} else {
			::MessageBox(NULL, "Error processing slideshow list", "ACiDView", MB_OK);
		}
		
	} else {
		
		if (filename.Right(1)!='\\')
			filename += '\\';
		
		//If not using subdirectories, load up every file in the current dir
		/*! \todo Not the optimal solution if the user is working with a large directory of images */

		CSortStringArray array;

		CCompressedFileFind find(filename);
		BOOL bFind = find.findFile(mask);
		while ( bFind )	{
			bFind = find.findNextFile();
			if (bFind) {
				if (!find.isDirectory()) {
					array.Add(find.getFilePath());
				}
			}
		}

		//Unnecessary if using random, but don't want to bother passing that param around
		array.Sort();

		for (int i=0; i<array.GetSize(); i++) 
			m_fileArray.push_back(array.GetAt(i));
	}
}

void CMainFrame::OnViewStartslideshow() {
	
	m_enableSlideShow = !m_enableSlideShow;	
	if (!m_enableSlideShow)
		return;
	
	//Initialization
	m_fileArray.clear();
	
	//If navigating a directory
	if (!m_slideShow.bUseTextFile) {
		
		//If the directory field is blank, load up the current dir
		CString dir = m_slideShow.directory;
		if (dir.GetLength()==0) {
			//If the current item selected is a compressed file or the file_id.diz of a file, set that as the dir
			if (CCompressedFileFactory::isCompressedFile(GetLeftPane()->GetSelected()))
				dir = GetLeftPane()->GetSelected();
			//Occurs if you use the open with option from explorer
			else if (CCompressedFileFactory::isCompressedFile(GetRightPane()->GetDocument()->GetPathName()))
				dir = GetRightPane()->GetDocument()->GetPathName();
			else
				dir = GetLeftPane()->GetRoot();
		}
		
		loadFileList(dir, GetLeftPane()->GetFileMask(), FALSE);

	//Using a text file
	} else {		
		
		loadFileList(m_slideShow.textFile, "*.*", TRUE);
	}
	
	startSlideShowImp();
}


void CMainFrame::startSlideShowImp() {

	GetRightPane()->m_slideShowDelay = m_slideShow.delay;
	m_currentImage = 0;
	m_lastImage	   = -1;
	m_enableSlideShow = true;
	if (m_slideShow.bStartFullscreen && !GetRightPane()->m_fullScreen)
		OnViewFullscreen();

	if (m_slideShow.bRandom)
		srand(time(NULL));

	//Start the slideshow
	openNextFile();
}


void CMainFrame::openNextFile() {
	
	
	if (!m_slideShow.bSubdirectories || m_slideShow.bUseTextFile) {
		
		CString filename;
		if (!m_slideShow.bRandom) {
			
			if (m_currentImage==m_fileArray.size()) {		
				if (m_slideShow.bCycle) {
					m_currentImage = 0;
				} else {
					stopSlideShow();
					return;
				}
			}
			
			filename = m_fileArray[m_currentImage];
			m_currentImage++;

		} else {
			
			if (m_fileArray.size()==0) {
				stopSlideShow();
				return;
			}
			
			m_currentImage = rand()%m_fileArray.size();
			//Do not want to repeat images
			if (m_slideShow.bCycle && m_fileArray.size()>1) {
				while(m_currentImage==m_lastImage) {
					m_currentImage = rand()%m_fileArray.size();
				}
				m_lastImage = m_currentImage;
			}
			
			filename = m_fileArray[m_currentImage];
			
			
			//If not cycling, then remove the image from the list
			if (!m_slideShow.bCycle) 
				m_fileArray.erase(m_fileArray.begin()+m_currentImage);
		}
		
		//If the document is already being shown, refresh (happens when someone views a dir and then
		//	starts a slideshow there)
		if (filename==GetLeftPane()->GetDocument()->GetPathName())
			OnFileRefresh();
		else
			AfxGetApp()->OpenDocumentFile(filename);

	//Seeking subdirectories
	/*! \todo to be implemented for 6.2 */
	} else {
		
		
	}
}

void CMainFrame::stopSlideShow() {
	m_enableSlideShow = false;
}

LRESULT CMainFrame::OnImageDone(WPARAM wParam, LPARAM lParam) {
	if (m_enableSlideShow)
		openNextFile();
	return 0;
}

void CMainFrame::OnUpdateViewStartslideshow(CCmdUI* pCmdUI) {
	if (m_enableSlideShow) {
		pCmdUI->SetText("Stop Slideshow\tF8");
	} else {
		pCmdUI->SetText("Start Slideshow\tF8");
	}
}


void CMainFrame::OnView9thColumn() {
	GetRightPane()->m_context->m_9thPixel = !GetRightPane()->m_context->m_9thPixel;
	OnFileRefresh();
}

LRESULT CMainFrame::OnSetMessageString (WPARAM wParam, LPARAM lParam)
{
	if (wParam == AFX_IDS_IDLEMESSAGE) {
		static CString s;
		GetRightPane()->GetStatusString(s);
		return CFrameWnd::OnSetMessageString (0, (LPARAM)(const char *)s);
	}
	return CFrameWnd::OnSetMessageString (wParam, lParam);
}
