#include "imageloader.h"
#include "Sauce.h"


__int64 CImageLoader::m_frequency = 0;

CImageLoader::CImageLoader(CImageRenderer *renderer) :
	m_renderer(renderer) 
{

	if (!m_frequency) {
		QueryPerformanceFrequency((LARGE_INTEGER *)&m_frequency);
	}
}

CImageLoader::~CImageLoader() {

}

CImageRenderer *CImageLoader::getRenderer() {
	return m_renderer;
}

Sauce *CImageLoader::loadSauce(FILE *fp) {

	return getSauce(fp);
}

Sauce *CImageLoader::loadSauceFromData(const char *data, int length) {

	return getSauceFromData(data, length);
}

void CImageLoader::baudSimWait(CImageContext *context, CImageData *data) {

	static __int64 waitAmt  = 0;
	static int lastSpeed    = -1;
	
	if (!context->m_recordMovie) {
		if ( context->m_animation==ON || 
			(context->m_animation==DEPENDENT && data->m_animation)) {

			//recalc the wait amount if the baud rate has changed or has not yet been initialized
			if (context->m_speed!=lastSpeed) {
				waitAmt   = m_frequency/(__int64)context->m_speed;
				lastSpeed = context->m_speed;
			}

			//wait the correct amount
			QueryPerformanceCounter((LARGE_INTEGER *)&data->m_curTime);
			while((data->m_curTime-data->m_lastTime)<waitAmt) {
				Sleep(0);				
				QueryPerformanceCounter((LARGE_INTEGER *)&data->m_curTime);
			}
			data->m_lastTime = data->m_curTime;
		}
	}
}

bool CImageLoader::loadFrame(CImageContext *, CImageData *) {
	return true;
}