{$I-}{$F+}
UNIT Graph320;

INTERFACE
Uses Dos,TPCrt,MouseLib,TpString;

Const
 ConvertTrue : Boolean = True;
 GetFBoxX    : Byte = 100;
 GetFBoxY    : Byte = 60;
 MenuColor   : Byte = 23;
 Reverse     : Boolean = False;
 Mask        : String = '*.UBF';
 MaskType    : Array[1..6] of String = ('*.GIF','*.RAW','*.IVP',
                                        '*.FNT','*.UBF','*.PAL');
Type
  PalArray   = Array[0..767] of Byte;
  DACArray   = Array[0..2] of Byte;

Procedure WriteFont(X,Y : Word; Textt : String);
Procedure MakeBeep;
Procedure GetFileName (Var CurrentPath,FileName : String; Action : Byte);
Procedure FillBox(X1,X2,Y1,Y2:Word);
Procedure EraseBox(X1,X2,Y1,Y2:Word);
Procedure FadeInPal(Source : PalArray ; Var Destination : PalArray);
Procedure SetPal(source : PalArray);
Procedure SetColor(A,B,C,D : Byte);
Procedure ErasePal (Var Source : PalArray);
Function FindNearColor (Source : PalArray ; DAColor : DacArray) : Byte;
Procedure WaitKey;

IMPLEMENTATION

Procedure Font; External; {$L FONTCHAR.OBJ}

(********************************************************************)

Procedure WriteFont(X,Y : Word; Textt : String);

Const
 FontTrans : String[99] = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890?!+-()/.,'':;_abcdefghijklmnopqrstuvwxyz=*#$%^&[]{}<>"`~\'
 +' ';

Var
  TrueNumber : Byte;
  I,I1,I2    : Byte;

Begin
  Inc(Y);
  For I := 1 to Length(Textt) do
  Begin
   TrueNumber:=Ord(Textt[I]);
   If ConvertTrue=True then
    Begin
     TrueNumber:=Pos(Textt[I],FontTrans);
     If TrueNumber=0 then TrueNumber:=99;
    End;
   Dec(I);
   Dec(TrueNumber);
   If Reverse=False then
    For I1 := 0 to 4 do
     For I2 := 0 to 5 do
      Mem[$A000:(X+I2+(I*6)+((Y+I1)*320))]:=Mem[Seg(@Font^):(Ofs(@Font^)+(I2*5)+I1+(TrueNumber*30))]
   Else
    For I1 := 0 to 4 do
     For I2 := 0 to 5 do
      Mem[$A000:(X+I2+I*6+((Y+I1)*320))]:=Not Mem[Seg(@Font^):(Ofs(@Font^)+I2*5+I1+TrueNumber*30)];
    Inc(I);
  End;
End;

(**********************************************************************)

Procedure MakeBeep;

Begin
 Sound(5000);
 Delay (10);
 NoSound;
End;


(**********************************************************************)

Function CheckFileChar (Ch : Char) : Boolean;

 Const
  FileTable : String = ('ABCDEFGHIJKLMNOPQRSTUVWXYZ.?*!@#$%^&*()-_+[]:\1234567890');

Begin
 If Pos(Ch,FileTable)>0 then CheckFileChar:=True Else CheckFileChar:=False;
End;

(**********************************************************************)

Procedure FillBox(X1,X2,Y1,Y2:Word);

Var
  I,I1 : Integer;

Begin
  For I := X1 to X2 do For I1 := Y1 to Y2 do
   If Mem[$A000:I+I1*320] = 0 then Mem[$A000:I+I1*320] := 255
   Else Mem[$A000:I+I1*320] := 0;
End;

Procedure FILEBOX1; External; {$L FILEBOX.OBJ}

(**********************************************************************)

Procedure GetFileName (Var CurrentPath,FileName : String; Action : Byte);
 {- Get File Name from the Defined Masks }
 {   Mode: 01 - Load'}
 {         02 - Save'}


 Var
  WriteFileTest         : File;
  KeyMode               : Boolean;
  Behind                : Array [1..91,1..195] of Byte;
  DirInfo               : Array [1..512] of SearchRec;
  DirInfo1              : SearchRec;
  X1,Y1,pos,Pos1,OldPos : Word;
  Ch                    : Char;
  S                     : String;
  Drive                 : Byte;
  W,MouseX,MouseY,MX,MY : Word;
  ReadList,Bool1        : Boolean;
  ListSize              : Word;
  Real1,Real2           : Real;
  ChangeMask            : Boolean;
  IO                    : Integer;

Begin
 ChangeMask:=True;
 OldPos:=0;
 Bool1:=False;
 pos:=1;Pos1:=1;
 ReadList:=True;
 Ch:=#0;
  HideMouseCursor;
  For Y1:=1 to 91 do
   Move(Mem[$A000:((GetFBoxY+Y1-1)*320)+(GetFBoxX)],Behind[Y1,1],195);
  For Y1:=1 to 91 do
   Move(Mem[Seg(@FILEBOX1^):Ofs(@FILEBOX1^)+((Y1-1)*195)],Mem[$A000:((GetFBoxY+Y1-1)*320)+(GetFBoxX)],195); 
   Chdir (CurrentPath);
   Getdir(0,CurrentPath);
   CurrentPath:=CurrentPath+Mask;
  ShowMouseCursor;
  KeyMode:=False;
  Repeat
   HideMouseCursor;
   If Action=1 then S:='Load File' Else S:='Save File';
   WriteFont (GetFBoxX+20,GetFBoxY+2,S);
   If Not KeyMode Then
    Begin
     Drive:=Ord(CurrentPath[1])-64;
     For W:=1 to 5 do
      If Drive=W then WriteFont(GetFBoxX+42,GetFBoxY+25+(W*8),'~') else
       WriteFont(GetFBoxX+42,GetFBoxY+25+(W*8),'`');
     For W:=1 to 6 do
      if Mask=MaskType[W] then WriteFont(GetFBoxX+7,GetFBoxY+25+(W*8),'~') else
       WriteFont(GetFBoxX+7,GetFBoxY+25+(W*8),'`');
     If ChangeMask then
      Begin
       GetDir(Drive,CurrentPath);
       CurrentPath:=AddBackSlash(CurrentPath);
       CurrentPath:=CurrentPath+Mask;
      End
     Else
      Begin
       S:=JustFileName(CurrentPath);
       GetDir(Drive,CurrentPath);
       CurrentPath:=AddBackSlash(CurrentPath);
       CurrentPath:=CurrentPath+S;
      End;
    End;
  WriteFont (GetFBoxX+38,GetFBoxY+12,Copy(Pad(CurrentPath,25),Length(Pad(CurrentPath,25))-24,25));
   If ReadList=True then
    Begin
     ReadList:=False;
     ListSize:=1;
     FindFirst('*.*', $10 , DirInfo1);
      while DosError = 0 do
       Begin
        If (DirInfo1.Attr=$10) And (DirInfo1.Name<>'.') then
         begin
          DirInfo[ListSize]:=DirInfo1;
          Inc(ListSize);
         End;
        FindNext(DirInfo1);
       End;
     DosError:=0;
     FindFirst(CurrentPath, $20 , DirInfo1);
      while DosError = 0 do
       Begin
        DirInfo[ListSize]:=DirInfo1;
        Inc(ListSize);
        FindNext(DirInfo1);
       End;
    End;
   For W:=1 to 7 do
    If (W+Pos1-Pos)<ListSize then
     Begin
      S:=Pad(DirInfo[W+Pos1-pos].Name,12);
      If (pos)=W then Reverse:=True;
      WriteFont(GetFBoxX+62,GetFBoxY+25+(W*8),S);
      Reverse:=False;
     End
    Else
     WriteFont(GetFBoxX+62,GetFBoxY+25+(W*8),'            ');
   If OldPos<>Pos1 then
    Begin
     OldPos:=Pos1;
     W:=ListSize; If W=1 then W:=2;
     Real1:=27/(W-1);
     If (W=1) or (W=2) then Real1:=1;
     EraseBox (GetFBoxX+135,GetFBoxX+147,GetFBoxY+42,GetFBoxY+78);
     FillBox (GetFBoxX+135,GetFBoxX+147,GetFBoxY+41+Trunc(Real1*Pos1),GetFBoxY+51+Trunc(Real1*Pos1));
    End;
   Reverse:=False;
   ShowMouseCursor;
   Repeat until (Keypressed = True) or (Buttonpressed = True);
    If (GetButton(0)=ButtonDown) or (GetButton(1)=ButtonDown) then
    Begin
      MouseX := GetMouseX div 2;
      MouseY := GetMouseY;
      If MouseX>GetFBoxX then MouseX:=MouseX-GetFBoxX else MouseX:=321;
      If MouseY>GetFBoxY then MouseY:=MouseY-GetFBoxY else MouseY:=201;
      If (MouseX >= 0) and (MouseX <= 10) and (MouseY >= 0) and (MouseY <=  10) then
       Begin
        Repeat Until (ButtonReleases(0)>0);
        MouseX := GetMouseX div 2-MouseX;
        MouseY := GetMouseY-MouseY;
        If (MouseX>320) then MouseX:=0 else
         If (MouseX+195>320) then MouseX:=320-195;
        If (MouseY>200) then MouseY:=0 else
         If (MouseY+91>200) then MouseY:=200-91;
         If (MouseX<>GetFBoxX) or (MouseY<>GetFBoxY) then
          Begin
           HideMouseCursor;
           For Y1:=1 to 91 do
            Move(Behind[Y1,1],Mem[$A000:((GetFBoxY+Y1-1)*320)+(GetFBoxX)],195);
            GetFBoxX := MouseX;
            GetFBoxY := MouseY;
           For Y1:=1 to 91 do
            Move(Mem[$A000:((GetFBoxY+Y1-1)*320)+(GetFBoxX)],Behind[Y1,1],195);
            For Y1:=1 to 91 do
             Move(Mem[Seg(@FILEBOX1^):Ofs(@FILEBOX1^)+((Y1-1)*195)],Mem[$A000:((GetFBoxY+Y1-1)*320)+(GetFBoxX)],195);
            OldPos:=0;
           ShowMouseCursor;
          End;
       End;
    If (MouseX >= 1)  and (MouseX <= 38) and (MouseY >= 33) and (MouseY <= 79) then
      Begin Mask:=MaskType[((MouseY-32) DIV 8)+1]; ReadList:=True; ChangeMask:=True; End;
    If (MouseX >= 135)  and (MouseX <= 147) and (MouseY >= 80) and (MouseY <= 89) then
      Begin
       If Pos1<ListSize-1 then
        Begin
         Inc(Pos1);
          If pos<7 then Inc(Pos);
        End;
      End;
    If (MouseX >= 135)  and (MouseX <= 147) and (MouseY >= 31) and (MouseY <= 40) then
      Begin
       If Pos1>1 then
        Begin
         Dec(Pos1);
          If Pos>1 then Dec(Pos);
        End;
      End;
    If ButtonReleases(0)>0 then
     Begin
      If (MouseX >= 1) and (MouseX <=191) and (MouseY >= 12) and (MouseY <= 22) then
       KeyMode:=True;
      If (MouseX >= 151) and (MouseX <= 191) and (MouseY >= 68) and (MouseY <=  76) then
       Begin FillBox(151+GetFBoxX,191+GetFBoxX,68+GetFBoxY,76+GetFBoxY); Ch := Chr(27); FileName:=''; End;
      If (MouseX >= 40)  and (MouseX <= 58) and (MouseY >= 33) and (MouseY <= 71) then
       Begin
        Drive:=((MouseY-32) DIV 8)+1;
        GetDir (Drive,CurrentPath);
        Chdir (CurrentPath);
        ReadList:=True;
        OldPos:=0;
        Pos:=1;Pos1:=1;
       End;
      If (MouseX >= 151)  and (MouseX <= 191) and (MouseY >= 32) and (MouseY <= 40) then
       Begin
        If DirInfo[Pos1].Attr=$20 then
         Begin
          Ch:=#27;
          FileName:=DirInfo[Pos1].Name;
         End
        Else
         Begin MouseX:=60;MouseY:=25+(Pos*8); Bool1:=True; End;
       End;
      If (MouseX >= 151)  and (MouseX <= 191) and (MouseY >= 50) and (MouseY <= 58) then
       Begin
        If DirInfo[Pos1].Attr=$20 then
         Begin
          Ch:=#27;
          FileName:='VIEW:'+DirInfo[Pos1].Name;
         End
       End;
     If (MouseX >= 60)  and (MouseX <= 133) and (MouseY >= 33) and (MouseY <= 88) then
      If Bool1=True then
       Begin
        Bool1:=False;
        if Pos=(((MouseY-32) DIV 8)+1) then
          If DirInfo[Pos1].Attr=Directory then
           Begin
            ReadList:=True;
            Chdir (DirInfo[Pos1].Name);
            Pos1:=1;Pos:=1;OldPos:=0;
           End;
       End;
     End;
     If (MouseX >= 60)  and (MouseX <= 133) and (MouseY >= 33) and (MouseY <= 87) then
      If ListSize>(Pos1-Pos+((MouseY-32) DIV 8)+1) then
       If ReadList=False then
        Begin
         Pos1:=Pos1-Pos;
         Pos:=((MouseY-32) DIV 8)+1;
         Pos1:=Pos1+Pos;
         If Bool1=False then Bool1:=True;
        End;
    End;
   If KeyPressed=True then
    Begin
     Ch:=ReadKey;
     If Ch=#27 then FileName:='';
      If KeyMode=True then
       Begin
        If Ch=#8 then Delete(CurrentPath,Length(CurrentPath),1);
        If Ch=#13 then Begin
                        If Action=1 then
                         Begin
                          ChangeMask:=False;
                          ReadList:=True;
                          KeyMode:=False;
                          Pos:=1;Pos1:=1;OldPos:=0;
                          S:=JustFileName(CurrentPath);
                          CurrentPath:=JustPathName(CurrentPath);
                          CurrentPath:=CleanPathName(CurrentPath);
                          Chdir (CurrentPath);
                          GetDir(0,CurrentPath);
                          CurrentPath:=AddBackSlash(CurrentPath);
                          CurrentPath:=CurrentPath+S;
                         End
                        Else
                         Begin
                          ChangeMask:=False;
                          ReadList:=True;
                          KeyMode:=False;
                          Pos:=1;Pos1:=1;OldPos:=0;
                          S:=JustFileName(CurrentPath);
                          CurrentPath:=JustPathName(CurrentPath);
                          CurrentPath:=CleanPathName(CurrentPath);
                          Chdir (CurrentPath);
                          GetDir(0,CurrentPath);
                          CurrentPath:=AddBackSlash(CurrentPath);
                          CurrentPath:=CurrentPath+S;
                          Assign (WriteFileTest,CurrentPath);
                          Rewrite (WriteFileTest);
                          IO:=IOResult;
                          If IO=0 then
                           Begin
                            Ch:=#27;
                            FileName:=JustFileName(CurrentPath);
                           End;
                          Close(WriteFileTest);
                         End;
                       End;
        Ch:=UpCase(Ch);
        if CheckFileChar(Ch) then
         Begin
          If Length(CurrentPath)<80 then CurrentPath:=CurrentPath+Ch;
          MakeBeep;
         End;
       End;
    End;
  Until Ch=#27;
  HideMouseCursor;
  For Y1:=1 to 91 do
   Move(Behind[Y1,1],Mem[$A000:((GetFBoxY+Y1-1)*320)+(GetFBoxX)],195);
  CurrentPath:=JustPathName(CurrentPath);
  ShowMouseCursor;
End;

(**********************************************************************)

Procedure EraseBox(X1,X2,Y1,Y2:Word);

Var
  I,I1 : Integer;

Begin
  For I := X1 to X2 do For I1 := Y1 to Y2 do
   Mem[$A000:I+I1*320] := 0;
End;

(**********************************************************************)

Procedure FadeInPal(Source : PalArray ; Var Destination : PalArray);

Var
  I,I1 : word;
Begin
 For I1:=0 to 63 Do
  Begin
   For I:=0 to 767 do
    If Source[I]>Destination[I] then Inc(Destination[I]) else
     If Source[I]<Destination[I] then Dec(Destination[I]);
   SetPal (Destination);
  End;
End;

 (**************************************************************************)

Procedure SetPal(Source : PalArray);

 Var
   I : Byte;
   Segment,Ofset : Word;

Begin
  Segment:=Seg (Source);
  Ofset:=Ofs (Source);
  Asm
      PUSH DS
      MOV AX,Segment
      MOV DS,AX
      MOV CX,$300
      MOV SI,Ofset
      MOV DX,03DAh
@VR2: IN  AL,DX
      TEST AL,08
      JZ @VR2
@VR1: IN  AL,DX
      TEST AL,08
      JNZ @VR1
      MOV DX,$03C8
      XOR AL,AL
      OUT DX,AL
      INC DX
  REP OUTSB
      POP DS
  End;
End;

 (**************************************************************************)

Procedure SetColor(A,B,C,D : Byte);

Begin
  Asm
      MOV DX,03DAh
@VR2: IN  AL,DX
      TEST AL,08
      JZ @VR2
@VR1: IN  AL,DX
      TEST AL,08
      JNZ @VR1
      MOV DX,$03C8
      MOV AL,D
      OUT DX,AL
      INC DX
      MOV AL,A
      OUT DX,AL
      MOV AL,B
      OUT DX,AL
      MOV AL,C
      OUT DX,AL
 End;
End;

 (**************************************************************************)

Procedure ErasePal (Var Source : PalArray);

 Var
   Segment,Ofset : Word;

Begin
  Segment:=Seg (Source);
  Ofset:=Ofs (Source);
{$F+}
  Asm
      PUSH ES
      MOV  AX,Segment
      MOV  ES,AX
      MOV  DI,Ofset
      MOV  CX,384
      XOR  AX,AX
      REP  STOSW
      POP  ES
  End;
{$F-}
End;

 (**************************************************************************)

Function FindNearColor (Source : PalArray ; DAColor : DacArray) : Byte;

Var
 I : Byte;
 LastNear,MinSub,CurSub : Byte;

Begin
 LastNear:=0;
 MinSub:=255;
 For I:=0 to 255 do
  Begin
   CurSub:=Abs(Source[I*3]-DAColor[0])+Abs(Source[I*3+1]-DAColor[1])+Abs(Source[I*3+2]-DAColor[2]);
   If MinSub>CurSub then
    Begin MinSub:=CurSub; LastNear:=I; End;
  End;
 FindNearColor:=LastNear;
End;

 (**************************************************************************)

Procedure WaitKey;

 Var
  Ch : Char;

 Begin
  Ch:=#00;
  Repeat Until (KeyPressed) Or (ButtonPressed);
   If KeyPressed Then Ch:=ReadKey;
   Ch:=#00;
 End;
End.
