/* For license details see bottom.
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 */

// system includes
#include <caosGL/core/globals.h>
#include <caosGL/core/types.h>

// package includes
#include <caosGL/gfx/cState.h>

// extern includes
#include <caosGL/core/cParser.h>

#include <caosGL/gfx/cLight.h>

using namespace caosGL::gfx;

namespace caosGL {
	namespace gfx {
		/**
		 *<br> class:		cLight
		 *<br> namespace:	caosGL::gfx
		 *<br> inherits:	caosGL::gfx::cBaseNode
		 *<br> implements:	<none>
		 *<br> purpose:		Implements the basic light functionality in openGL.
		 *              TODO: fix it, it's quite broken!!
		 *
		 */

		static vector <tAttr> attributeNames;
		static log4cpp::Category& cat = log4cpp::Category::getInstance ("caosGL::gfx::cLight");

		/********************************************************************************************/
		cLight::cLight (const string & n, cGroup * f) : super (n,f) {
			init ();
		}

		/********************************************************************************************/
		cLight::~cLight () {
		}

		/********************************************************************************************/
		tVoid cLight::trasform (cTransform * transpose) {
		}

		/********************************************************************************************/
		const cTransform * cLight::trasform () const {
			return cNULL;
		}

		/********************************************************************************************/
		cTransform * cLight::trasform () {
			return cNULL;
		}

		// from cBaseNode
		/********************************************************************************************/
		tBool cLight::compile () {
			return true;
		}

		// from cBaseNode
		/********************************************************************************************/
		tBool cLight::visit (tFloat t) {
			if (!evaluateAll (t)) return false;
			GLfloat a[4]; // ambient
			GLfloat d[4]; // diffiuse
			GLfloat p[4]; // position

			// set
			p[0] = _tX;   p[1] = _tY;   p[2] = _tZ; 
			a[0] = _scoR; a[1] = _scoG; a[2] = _scoB; 
			d[0] = _colR; d[1] = _colG; d[2] = _colB; 


			glLightfv (cState::oGL_LIGHT0 + _num, GL_AMBIENT,  a);
			glLightfv (cState::oGL_LIGHT0 + _num, GL_DIFFUSE,  d);
			glLightfv (cState::oGL_LIGHT0 + _num, GL_POSITION, p);
			cState::enable ((cState::eState)(cState::oGL_LIGHT0+_num));

			return true;
		}

		// from cBaseNode
		/********************************************************************************************/
		tVoid cLight::leave () {
			return;
		}

		// from cBaseNode
		/********************************************************************************************/
		tBool cLight::init () {
			#define ATTRIB(n,t,v,d) ATTRIB_INIT_VAR(n,v)
			#include cLight_attribsFile
			#undef ATTRIB
			return true;
		}

		// from cBaseNode
		/********************************************************************************************/
		const tBool cLight::set (const tDWord key, const string & value) {
			if (super::set (key, value)) return true;
			switch (key) {
				#define ATTRIB(n,t,v,d) ATTRIB_SET_S(n)
				#include cLight_attribsFile
				#undef ATTRIB
			case '    ': return false;
			default: return false;
			}
			return false;
		}

		// from cBaseNode
		/********************************************************************************************/
		const tBool cLight::set (const tDWord key, const tFloat & value) {
			if (super::set (key, value)) return true;
			switch (key) {
				#define ATTRIB(n,t,v,d) ATTRIB_SET_N(n)
				#include cLight_attribsFile
				#undef ATTRIB
			case '    ': return false;
			default: return false;
			}
			return false;
		}

		// from cBaseNode
		/********************************************************************************************/
		const tBool cLight::get (const tDWord key, string & value) const {
			if (super::get (key, value)) return true;
			switch (key) {
				#define ATTRIB(n,t,v,d) ATTRIB_GET(n)
				#include cLight_attribsFile
				#undef ATTRIB
			case '    ': return false;
			default: return false;
			}
			return false;
		}

		// from cBaseNode
		/********************************************************************************************/
		const vector <tAttr> * cLight::getAttributeNames () const {
			if (attributeNames.size () == 0) {
				const vector <tAttr> * v = super::getAttributeNames ();
				attributeNames.insert (attributeNames.begin (), v->begin (), v->end ());
				#define ATTRIB(n,t,v,d) ATTRIB_ATTRIBNAMES(n,d)
				#include cLight_attribsFile
				#undef ATTRIB
			}
			return &attributeNames;
		}

		// from cBaseNode
		/********************************************************************************************/
		const string cLight::getTypeName () const { return "caosGL::gfx::cLight"; }
	}
}

// for node creation
#include <caosGL/core/cRegistry.h>
#include <caosGL/gfx/cNodeCreator.h>

class cLightNodeCreator : public cNodeCreator {
public:
	cLightNodeCreator () {
		name ("caosGL::gfx::cLight");
	}
	cBaseNode * createNode (const string n, cGroup * f) {
		return new caosGL::gfx::cLight (n,f);
	}
};
caosGL::core::cRegisterNodeCreator <cLightNodeCreator> cLightNodeCreatorInstance;

/**
 * The Catalyst of Design Software License, Version 1.0
 *
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by 
 *        Catalyst of Design (http://talsit.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "caosGL" and "Catalyst of Design" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact caosGL@talsit.org.
 *
 * 5. Products derived from this software may not be called "caosGL",
 *    nor may "caosGL" appear in their name, without prior written
 *    permission of Catalyst of Design.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CATALYST OF DESIGN OR ITS 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 */
// eof