/* For license details see bottom.
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 */

// system includes
#include <caosGL/core/globals.h>
#include <caosGL/core/types.h>

// package includes
#include <caosGL/gfx/cScene.h>

// extern includes
#include <caosGL/core/math.h>
#include <caosGL/core/cParser.h>
#include <caosGL/core/Dyngl.h>
#include <caosGL/core/cOpenGLWindow.h>
#include <caosGL/core/cGLTexture.h>
#include <caosGL/gfx/cTextureSpace.h>
#include <caosGL/gfx/cState.h>
#include <caosGL/gfx/cMatrix.h>
#include <GL/glu.h>

using namespace caosGL::gfx;
using namespace caosGL::core;

#define cProjectionCube_attribsFile <caosGL/effects/cProjectionCube.attribs>

namespace caosGL {
	namespace effects {
		static vector <tAttr> attributeNames;
		static log4cpp::Category& cat = log4cpp::Category::getInstance ("caosGL::effects::cProjectionCube");

		/**
		 *<br> class:		cProjectionCube
		 *<br> namespace:	caosGL::effects
		 *<br> inherits:	caosGL::gfx::cScene
		 *<br> implements:	<none>
		 *<br> purpose:		It should actually be called cProjectionPlane, but i got side tracked doing
		 *					and instead of cubes, i draw just planes. It projects the texture on the 
		 *                  planes that are infront of a camera. You can also move the scene around.
		 *
		 */

		class CAOSGL_API cProjectionCube : public cScene {
			typedef cScene super;
		private:
			#define ATTRIB(n,t,v,d) ATTRIB_DEFINE_VAR(n,t)
			#include cProjectionCube_attribsFile
			#undef ATTRIB
			cGLTexture * _img;
			tInt _list;

		public:
			/********************************************************************************************/
			cProjectionCube (const string n, cGroup * f) : super (n,f) {
				init ();
			}

			/********************************************************************************************/
			~cProjectionCube () {
			}

			// from iDrawable
			/********************************************************************************************/
			tBool draw (const tFloat time) {
				if (_img) {
					_img->prepare ();
				}

				glColor4d (1, 1, 1, _alph);
				cState::disable (cState::oGL_LIGHTING);
				cState::enable (cState::oGL_TEXTURE_2D);
				cState::enable (cState::oGL_BLEND);
				glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);


				tInt vp [4];
				double mm [16], pm[16];

				cMatrix mmm, pmm, tm;
				glGetIntegerv (GL_VIEWPORT, vp);

				tInt numWide = 10;
				tInt numHigh = 7;
				glScalef (0.7,0.7,0.7);

				glMatrixMode(GL_PROJECTION);
				glLoadIdentity();

				gluPerspective (45.0,1.3,1,100.0);
				glTranslatef (0, 0, -6);

				glGetDoublev (GL_PROJECTION_MATRIX, pm);
				pmm.set (pm);

				glLoadIdentity();

				gluPerspective (45.0,1.3,1,100.0);
				glTranslatef (0, 0, -6);
				glRotated (_crX, 1,0,0);
				glRotated (_crY, 0,1,0);
				glRotated (_crZ, 0,0,1);
				

				glMatrixMode(GL_MODELVIEW);
				glLoadIdentity();

				glScaled (_scl, _scl, _scl);
				for (tInt y = 0; y < numHigh; y++) {
					for (tInt x = 0 ; x < numWide; x++) {
						tFloat x0,x1,x2,x3,y0,y1,y2,y3;
						double u0,u1,u2,u3,v0,v1,v2,v3,w; // don't use w, but need it...

						glPushMatrix ();
						glTranslated ((x-(numWide>>1)), (y-(numHigh>>1)), 0);
						glRotated (_orX, 1,0,0);
						glRotated (_orY, 0,1,0);
						glRotated (_orZ, 0,0,1);

						glGetDoublev (GL_MODELVIEW_MATRIX, mm);

						x0 =  1.0; y0 = -1.0;
						x1 = -1.0; y1 = -1.0;
						x2 = -1.0; y2 =  1.0;
						x3 =  1.0; y3 =  1.0;
						gluProject (x0, y0, 0.0, mm, pm, vp, &u0, &v0, &w);
						gluProject (x1, y1, 0.0, mm, pm, vp, &u1, &v1, &w);
						gluProject (x2, y2, 0.0, mm, pm, vp, &u2, &v2, &w);
						gluProject (x3, y3, 0.0, mm, pm, vp, &u3, &v3, &w);

						glBegin (GL_QUADS); {
							glTexCoord2d (u0/vp[2], v0/vp[3]); glVertex3d (x0, y0, 0.0);
							glTexCoord2d (u1/vp[2], v1/vp[3]); glVertex3d (x1, y0, 0.0);
							glTexCoord2d (u2/vp[2], v2/vp[3]); glVertex3d (x2, y2, 0.0);
							glTexCoord2d (u3/vp[2], v3/vp[3]); glVertex3d (x3, y2, 0.0);
						} glEnd ();

						glPopMatrix ();
					} 
				}

				return true;
			}

			// from iDrawable
			/********************************************************************************************/
			tBool transparent () const {
				return _alph<1;
			}

			// from iDrawable
			/********************************************************************************************/
			tVoid transparent (const tBool trasnp) {
			}

			// from cBaseNode
			/********************************************************************************************/
			tBool compile () {
				_img = cTextureSpace::instance ()->get (_tex);
				if (!_img)
					return false;
				return true;
			}

			// from cBaseNode
			/********************************************************************************************/
			tBool visit (tFloat t) {
				evaluateAll (t);
				if (!cBaseNode::visit (t))
					return false;

				return true;
			}

			// from cBaseNode
			/********************************************************************************************/
			tVoid leave () {
				return;
			}

			// from cBaseNode
			/********************************************************************************************/
			tBool init () {
				#define ATTRIB(n,t,v,d) ATTRIB_INIT_VAR(n,v)
				#include cProjectionCube_attribsFile
				#undef ATTRIB
				_list = -1;
				_img = cNULL;
				return true;
			}

			// from cBaseNode
			/********************************************************************************************/
			const tBool set (const tDWord key, const string & value) {
				if (super::set (key, value)) return true;
				switch (key) {
					#define ATTRIB(n,t,v,d) ATTRIB_SET_S(n)
					#include cProjectionCube_attribsFile
					#undef ATTRIB
				case '    ': return false;
				default: return false;
				}
				return false;
			}

			// from cBaseNode
			/********************************************************************************************/
			const tBool set (const tDWord key, const tFloat & value) {
				if (super::set (key, value)) return true;
				switch (key) {
					#define ATTRIB(n,t,v,d) ATTRIB_SET_N(n)
					#include cProjectionCube_attribsFile
					#undef ATTRIB
				case '    ': return false;
				default: return false;
				}
				return false;
			}

			// from cBaseNode
			/********************************************************************************************/
			const tBool get (const tDWord key, string & value) const {
				if (super::get (key, value)) return true;
				switch (key) {
					#define ATTRIB(n,t,v,d) ATTRIB_GET(n)
					#include cProjectionCube_attribsFile
					#undef ATTRIB
				case '    ': return false;
				default: return false;
				}
				return false;
			}

			// from cBaseNode
			/********************************************************************************************/
			const vector <tAttr> * getAttributeNames () const {
				if (attributeNames.size () == 0) {
					const vector <tAttr> * v = super::getAttributeNames ();
					attributeNames.insert (attributeNames.begin (), v->begin (), v->end ());
					#define ATTRIB(n,t,v,d) ATTRIB_ATTRIBNAMES(n,d)
					#include cProjectionCube_attribsFile
					#undef ATTRIB
				}
				return &attributeNames;
			}

			// from cBaseNode
			/********************************************************************************************/
			const string getTypeName () const { return "caosGL::effects::cProjectionCube"; }
		};
	}
}

// for node creation
#include <caosGL/core/cRegistry.h>
#include <caosGL/gfx/cNodeCreator.h>

class cProjectionCubeNodeCreator : public cNodeCreator {
public:
	cProjectionCubeNodeCreator () {
		name ("caosGL::effects::cProjectionCube");
	}
	cBaseNode * createNode (const string n, cGroup * f) {
		return new caosGL::effects::cProjectionCube (n,f);
	}
};
caosGL::core::cRegisterNodeCreator <cProjectionCubeNodeCreator> cProjectionCubeNodeCreatorInstance;

/**
 * The Catalyst of Design Software License, Version 1.0
 *
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by 
 *        Catalyst of Design (http://talsit.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "caosGL" and "Catalyst of Design" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact caosGL@talsit.org.
 *
 * 5. Products derived from this software may not be called "caosGL",
 *    nor may "caosGL" appear in their name, without prior written
 *    permission of Catalyst of Design.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CATALYST OF DESIGN OR ITS 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 */
// eof