/* For license details see bottom.
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 */

// system includes
#include <caosGL/core/globals.h>
#include <caosGL/core/types.h>

// package includes
#include <caosGL/gfx/cScene.h>

// extern includes
#include <caosGL/core/math.h>
#include <caosGL/core/cParser.h>
#include <caosGL/core/Dyngl.h>
#include <caosGL/core/cOpenGLWindow.h>
#include <caosGL/core/cGLTexture.h>
#include <caosGL/gfx/cTextureSpace.h>
#include <caosGL/gfx/cState.h>
#include <caosGL/gfx/cMatrix.h>
#include <GL/glu.h>

using namespace caosGL::gfx;
using namespace caosGL::core;

#define cMarque_attribsFile <caosGL/effects/cMarque.attribs>

namespace caosGL {
	namespace effects {
		static vector <tAttr> attributeNames;
		static log4cpp::Category& cat = log4cpp::Category::getInstance ("caosGL::effects::cMarque");

		/**
		 *<br> class:		cMarque
		 *<br> namespace:	caosGL::effects
		 *<br> inherits:	caosGL::gfx::cScene
		 *<br> implements:	<none>
		 *<br> purpose:		Divides the screen into rows and columns and draws a texture in each
		 *					of the spaces. You can toggle each one on or off.
		 *
		 */

		class CAOSGL_API cMarque : public cScene {
			typedef cScene super;
		private:
			#define ATTRIB(n,t,v,d) ATTRIB_DEFINE_VAR(n,t)
			#include cMarque_attribsFile
			#undef ATTRIB
			cGLTexture * _img;
			tInt _listBase;
			tBool * _list;

		public:
			/********************************************************************************************/
			cMarque (const string n, cGroup * f) : super (n,f) {
				init ();
			}

			/********************************************************************************************/
			~cMarque () {
			}

			// from iDrawable
			/********************************************************************************************/
			tBool draw (const tFloat time) {
				if (_img) {
					_img->prepare ();
				}

				glColor4d (1, 1, 1, _alph);
				cState::disable (cState::oGL_LIGHTING);
				cState::disable (cState::oGL_DEPTH_TEST);
				cState::enable (cState::oGL_TEXTURE_2D);
				cState::enable (cState::oGL_BLEND);
				glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

				glMatrixMode(GL_PROJECTION);
				glPushMatrix ();
				glLoadIdentity();

				glMatrixMode(GL_MODELVIEW);
				glLoadIdentity();

				for (tInt i = _rows * _cols; i-->0;)
					if (_list [i])
						glCallList (_listBase+i);

				
				glPopMatrix ();
				glMatrixMode(GL_PROJECTION);
				glPopMatrix ();
				return true;
			}

			// from iDrawable
			/********************************************************************************************/
			tBool transparent () const {
				return _alph<1;
			}

			// from iDrawable
			/********************************************************************************************/
			tVoid transparent (const tBool trasnp) {
			}

			// from cBaseNode
			/********************************************************************************************/
			tBool compile () {
				if (_tex != "")
					_img = cTextureSpace::instance ()->get (_tex);
				if (!_img) {
					cat.error ("%s::%s: this effect needs an texture.", getTypeName().c_str(), _name.c_str());
					return false;
				}

				_listBase = glGenLists (_rows * _cols);
				_list = new tBool [_rows * _cols];
				for (tInt i = _rows * _cols; i-->0;)
					_list [i] = true;
				tInt count = 0;

				for (i = _cols ; i-->0;) {
					for (tInt j = _rows ; j-->0;) {
						glNewList (_listBase+count++, GL_COMPILE); {
							glLoadIdentity ();
							glTranslated (2.0*i/_cols - 1 + (1.0/_cols), 2.0*j/_rows - 1 + (1.0/_rows), 0);
							glScaled (1.0/_cols, 1.0/_rows, 1);

							glBegin (GL_QUADS); {
								glTexCoord2f (0.0f, 1.0f); glVertex3f ( 1.0, 1.0, 0);
								glTexCoord2f (0.0f, 0.0f); glVertex3f ( 1.0,-1.0, 0);
								glTexCoord2f (1.0f, 0.0f); glVertex3f (-1.0,-1.0, 0);
								glTexCoord2f (1.0f, 1.0f); glVertex3f (-1.0, 1.0, 0);
							} glEnd ();
						} glEndList ();
					}
				}
				
				return true;
			}

			// from cBaseNode
			/********************************************************************************************/
			tBool visit (tFloat t) {
				evaluateAll (t);
				if (!cBaseNode::visit (t))
					return false;

				return true;
			}

			// from cBaseNode
			/********************************************************************************************/
			tVoid leave () {
				return;
			}

			// from cBaseNode
			/********************************************************************************************/
			tBool init () {
				#define ATTRIB(n,t,v,d) ATTRIB_INIT_VAR(n,v)
				#include cMarque_attribsFile
				#undef ATTRIB
				_img = cNULL;
				return true;
			}

			// from cBaseNode
			/********************************************************************************************/
			const tBool set (const tDWord key, const string & value) {
				if (super::set (key, value)) return true;
				switch (key) {
					#define ATTRIB(n,t,v,d) ATTRIB_SET_S(n)
					#include cMarque_attribsFile
					#undef ATTRIB
				case 'on': {
					tInt which = cParser::parseInt(value);
					if (which<0 || which>(_rows*_cols-1)) return false;
					_list [which] = true;
				} return true;
				case 'off': {
					tInt which = cParser::parseInt(value);
					if (which<0 || which>(_rows*_cols-1)) return false;
					_list [which] = false;
				} return true;
				case '    ': return false;
				default: return false;
				}
				return false;
			}

			// from cBaseNode
			/********************************************************************************************/
			const tBool set (const tDWord key, const tFloat & value) {
				if (super::set (key, value)) return true;
				switch (key) {
					#define ATTRIB(n,t,v,d) ATTRIB_SET_N(n)
					#include cMarque_attribsFile
					#undef ATTRIB
				case '    ': return false;
				default: return false;
				}
				return false;
			}

			// from cBaseNode
			/********************************************************************************************/
			const tBool get (const tDWord key, string & value) const {
				if (super::get (key, value)) return true;
				switch (key) {
					#define ATTRIB(n,t,v,d) ATTRIB_GET(n)
					#include cMarque_attribsFile
					#undef ATTRIB
				case '    ': return false;
				default: return false;
				}
				return false;
			}

			// from cBaseNode
			/********************************************************************************************/
			const vector <tAttr> * getAttributeNames () const {
				if (attributeNames.size () == 0) {
					const vector <tAttr> * v = super::getAttributeNames ();
					attributeNames.insert (attributeNames.begin (), v->begin (), v->end ());
					#define ATTRIB(n,t,v,d) ATTRIB_ATTRIBNAMES(n,d)
					#include cMarque_attribsFile
					#undef ATTRIB
					attributeNames.push_back(make_pair('on',string("Turns an individual image on")));
					attributeNames.push_back(make_pair('off',string("Turns an individual image off")));
				}
				return &attributeNames;
			}
			// from cBaseNode
			/********************************************************************************************/
			const string getTypeName () const { return "caosGL::effects::cMarque"; }
		};
	}
}

// for node creation
#include <caosGL/core/cRegistry.h>
#include <caosGL/gfx/cNodeCreator.h>

class cMarqueNodeCreator : public cNodeCreator {
public:
	cMarqueNodeCreator () {
		name ("caosGL::effects::cMarque");
	}
	cBaseNode * createNode (const string n, cGroup * f) {
		return new caosGL::effects::cMarque (n,f);
	}
};
caosGL::core::cRegisterNodeCreator <cMarqueNodeCreator> cMarqueNodeCreatorInstance;

/**
 * The Catalyst of Design Software License, Version 1.0
 *
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by 
 *        Catalyst of Design (http://talsit.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "caosGL" and "Catalyst of Design" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact caosGL@talsit.org.
 *
 * 5. Products derived from this software may not be called "caosGL",
 *    nor may "caosGL" appear in their name, without prior written
 *    permission of Catalyst of Design.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CATALYST OF DESIGN OR ITS 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 */
// eof