/* For license details see bottom.
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 */

/**
 *<br> class:		<none>
 *<br> namespace:	caosGL::core
 *<br> inherits:	<none>
 *<br> implements:	<none>
 *<br> purpose:		
 *
 */

// system includes
#include <caosGL/core/globals.h>
#include <caosGL/core/types.h>

// package includes
#include <caosGL/core/build.h>

// extern includes
#include <log4cpp/Category.hh>
#include <log4cpp/Appender.hh>
#include <log4cpp/OstreamAppender.hh>
#include <log4cpp/FileAppender.hh>
#include <log4cpp/Layout.hh>
#include <log4cpp/BasicLayout.hh>
#include <log4cpp/NDC.hh>

#include <windows.h>
#include <stdio.h>
#include <iostream>
#include <caosGL/core/cParser.h>
#include <caosGL/core/Dyngl.h>
#include <caosGL/core/cSystem.h>
#include <caosGL/core/cRegistry.h>
#include <caosGL/core/cLibraryLoader.h>
#include <caosGL/core/cVFS.h>
#include <caosGL/core/cUtil.h>

#include <caosGL/core/resource.h>

tBool init ();
tBool setLogging ();
void initNiceStuff ();

CAOSGL_API tInt versionMajor = 1;
CAOSGL_API tInt versionMinor = 0;
CAOSGL_API tInt versionPatch = BUILD;
log4cpp::Category * cat;
HANDLE hModule;

/********************************************************************************************/
BOOL APIENTRY DllMain( HANDLE hMod, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 ) {
	hModule = hMod;
    switch (ul_reason_for_call)
	{
		case DLL_PROCESS_ATTACH:
			if (!init ()) {
				MessageBox(0,"Could not initialize caosGL, have a nice day..","caosGL",MB_OK|MB_ICONSTOP);
//				return FALSE;
			}
			break;
		case DLL_THREAD_ATTACH:
			break;
		case DLL_THREAD_DETACH:
			break;
		case DLL_PROCESS_DETACH:
			break;
    }
    return TRUE;
}

/********************************************************************************************/
tBool init () {
	setLogging ();

 	cat->info ("the caosGL system v%d.%d.%d is loading", versionMajor, versionMinor, versionPatch);
	int oglRet = dynglLoad ();
	if (oglRet == 1) {
		cat->error ("OpenGL already loaded");
	} else if (oglRet == 2) {
		cat->emerg ("OpenGL could not be loaded");
	} else if (oglRet == 0) {
		cat->info ("OpenGL loaded successfully");
	}

	cSystem * sys = cSystem::instance ();
	cVFS::instance ()->registerCaos (sys->get ("cfsFile"));
//	cLibraryLoader::instance ()->loadLibraries ();

	cUtil::printAll(*cat, log4cpp::Priority::INFO, "System properties: %s", sys->toString ().c_str ());
	cUtil::printAll(*cat, log4cpp::Priority::INFO, "Registered nodes: %s", cRegistry::instance ()->toString ().c_str ());

	if (cParser::parseBool(sys->get("pedantic")))
		initNiceStuff ();

	return true;
}

/********************************************************************************************/
tBool setLogging () {

	cat = &log4cpp::Category::getRoot();
	cSystem * sys = cSystem::instance ();

	tBool loggingConsole = cParser::parseBool (sys->get ("loggingConsole"));
	if (loggingConsole) {
		log4cpp::Appender * app = new log4cpp::OstreamAppender ("default", &std::cout);
		log4cpp::Layout* layout = new log4cpp::BasicLayout();
		app->setLayout(layout);
		cat->addAppender (app);
	}

	string loggingFile = sys->get ("loggingFile");
	if (loggingFile != "null") {
		log4cpp::Appender * app = new log4cpp::FileAppender ("file", loggingFile.c_str (), true);
		log4cpp::Layout* layout = new log4cpp::BasicLayout();
		app->setLayout(layout);
		cat->addAppender (app);
	}

	tInt loggingLevel = cParser::parseInt (sys->get ("loggingLevel"));
	cat->setPriority (loggingLevel);

	return true;
}

/***********************************************************/
/*                                                         */
/*                                                         */
/*                                                         */
/*                                                         */
/*                                                         */
/***********************************************************/


HDC hdcCompatible;

HBITMAP caosGLBitMap;
PBITMAPINFO caosGLBitMapInfo;
unsigned char * caosGLBuf;

HBITMAP captureBitMap;
PBITMAPINFO captureBitMapInfo;
unsigned char * captureBuf;

HBITMAP tempBitMap;
PBITMAPINFO tempBitMapInfo;
unsigned char * tempBuf;

int sw;
int sh;
int iw;
int ih;
int w;
int h;
void step (int w);

PBITMAPINFO CreateBitmapInfoStruct(HBITMAP hBmp)
{ 
    BITMAP bmp; 
    PBITMAPINFO pbmi; 
    WORD    cClrBits; 
	
    // Retrieve the bitmap's color format, width, and height. 
    GetObject(hBmp, sizeof(BITMAP), (LPSTR)&bmp);
	
    // Convert the color format to a count of bits. 
    cClrBits = (WORD)(bmp.bmPlanes * bmp.bmBitsPixel); 
    if (cClrBits == 1) 
        cClrBits = 1; 
    else if (cClrBits <= 4) 
        cClrBits = 4; 
    else if (cClrBits <= 8) 
        cClrBits = 8; 
    else if (cClrBits <= 16) 
        cClrBits = 16; 
    else if (cClrBits <= 24) 
        cClrBits = 24; 
    else cClrBits = 32; 
	
    // Allocate memory for the BITMAPINFO structure. (This structure 
    // contains a BITMAPINFOHEADER structure and an array of RGBQUAD 
    // data structures.) 
	
	if (cClrBits != 24) 
		pbmi = (PBITMAPINFO) malloc (sizeof(BITMAPINFOHEADER) + sizeof(RGBQUAD) * (1<< cClrBits)); 
	
	// There is no RGBQUAD array for the 24-bit-per-pixel format. 
	
	else 
		pbmi = (PBITMAPINFO) malloc (sizeof(BITMAPINFOHEADER)); 
	
    // Initialize the fields in the BITMAPINFO structure. 
	
    pbmi->bmiHeader.biSize = sizeof(BITMAPINFOHEADER); 
    pbmi->bmiHeader.biWidth = bmp.bmWidth; 
    pbmi->bmiHeader.biHeight = bmp.bmHeight; 
    pbmi->bmiHeader.biPlanes = bmp.bmPlanes; 
    pbmi->bmiHeader.biBitCount = bmp.bmBitsPixel; 
    if (cClrBits < 24) 
        pbmi->bmiHeader.biClrUsed = (1<<cClrBits); 
	
    // If the bitmap is not compressed, set the BI_RGB flag. 
    pbmi->bmiHeader.biCompression = BI_RGB; 
	
    // Compute the number of bytes in the array of color 
    // indices and store the result in biSizeImage. 
    pbmi->bmiHeader.biSizeImage = (pbmi->bmiHeader.biWidth + 7) /8 
		* pbmi->bmiHeader.biHeight * cClrBits;
	// Set biClrImportant to 0, indicating that all of the 
    // device colors are important. 
	pbmi->bmiHeader.biClrImportant = 0; 
	return pbmi; 
 } 

void initNiceStuff () {
	HDC hdcScreen = GetDC(0); 
	sw = GetDeviceCaps (hdcScreen, HORZRES);
	sh = GetDeviceCaps (hdcScreen, VERTRES);

	caosGLBitMap = LoadBitmap ((HINSTANCE)hModule, MAKEINTRESOURCE (IDB_CAOSGL));
	caosGLBitMapInfo = CreateBitmapInfoStruct (caosGLBitMap);
	iw = caosGLBitMapInfo->bmiHeader.biWidth;
	ih = caosGLBitMapInfo->bmiHeader.biHeight;

	hdcCompatible = CreateCompatibleDC(hdcScreen); 

	w = iw;
	h = ih;
	int bpp = GetDeviceCaps (hdcScreen, BITSPIXEL);

	captureBitMap = CreateCompatibleBitmap (hdcScreen,w,h); 
	tempBitMap = CreateCompatibleBitmap (hdcScreen,w,h); 

	SelectObject (hdcCompatible, captureBitMap);

	BitBlt (hdcCompatible, 0, 0, w, h, hdcScreen, sw/2-iw/2, sh/2-ih/2, SRCCOPY);

	captureBitMapInfo = CreateBitmapInfoStruct (captureBitMap);
	tempBitMapInfo = CreateBitmapInfoStruct (tempBitMap);

	caosGLBuf = new unsigned char [caosGLBitMapInfo->bmiHeader.biSizeImage];
	captureBuf = new unsigned char [captureBitMapInfo->bmiHeader.biSizeImage];
	tempBuf = new unsigned char [tempBitMapInfo->bmiHeader.biSizeImage];

	GetDIBits (hdcScreen, captureBitMap, 0, captureBitMapInfo->bmiHeader.biHeight, captureBuf, captureBitMapInfo, DIB_RGB_COLORS);
	GetDIBits (hdcCompatible, caosGLBitMap, 0, caosGLBitMapInfo->bmiHeader.biHeight, caosGLBuf, caosGLBitMapInfo, DIB_RGB_COLORS);
	ReleaseDC (0,hdcScreen);

	int i = 254;
	for (; i>1;i-=1)
		step (i);
	Sleep (1000);
	for (; i<255;i+=2)
		step (i);

	delete [] caosGLBuf;
	delete [] captureBuf;
	delete [] tempBuf;
	free (caosGLBitMapInfo);
	free (captureBitMapInfo);
	free (tempBitMapInfo);
	DeleteDC (hdcCompatible);
	DeleteObject (captureBitMap);
	DeleteObject (tempBitMap);
	DeleteObject (caosGLBitMap);
	ReleaseDC (0,hdcScreen);
}

void step (int w) {
	if (captureBitMapInfo->bmiHeader.biBitCount == 16) {
		HDC hdcScreen = GetDC(0); 

		HDC       hdcBits;
		BITMAP    bm;

		hdcBits = CreateCompatibleDC(hdcScreen);
		GetObject (tempBitMap,sizeof(BITMAP),(LPSTR)&bm);
		SelectObject (hdcBits,caosGLBitMap);
		BitBlt (hdcScreen,sw/2-iw/2,sh/2-ih/2,bm.bmWidth,bm.bmHeight,hdcBits,0,0,SRCCOPY);
		DeleteDC (hdcBits);
		
		ReleaseDC (0, hdcScreen);
	} else {
		for (int i = captureBitMapInfo->bmiHeader.biSizeImage ; i-->0;) {
			tempBuf [i] = ((caosGLBuf [i]*(256-w))>>8) + ((captureBuf [i]*w)>>8);
		}
		HDC hdcScreen = GetDC(0); 

		SetDIBits (hdcScreen, tempBitMap, 0, tempBitMapInfo->bmiHeader.biHeight, tempBuf, tempBitMapInfo, DIB_RGB_COLORS);

		HDC       hdcBits;
		BITMAP    bm;

		hdcBits = CreateCompatibleDC(hdcScreen);
		GetObject (tempBitMap,sizeof(BITMAP),(LPSTR)&bm);
		SelectObject (hdcBits,tempBitMap);
		BitBlt (hdcScreen,sw/2-iw/2,sh/2-ih/2,bm.bmWidth,bm.bmHeight,hdcBits,0,0,SRCCOPY);
		DeleteDC (hdcBits);
		
		ReleaseDC (0, hdcScreen);
	}

}

/**
 * The Catalyst of Design Software License, Version 1.0
 *
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by 
 *        Catalyst of Design (http://talsit.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "caosGL" and "Catalyst of Design" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact caosGL@talsit.org.
 *
 * 5. Products derived from this software may not be called "caosGL",
 *    nor may "caosGL" appear in their name, without prior written
 *    permission of Catalyst of Design.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CATALYST OF DESIGN OR ITS 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 */
// eof