/* For license details see bottom.
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 */

// system includes
#include <caosGL/core/globals.h>
#include <caosGL/core/types.h>

// package includes

// extern includes
#include <caosGL/core/cGLTexture.h>
#include <memory.h>
#include <caosGL/core/Dyngl.h>
#include <GL/glu.h>

#include <caosGL/core/cSurface.h>

static log4cpp::Category& cat = log4cpp::Category::getInstance ("caosGL::core::cSurface");

namespace caosGL {
	namespace core {
		/**
		 *<br> class:		cSurface
		 *<br> namespace:	caosGL::core
		 *<br> inherits:	<none>
		 *<br> implements:	<none>
		 *<br> purpose:		Creates a drawable, blittable surface (i hope!)
		 *
		 */

		/********************************************************************************************/
		cSurface::cSurface (const string & name, tInt w, tInt h, cGLTexture::eGLTextureType type) :
			cGLTexture (name, type) {
			_type = type;
			_width = w;
			_height = h;
			_buf = new tDWord [_width*_height];
			_area.area (0,0,_width,_height);
			_alpha = 0;
			_openGLPrepared = false;
			_name = name;
		} 


		/********************************************************************************************/
		cSurface::~cSurface () {
			delete [] _buf; 
		}

		/********************************************************************************************/
		tDWord * cSurface::lock () {
			_locked = true;
			return _buf;
		}

		/********************************************************************************************/
		tVoid cSurface::release () {
			_dirty = true;
			_locked = false;
		}

		/********************************************************************************************/
		tVoid cSurface::rollback () {
			_locked = false;
		}

		/********************************************************************************************/
		tVoid cSurface::prepare () {
			if (!_openGLPrepared) {
				super::generate ();
				switch (_type) {
				case cGLTexture::eGLTextureType_Nearest: 
				case cGLTexture::eGLTextureType_Linear:
					glTexImage2D (GL_TEXTURE_2D, 0, 4, _width, _height, 0, GL_RGBA, GL_UNSIGNED_BYTE, _buf);
				break;

				case cGLTexture::eGLTextureType_Mipmap:
					gluBuild2DMipmaps (GL_TEXTURE_2D, 4, _width, _height, GL_RGBA, GL_UNSIGNED_BYTE, _buf);
				break;
				default:
					cat.error ("Falling to the default level, this cannot happen!");
				break;
				}

				_dirty = false;
				_openGLPrepared = true;
				return;
			}
			super::prepare ();
// TODO: something with this please!
/*				if (_dirty) {
				glTexParameteri (GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
				glTexParameteri (GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
				glTexSubImage2D (GL_TEXTURE_2D, 0, 0, 0, _width, _height, GL_RGBA, GL_UNSIGNED_BYTE, _buf);
				_dirty = false;
			}*/
		}

		/********************************************************************************************/
		tVoid cSurface::clear () {
			if (!_locked) {
				memset (_buf, 0, (_width*_height)<<2);
			}
		}

		/********************************************************************************************/
		tVoid cSurface::clear (const tInt color) {
			if (!_locked) {
				for (tInt count = _width*_height ; count-->0 ;) {
					_buf [count] = color;
				}
			}
		}

		/********************************************************************************************/
		tVoid cSurface::alpha (const tByte a) { _alpha = a; }
		/********************************************************************************************/
		tByte cSurface::alpha () const { return _alpha; }

		/********************************************************************************************/
		tInt cSurface::width () const {return _width;}

		/********************************************************************************************/
		tInt cSurface::height () const {return _height;}

		/********************************************************************************************/
		tVoid cSurface::area (const cArea & area) { _area = area; }

		/********************************************************************************************/
		tVoid cSurface::area (const tInt x0, const tInt x1, const tInt y0, const tInt y1) {
			_area.area (x0,x1,y0,y1);
		}
		
		/********************************************************************************************/
		cArea cSurface::area () const { return _area; }
	}
}

/**
 * The Catalyst of Design Software License, Version 1.0
 *
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by 
 *        Catalyst of Design (http://talsit.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "caosGL" and "Catalyst of Design" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact caosGL@talsit.org.
 *
 * 5. Products derived from this software may not be called "caosGL",
 *    nor may "caosGL" appear in their name, without prior written
 *    permission of Catalyst of Design.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CATALYST OF DESIGN OR ITS 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 */
// eof