/* For license details see bottom.
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 */

// system includes
#include <caosGL/core/globals.h>
#include <caosGL/core/types.h>

// package includes

// extern includes
#include <windows.h>

#include <caosGL/core/cParser.h>

namespace caosGL {
	namespace core {
		/**
		 *<br> class:		cParser
		 *<br> namespace:	caosGL::core
		 *<br> inherits:	<none>
		 *<br> implements:	<none>
		 *<br> purpose:		
		 *
		 */

		static const string cParserTrue ("true");
		static const string cParserFalse ("false");
		cParser::cParser ();
		cParser::~cParser ();

		/********************************************************************************************/
		const string cParser::toString (const string s) {
			return s;
		}

		/********************************************************************************************/
		const string cParser::toString (const tChar c) {
			tChar buf [2];
			buf [0] = c;
			buf [1] = '\0';
			return buf;
		}

		/********************************************************************************************/
		const string cParser::toString (const tByte b) {
			tChar buf [5];
			itoa (b, buf, 10);
			return buf;
		}

		/********************************************************************************************/
		const string cParser::toString (const tShort s) {
			tChar buf [10];
			itoa (s, buf, 10);
			return buf;
		}

		/********************************************************************************************/
		const string cParser::toString (const tWord w) {
			tChar buf [20];
			itoa (w, buf, 10);
			return buf;
		}

		/********************************************************************************************/
		const string cParser::toString (const tInt i) {
			tChar buf [20];
			itoa (i, buf, 10);
			return buf;
		}

		/********************************************************************************************/
		const string cParser::toString (const tDWord dw) {
			tChar buf [40];
			itoa (dw, buf, 10);
			return buf;
		}

		/********************************************************************************************/
		const string cParser::toString (const tLong l) {
			tChar buf [40];
			ltoa (l, buf, 10);
			return buf;
		}

		/********************************************************************************************/
		const string cParser::toString (const tQWord qw) {
			tChar buf [40];
			itoa (qw, buf, 10);
			return buf;
		}

		/********************************************************************************************/
		const string cParser::toString (const tDouble d) {
			tChar buf [80];
			sprintf (buf, "%f", d);
			return buf;
		}

		/********************************************************************************************/
		const string cParser::toString (const tBool b) {
			if (b)
				return cParserTrue;
			return cParserFalse;
		}

		/********************************************************************************************/
		const string cParser::toString (const tFloat t) {
			tChar buf [80];
			sprintf (buf, "%f", t);
			return buf;
		}

		/********************************************************************************************/
		/********************************************************************************************/
		const tChar   cParser::parseChar   (const string s) {
			if (s.length () > 0) 
				return s.c_str () [0];
			return '\0';
		}

		/********************************************************************************************/
		const tByte   cParser::parseByte   (const string s) {
			return static_cast<tByte> (atoi (s.c_str ()));
		}

		/********************************************************************************************/
		const tShort  cParser::parseShort  (const string s) {
			return static_cast<tShort> (atoi (s.c_str ()));
		}

		/********************************************************************************************/
		const tWord   cParser::parseWord   (const string s) {
			return static_cast<tWord> (atoi (s.c_str ()));
		}

		/********************************************************************************************/
		const tInt    cParser::parseInt    (const string s) {
			return (atoi (s.c_str ()));
		}

		/********************************************************************************************/
		const tDWord  cParser::parseDWord  (const string s) {
			return static_cast<tDWord> (atol (s.c_str ()));
		}

		/********************************************************************************************/
		const tLong   cParser::parseLong   (const string s) {
			return static_cast<tLong> (_atoi64 (s.c_str ()));
		}

		/********************************************************************************************/
		const tQWord  cParser::parseQWord  (const string s) {
			return static_cast<tQWord> (_atoi64 (s.c_str ()));
		}

		/********************************************************************************************/
		const tFloat cParser::parseFloat (const string s) {
			return static_cast<tFloat> (atof (s.c_str ()));
		}

		/********************************************************************************************/
		const tDouble cParser::parseDouble (const string s) {
			return static_cast<tDouble> (atof (s.c_str ()));
		}

		/********************************************************************************************/
		const tBool   cParser::parseBool   (const string s) {
			if (s == cParserTrue)
				return true;
			return false;
		}

		/********************************************************************************************/
		/********************************************************************************************/
		tVoid cParser::parse (string  & v, const string s) {
			v = s;
		}

		/********************************************************************************************/
		tVoid cParser::parse (tChar   & v, const string s) {
			if (s.length () > 0) v=s[0]; v='\0';
		}

		/********************************************************************************************/
		tVoid cParser::parse (tByte   & v, const string s) {
			v=static_cast<tByte> (atoi (s.c_str ()));
		}

		/********************************************************************************************/
		tVoid cParser::parse (tShort  & v, const string s) {
			v=static_cast<tShort> (atoi (s.c_str ()));
		}

		/********************************************************************************************/
		tVoid cParser::parse (tWord   & v, const string s) {
			v=static_cast<tWord> (atoi (s.c_str ()));
		}

		/********************************************************************************************/
		tVoid cParser::parse (tInt    & v, const string s) {
			v=(atoi (s.c_str ()));
		}

		/********************************************************************************************/
		tVoid cParser::parse (tDWord  & v, const string s) {
			v=static_cast<tDWord> (atol (s.c_str ()));
		}

		/********************************************************************************************/
		tVoid cParser::parse (tLong   & v, const string s) {
			v=static_cast<tLong> (_atoi64 (s.c_str ()));
		}

		/********************************************************************************************/
		tVoid cParser::parse (tQWord  & v, const string s) {
			v=static_cast<tQWord> (_atoi64 (s.c_str ()));
		}

		/********************************************************************************************/
		tVoid cParser::parse (tFloat & v, const string s) {
			v=static_cast<tFloat> (atof (s.c_str ()));
		}

		/********************************************************************************************/
		tVoid cParser::parse (tDouble & v, const string s) {
			v=static_cast<tDouble> (atof (s.c_str ()));
		}

		/********************************************************************************************/
		tVoid cParser::parse (tBool   & v, const string s) {
			if (s==cParserTrue)
				v=true;
			else
				v=false;
		}

		/********************************************************************************************/
		/********************************************************************************************/
		tVoid cParser::convert (string  & v, const tFloat s) {
			v = toString (s);
		}

		/********************************************************************************************/
		tVoid cParser::convert (tChar   & v, const tFloat s) {
			v = '-';
		}

		/********************************************************************************************/
		tVoid cParser::convert (tByte   & v, const tFloat s) {
			v = static_cast<tByte> (s);
		}

		/********************************************************************************************/
		tVoid cParser::convert (tShort  & v, const tFloat s) {
			v = static_cast<tShort> (s);
		}

		/********************************************************************************************/
		tVoid cParser::convert (tWord   & v, const tFloat s) {
			v = static_cast<tWord> (s);
		}

		/********************************************************************************************/
		tVoid cParser::convert (tInt    & v, const tFloat s) {
			v = static_cast<tInt> (s);
		}

		/********************************************************************************************/
		tVoid cParser::convert (tDWord  & v, const tFloat s) {
			v = static_cast<tDWord> (s);
		}

		/********************************************************************************************/
		tVoid cParser::convert (tLong   & v, const tFloat s) {
			v = static_cast<tLong> (s);
		}

		/********************************************************************************************/
		tVoid cParser::convert (tQWord  & v, const tFloat s) {
			v = static_cast<tQWord> (s);
		}

		/********************************************************************************************/
		tVoid cParser::convert (tDouble & v, const tFloat s) {
			v = static_cast<tDouble> (s);
		}

		/********************************************************************************************/
		tVoid cParser::convert (tFloat  & v, const tFloat s) {
			v = s;
		}

		/********************************************************************************************/
		tVoid cParser::convert (tBool   & v, const tFloat s) {
			v = s>0.5;
		}

	}
}

/**
 * The Catalyst of Design Software License, Version 1.0
 *
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by 
 *        Catalyst of Design (http://talsit.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "caosGL" and "Catalyst of Design" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact caosGL@talsit.org.
 *
 * 5. Products derived from this software may not be called "caosGL",
 *    nor may "caosGL" appear in their name, without prior written
 *    permission of Catalyst of Design.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CATALYST OF DESIGN OR ITS 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 */
// eof