/* For license details see bottom.
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 */

/**
 *<br> class:		DynBass
 *<br> namespace:	caosGL::core
 *<br> inherits:	<none>
 *<br> implements:	<none>
 *<br> purpose:		the Bass sound system dynamic loader
 *
 */

// system includes
#include <caosGL/core/globals.h>
#include <caosGL/core/types.h>

// package includes

// extern includes
#include <windows.h>

#include <caosGL/core/DynBass.h>

namespace caosGL {
	namespace core {

static HMODULE hBassDLL = 0;

pfnBASS_GetVersion					BASS_GetVersion;
pfnBASS_GetDeviceDescription		BASS_GetDeviceDescription;
pfnBASS_SetBufferLength				BASS_SetBufferLength;
pfnBASS_SetGlobalVolumes			BASS_SetGlobalVolumes;
pfnBASS_GetGlobalVolumes			BASS_GetGlobalVolumes;
pfnBASS_SetLogCurves				BASS_SetLogCurves;
pfnBASS_Set3DAlgorithm				BASS_Set3DAlgorithm;
pfnBASS_ErrorGetCode				BASS_ErrorGetCode;
pfnBASS_Init						BASS_Init;
pfnBASS_Free						BASS_Free;
pfnBASS_GetDSoundObject				BASS_GetDSoundObject;
pfnBASS_GetInfo						BASS_GetInfo;
pfnBASS_GetCPU						BASS_GetCPU;
pfnBASS_Start						BASS_Start;
pfnBASS_Stop						BASS_Stop;
pfnBASS_Pause						BASS_Pause;
pfnBASS_SetVolume					BASS_SetVolume;
pfnBASS_GetVolume					BASS_GetVolume;
pfnBASS_Set3DFactors				BASS_Set3DFactors;
pfnBASS_Get3DFactors				BASS_Get3DFactors;
pfnBASS_Set3DPosition				BASS_Set3DPosition;
pfnBASS_Get3DPosition				BASS_Get3DPosition;
pfnBASS_Apply3D						BASS_Apply3D;
pfnBASS_SetEAXParameters			BASS_SetEAXParameters;
pfnBASS_GetEAXParameters			BASS_GetEAXParameters;
pfnBASS_SetA3DResManager			BASS_SetA3DResManager;
pfnBASS_GetA3DResManager			BASS_GetA3DResManager;
pfnBASS_SetA3DHFAbsorbtion			BASS_SetA3DHFAbsorbtion;
pfnBASS_GetA3DHFAbsorbtion			BASS_GetA3DHFAbsorbtion;
pfnBASS_MusicLoad					BASS_MusicLoad;
pfnBASS_MusicFree					BASS_MusicFree;
pfnBASS_MusicGetName				BASS_MusicGetName;
pfnBASS_MusicGetLength				BASS_MusicGetLength;
pfnBASS_MusicPlay					BASS_MusicPlay;
pfnBASS_MusicPlayEx					BASS_MusicPlayEx;
pfnBASS_MusicSetAmplify				BASS_MusicSetAmplify;
pfnBASS_MusicSetPanSep				BASS_MusicSetPanSep;
pfnBASS_MusicSetPositionScaler		BASS_MusicSetPositionScaler;
pfnBASS_SampleLoad					BASS_SampleLoad;
pfnBASS_SampleCreate				BASS_SampleCreate;
pfnBASS_SampleCreateDone			BASS_SampleCreateDone;
pfnBASS_SampleFree					BASS_SampleFree;
pfnBASS_SampleGetInfo				BASS_SampleGetInfo;
pfnBASS_SampleSetInfo				BASS_SampleSetInfo;
pfnBASS_SamplePlay					BASS_SamplePlay;
pfnBASS_SamplePlayEx				BASS_SamplePlayEx;
pfnBASS_SamplePlay3D				BASS_SamplePlay3D;
pfnBASS_SamplePlay3DEx				BASS_SamplePlay3DEx;
pfnBASS_SampleStop					BASS_SampleStop;
pfnBASS_StreamCreate				BASS_StreamCreate;
pfnBASS_StreamCreateFile			BASS_StreamCreateFile;
pfnBASS_StreamFree					BASS_StreamFree;
pfnBASS_StreamGetLength				BASS_StreamGetLength;
pfnBASS_StreamGetBlockLength		BASS_StreamGetBlockLength;
pfnBASS_StreamPlay					BASS_StreamPlay;
pfnBASS_CDInit						BASS_CDInit;
pfnBASS_CDFree						BASS_CDFree;
pfnBASS_CDInDrive					BASS_CDInDrive;
pfnBASS_CDPlay						BASS_CDPlay;
pfnBASS_ChannelIsActive				BASS_ChannelIsActive;
pfnBASS_ChannelGetFlags				BASS_ChannelGetFlags;
pfnBASS_ChannelStop					BASS_ChannelStop;
pfnBASS_ChannelPause				BASS_ChannelPause;
pfnBASS_ChannelResume				BASS_ChannelResume;
pfnBASS_ChannelSetAttributes		BASS_ChannelSetAttributes;
pfnBASS_ChannelGetAttributes		BASS_ChannelGetAttributes;
pfnBASS_ChannelSet3DAttributes		BASS_ChannelSet3DAttributes;
pfnBASS_ChannelGet3DAttributes		BASS_ChannelGet3DAttributes;
pfnBASS_ChannelSet3DPosition		BASS_ChannelSet3DPosition;
pfnBASS_ChannelGet3DPosition		BASS_ChannelGet3DPosition;
pfnBASS_ChannelSetPosition			BASS_ChannelSetPosition;
pfnBASS_ChannelGetPosition			BASS_ChannelGetPosition;
pfnBASS_ChannelGetLevel				BASS_ChannelGetLevel;
pfnBASS_ChannelGetData				BASS_ChannelGetData;
pfnBASS_ChannelSetSync				BASS_ChannelSetSync;
pfnBASS_ChannelRemoveSync			BASS_ChannelRemoveSync;
pfnBASS_ChannelSetDSP				BASS_ChannelSetDSP;
pfnBASS_ChannelRemoveDSP			BASS_ChannelRemoveDSP;
pfnBASS_ChannelSetEAXMix			BASS_ChannelSetEAXMix;
pfnBASS_ChannelGetEAXMix			BASS_ChannelGetEAXMix;
	

#define GETADDR(type, var, name) var = (type)GetProcAddress(hBassDLL,name)

static void setProcs(void) {
	GETADDR(pfnBASS_GetVersion,BASS_GetVersion,"BASS_GetVersion");
	GETADDR(pfnBASS_GetDeviceDescription,BASS_GetDeviceDescription,"BASS_GetDeviceDescription");
	GETADDR(pfnBASS_SetBufferLength,BASS_SetBufferLength,"BASS_SetBufferLength");
	GETADDR(pfnBASS_SetGlobalVolumes,BASS_SetGlobalVolumes,"BASS_SetGlobalVolumes");
	GETADDR(pfnBASS_GetGlobalVolumes,BASS_GetGlobalVolumes,"BASS_GetGlobalVolumes");
	GETADDR(pfnBASS_SetLogCurves,BASS_SetLogCurves,"BASS_SetLogCurves");
	GETADDR(pfnBASS_Set3DAlgorithm,BASS_Set3DAlgorithm,"BASS_Set3DAlgorithm");
	GETADDR(pfnBASS_ErrorGetCode,BASS_ErrorGetCode,"BASS_ErrorGetCode");
	GETADDR(pfnBASS_Init,BASS_Init,"BASS_Init");
	GETADDR(pfnBASS_Free,BASS_Free,"BASS_Free");
	GETADDR(pfnBASS_GetDSoundObject,BASS_GetDSoundObject,"BASS_GetDSoundObject");
	GETADDR(pfnBASS_GetInfo,BASS_GetInfo,"BASS_GetInfo");
	GETADDR(pfnBASS_GetCPU,BASS_GetCPU,"BASS_GetCPU");
	GETADDR(pfnBASS_Start,BASS_Start,"BASS_Start");
	GETADDR(pfnBASS_Stop,BASS_Stop,"BASS_Stop");
	GETADDR(pfnBASS_Pause,BASS_Pause,"BASS_Pause");
	GETADDR(pfnBASS_SetVolume,BASS_SetVolume,"BASS_SetVolume");
	GETADDR(pfnBASS_GetVolume,BASS_GetVolume,"BASS_GetVolume");
	GETADDR(pfnBASS_Set3DFactors,BASS_Set3DFactors,"BASS_Set3DFactors");
	GETADDR(pfnBASS_Get3DFactors,BASS_Get3DFactors,"BASS_Get3DFactors");
	GETADDR(pfnBASS_Set3DPosition,BASS_Set3DPosition,"BASS_Set3DPosition");
	GETADDR(pfnBASS_Get3DPosition,BASS_Get3DPosition,"BASS_Get3DPosition");
	GETADDR(pfnBASS_Apply3D,BASS_Apply3D,"BASS_Apply3D");
	GETADDR(pfnBASS_SetEAXParameters,BASS_SetEAXParameters,"BASS_SetEAXParameters");
	GETADDR(pfnBASS_GetEAXParameters,BASS_GetEAXParameters,"BASS_GetEAXParameters");
	GETADDR(pfnBASS_SetA3DResManager,BASS_SetA3DResManager,"BASS_SetA3DResManager");
	GETADDR(pfnBASS_GetA3DResManager,BASS_GetA3DResManager,"BASS_GetA3DResManager");
	GETADDR(pfnBASS_SetA3DHFAbsorbtion,BASS_SetA3DHFAbsorbtion,"BASS_SetA3DHFAbsorbtion");
	GETADDR(pfnBASS_GetA3DHFAbsorbtion,BASS_GetA3DHFAbsorbtion,"BASS_GetA3DHFAbsorbtion");
	GETADDR(pfnBASS_MusicLoad,BASS_MusicLoad,"BASS_MusicLoad");
	GETADDR(pfnBASS_MusicFree,BASS_MusicFree,"BASS_MusicFree");
	GETADDR(pfnBASS_MusicGetName,BASS_MusicGetName,"BASS_MusicGetName");
	GETADDR(pfnBASS_MusicGetLength,BASS_MusicGetLength,"BASS_MusicGetLength");
	GETADDR(pfnBASS_MusicPlay,BASS_MusicPlay,"BASS_MusicPlay");
	GETADDR(pfnBASS_MusicPlayEx,BASS_MusicPlayEx,"BASS_MusicPlayEx");
	GETADDR(pfnBASS_MusicSetAmplify,BASS_MusicSetAmplify,"BASS_MusicSetAmplify");
	GETADDR(pfnBASS_MusicSetPanSep,BASS_MusicSetPanSep,"BASS_MusicSetPanSep");
	GETADDR(pfnBASS_MusicSetPositionScaler,BASS_MusicSetPositionScaler,"BASS_MusicSetPositionScaler");
	GETADDR(pfnBASS_SampleLoad,BASS_SampleLoad,"BASS_SampleLoad");
	GETADDR(pfnBASS_SampleCreate,BASS_SampleCreate,"BASS_SampleCreate");
	GETADDR(pfnBASS_SampleCreateDone,BASS_SampleCreateDone,"BASS_SampleCreateDone");
	GETADDR(pfnBASS_SampleFree,BASS_SampleFree,"BASS_SampleFree");
	GETADDR(pfnBASS_SampleGetInfo,BASS_SampleGetInfo,"BASS_SampleGetInfo");
	GETADDR(pfnBASS_SampleSetInfo,BASS_SampleSetInfo,"BASS_SampleSetInfo");
	GETADDR(pfnBASS_SamplePlay,BASS_SamplePlay,"BASS_SamplePlay");
	GETADDR(pfnBASS_SamplePlayEx,BASS_SamplePlayEx,"BASS_SamplePlayEx");
	GETADDR(pfnBASS_SamplePlay3D,BASS_SamplePlay3D,"BASS_SamplePlay3D");
	GETADDR(pfnBASS_SamplePlay3DEx,BASS_SamplePlay3DEx,"BASS_SamplePlay3DEx");
	GETADDR(pfnBASS_SampleStop,BASS_SampleStop,"BASS_SampleStop");
	GETADDR(pfnBASS_StreamCreate,BASS_StreamCreate,"BASS_StreamCreate");
	GETADDR(pfnBASS_StreamCreateFile,BASS_StreamCreateFile,"BASS_StreamCreateFile");
	GETADDR(pfnBASS_StreamFree,BASS_StreamFree,"BASS_StreamFree");
	GETADDR(pfnBASS_StreamGetLength,BASS_StreamGetLength,"BASS_StreamGetLength");
	GETADDR(pfnBASS_StreamGetBlockLength,BASS_StreamGetBlockLength,"BASS_StreamGetBlockLength");
	GETADDR(pfnBASS_StreamPlay,BASS_StreamPlay,"BASS_StreamPlay");
	GETADDR(pfnBASS_CDInit,BASS_CDInit,"BASS_CDInit");
	GETADDR(pfnBASS_CDFree,BASS_CDFree,"BASS_CDFree");
	GETADDR(pfnBASS_CDInDrive,BASS_CDInDrive,"BASS_CDInDrive");
	GETADDR(pfnBASS_CDPlay,BASS_CDPlay,"BASS_CDPlay");
	GETADDR(pfnBASS_ChannelIsActive,BASS_ChannelIsActive,"BASS_ChannelIsActive");
	GETADDR(pfnBASS_ChannelGetFlags,BASS_ChannelGetFlags,"BASS_ChannelGetFlags");
	GETADDR(pfnBASS_ChannelStop,BASS_ChannelStop,"BASS_ChannelStop");
	GETADDR(pfnBASS_ChannelPause,BASS_ChannelPause,"BASS_ChannelPause");
	GETADDR(pfnBASS_ChannelResume,BASS_ChannelResume,"BASS_ChannelResume");
	GETADDR(pfnBASS_ChannelSetAttributes,BASS_ChannelSetAttributes,"BASS_ChannelSetAttributes");
	GETADDR(pfnBASS_ChannelGetAttributes,BASS_ChannelGetAttributes,"BASS_ChannelGetAttributes");
	GETADDR(pfnBASS_ChannelSet3DAttributes,BASS_ChannelSet3DAttributes,"BASS_ChannelSet3DAttributes");
	GETADDR(pfnBASS_ChannelGet3DAttributes,BASS_ChannelGet3DAttributes,"BASS_ChannelGet3DAttributes");
	GETADDR(pfnBASS_ChannelSet3DPosition,BASS_ChannelSet3DPosition,"BASS_ChannelSet3DPosition");
	GETADDR(pfnBASS_ChannelGet3DPosition,BASS_ChannelGet3DPosition,"BASS_ChannelGet3DPosition");
	GETADDR(pfnBASS_ChannelSetPosition,BASS_ChannelSetPosition,"BASS_ChannelSetPosition");
	GETADDR(pfnBASS_ChannelGetPosition,BASS_ChannelGetPosition,"BASS_ChannelGetPosition");
	GETADDR(pfnBASS_ChannelGetLevel,BASS_ChannelGetLevel,"BASS_ChannelGetLevel");
	GETADDR(pfnBASS_ChannelGetData,BASS_ChannelGetData,"BASS_ChannelGetData");
	GETADDR(pfnBASS_ChannelSetSync,BASS_ChannelSetSync,"BASS_ChannelSetSync");
	GETADDR(pfnBASS_ChannelRemoveSync,BASS_ChannelRemoveSync,"BASS_ChannelRemoveSync");
	GETADDR(pfnBASS_ChannelSetDSP,BASS_ChannelSetDSP,"BASS_ChannelSetDSP");
	GETADDR(pfnBASS_ChannelRemoveDSP,BASS_ChannelRemoveDSP,"BASS_ChannelRemoveDSP");
	GETADDR(pfnBASS_ChannelSetEAXMix,BASS_ChannelSetEAXMix,"BASS_ChannelSetEAXMix");
	GETADDR(pfnBASS_ChannelGetEAXMix,BASS_ChannelGetEAXMix,"BASS_ChannelGetEAXMix");
}

int loadBass () {
	if (hBassDLL != 0) { 
		return 0;
	}
	hBassDLL = LoadLibrary ("bass.dll");
	if (hBassDLL == 0) {
		return 0;
	}
	setProcs ();
	return 1;
}

	}
}

/**
 * The Catalyst of Design Software License, Version 1.0
 *
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by 
 *        Catalyst of Design (http://talsit.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "caosGL" and "Catalyst of Design" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact caosGL@talsit.org.
 *
 * 5. Products derived from this software may not be called "caosGL",
 *    nor may "caosGL" appear in their name, without prior written
 *    permission of Catalyst of Design.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CATALYST OF DESIGN OR ITS 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 */
// eof