/* For license details see bottom.
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 */

/**
 *<br> class:		<none>
 *<br> namespace:	<none>
 *<br> inherits:	<none>
 *<br> implements:	<none>
 *<br> purpose:		Defines the caos-format stored data types.
 *
 */

#ifndef __CHUNKS__
#define __CHUNKS__

#pragma pack(push,chunks)
#pragma pack(2)

extern const unsigned int versionMajor;
extern const unsigned int versionMinor;

enum flis { // reverse the chunks, for easy binary reading
	fliCnkHeader             = 'soac', // caos | caos 
	fliCnkAttrString         = 'Stta', // attS |
	fliCnkAttrDouble         = 'Dtta', // attD | 
	fliCnkAttrInt            = 'Itta', // attI |
	fliCnkAttrBool           = 'Btta', // attB |
	fliCnkObjS               = 'Sjbo', // objS | object start
	fliCnkObjE               = 'Ejbo', // objE | object end
	fliCnkMeshS              = 'Ssem', // mesS | mesh start
	fliCnkMeshE              = 'Esem', // mesE | mesh end
	fliCnkMeshV              = 'Vsem', // mesV | mesh vertex list
	fliCnkMeshF              = 'Fsem', // mesF | mesh face list
	fliCnkMeshUV             = 'Usem', // mesU | mesh UV list
	fliCnkMeshN              = 'Nsem', // mesN | mesh normal list
	fliCnkMeshEdge           = 'esem', // mese | mesh edge list
	fliCnkCurveStart         = 'Sruc', // curS | curve start
	fliCnkCurveKey           = 'Kruc', // curK |curve end
	fliCnkCurveEnd           = 'Eruc', // curE | curve end

};

//////////////////////////////////////////////////////
// header chunk
typedef struct {
	unsigned int fli;
	unsigned int versionMajor;
	unsigned int versionMinor;
	unsigned int sizeN;
	unsigned int sizeW;
	void * name;
	void * writer;
} chunkHeader;

//////////////////////////////////////////////////////
// misc object node chunk
typedef struct {
	unsigned int fli;
	unsigned int sizeT;
	unsigned int sizeN;
	void * type;
	void * name;
} chunkObjStart;

typedef struct {
	unsigned int fli;
} chunkObjEnd;

//////////////////////////////////////////////////////
// mesh object node chunk
enum eMeshThings {
	oVertex         = fliCnkMeshV,
	oFace           = fliCnkMeshF,
	oUV             = fliCnkMeshUV,
	oNormal         = fliCnkMeshN,
	oEdge           = fliCnkMeshEdge,
	oLast           = 0xFFFFFFFF,
};

typedef struct {
	unsigned int fli;
	unsigned int num;
	void * list;
} chunkMeshList;

//////////////////////////////////////////////////////
// node attribute chunk
typedef struct {
	unsigned int fli;
	unsigned int name;
	void * value;
} chunkAttr;

//////////////////////////////////////////////////////
// node attribute chunk
typedef struct {
	unsigned int fli;
	unsigned int name;
	unsigned int size;
	void * value;
} chunkAttrS;

//curve name="translate.translateY.pCube1223" obj="sclaer2" attrib="tY" 
//input="time" output="linear" weighted="false" preInfinity="constant" postInfinity="cycle"
//////////////////////////////////////////////////////
// curve chunk
enum eInfinityType {
	eInfinityConstant      = 0,
	eInfinityLinear        = 1,
	eInfinityCycle         = 2,
	eInfinityCycleRelative = 3,
	eInfinityOscillate     = 4
};

typedef struct {
	unsigned int fli;
	unsigned int sizeN;
	unsigned int sizeO;
	unsigned int attribFLI;
	eInfinityType preInfinity;
	eInfinityType postInfinity;
	void * name;
	void * obj;
} chunkCurveStart;

enum eTangentType {
	eTangentFixed   = 0,
	eTangentLinear  = 1,
	eTangentFlat    = 2,
	eTangentStep    = 3,
	eTangentSlow    = 4,
	eTangentFast    = 5,
	eTangentSmooth  = 6,
	eTangentClamped = 7
};

typedef struct {
	unsigned int fli;
	double time;
	double value;
	eTangentType inTangentType;
	eTangentType outTangentType;
	double inAngle;
	double inWeight;
	double outAngle;
	double outWeight;
} chunkCurveKey;

typedef struct {
	unsigned int fli;
} chunkCurveEnd;

#pragma pack(pop,chunks)

#endif

/**
 * The Catalyst of Design Software License, Version 1.0
 *
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by 
 *        Catalyst of Design (http://talsit.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "caosGL" and "Catalyst of Design" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact caosGL@talsit.org.
 *
 * 5. Products derived from this software may not be called "caosGL",
 *    nor may "caosGL" appear in their name, without prior written
 *    permission of Catalyst of Design.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CATALYST OF DESIGN OR ITS 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 */
// eof