/* For license details see bottom.
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 */

#ifndef CAOSGL_GFX_CBASENODE
#define CAOSGL_GFX_CBASENODE

// system includes
#include <caosGL/core/globals.h>
#include <caosGL/core/types.h>

#include <caosGL/core/cParser.h>

using namespace caosGL::core;

typedef pair<tDWord,string> tAttr;
#define cBaseNode_attribsFile <caosGL/gfx/cBaseNode.attribs>

namespace caosGL {
	namespace gfx {
		class cGroup;
		class cEvaluatable;

		/**
		 *<br> class:		cBaseNode
		 *<br> namespace:	caosGL::gfx
		 *<br> inherits:	<none>
		 *<br> implements:	<none>
		 *<br> purpose:		The mother of all clases, literaly! This base node provides basic object
		 *					house keeping, has a common interface for accessing a method's attributes
		 *
		 */
		class ABSTRACT CAOSGL_API cBaseNode {
		public:
			cBaseNode (const string & n, cGroup * f);
			virtual ~cBaseNode ();

			virtual tVoid name (const string & n);
			virtual const string & name () const;
			virtual string & name ();

			virtual void father (cGroup * father);
			virtual const cGroup * father () const;
			virtual cGroup * father ();

			virtual void addEvaluatable (cEvaluatable * curve);
			virtual cEvaluatable * getEvaluatable (const string & evaluatableName);
			virtual void removeEvaluatable (const string & evaluatableName);
			virtual tBool evaluateAll (const tFloat t);

			virtual const tFloat start () const;
			virtual const tFloat end () const;
			virtual const tBool isAlive () const;

			virtual tBool compile  () = 0;
			virtual tBool visit (tFloat t);
			virtual tVoid leave () = 0;
			virtual tBool init ();
			virtual const tBool set (const tDWord key, const string & value);
			virtual const tBool set (const tDWord key, const tFloat & value);
			virtual const tBool get (const tDWord key, string & value) const;
			virtual const vector <tAttr> * getAttributeNames () const;
			virtual const string getTypeName () const = 0;
			virtual const string toString () const;
		protected:
			string _name;
			cGroup * _father;
			map <string, cEvaluatable *> _evaluatables;
			#define ATTRIB(n,t,v,d) ATTRIB_DEFINE_VAR(n,t)
			#include cBaseNode_attribsFile
			#undef ATTRIB
		};

		//////////////////////////////////////
		typedef vector <cBaseNode*> tNodeList;
/*		#define INSERT(x,y) x.push_back(y)
		#define OBJ(x) (*x)*/
	}
}

#endif // CAOSGL_GFX_CBASENODE

/**
 * The Catalyst of Design Software License, Version 1.0
 *
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by 
 *        Catalyst of Design (http://talsit.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "caosGL" and "Catalyst of Design" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact caosGL@talsit.org.
 *
 * 5. Products derived from this software may not be called "caosGL",
 *    nor may "caosGL" appear in their name, without prior written
 *    permission of Catalyst of Design.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CATALYST OF DESIGN OR ITS 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 */
// eof