/* For license details see bottom.
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 */

#ifndef CAOSGL_CORE_CSURFACE
#define CAOSGL_CORE_CSURFACE

// system includes
#include <caosGL/core/globals.h>
#include <caosGL/core/types.h>

// package includes
#include <caosGL/core/cArea.h>

// extern includes
#include <caosGL/core/cGLTexture.h>

namespace caosGL { 
	namespace core {
		/**
		 *<br> class:		cSurface
		 *<br> namespace:	caosGL::core
		 *<br> inherits:	<none>
		 *<br> implements:	<none>
		 *<br> purpose:		Creates a drawable, blittable surface (i hope!)
		 *
		 */

		inline tDWord packARGB(const tByte a,const tByte r,const tByte g,const tByte b) { return ((a<<24)|(b<<16)|(g<<8)|(r)); }
		inline tDWord packRGB (const tByte r,const tByte g,const tByte b) { return packARGB (0xff,r,g,b); }
		inline tDWord red     (const tByte r,const tDWord p) { return ((0x000000FF&p)|(r    )); }
		inline tDWord green   (const tByte g,const tDWord p) { return ((0x0000FF00&p)|(g<<8 )); }
		inline tDWord blue    (const tByte b,const tDWord p) { return ((0x00FF0000&p)|(b<<16)); }
		inline tDWord alpha   (const tByte a,const tDWord p) { return ((0xFF000000&p)|(a<<24)); }
		inline tByte red      (const tDWord p)               { return  (0x000000FF&p)    ; }
		inline tByte green    (const tDWord p)               { return  (0x0000FF00&p)>>8 ; }
		inline tByte blue     (const tDWord p)               { return  (0x00FF0000&p)>>16; }
		inline tByte alpha    (const tDWord p)               { return  (0xFF000000&p)>>24; }

		class CAOSGL_API cSurface : public cGLTexture {
			typedef cGLTexture super;
		public:
			cSurface (const string & name, tInt w, tInt h, cGLTexture::eGLTextureType type = cGLTexture::eGLTextureType_Mipmap);
			~cSurface ();
			tDWord * lock ();
			tVoid release ();
			tVoid rollback ();

			tVoid clear ();
			tVoid clear (const tInt color);

			tInt width () const;
			tInt height () const;

			tVoid area (const cArea & area);
			tVoid area (const tInt x0, const tInt x1, const tInt y0, const tInt y1);
			cArea area () const;

			tVoid alpha (const tByte alpha);
			tByte alpha () const;

			virtual tVoid prepare ();
		private:
			tDWord * _buf;
			tByte _alpha;
			cArea _area;
			tInt _width;
			tInt _height;
			tBool _locked;
			tBool _openGLPrepared;
			tBool _dirty;
		};
	}
}

#endif // CAOSGL_CORE_CSURFACE

/**
 * The Catalyst of Design Software License, Version 1.0
 *
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by 
 *        Catalyst of Design (http://talsit.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "caosGL" and "Catalyst of Design" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact caosGL@talsit.org.
 *
 * 5. Products derived from this software may not be called "caosGL",
 *    nor may "caosGL" appear in their name, without prior written
 *    permission of Catalyst of Design.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CATALYST OF DESIGN OR ITS 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 */
// eof