/* For license details see bottom.
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 */

#ifndef CAOSGL_CORE_CPARSER
#define CAOSGL_CORE_CPARSER

// system includes
#include <caosGL/core/globals.h>
#include <caosGL/core/types.h>

// package includes
//#include <>

// extern includes
#include <string>
using namespace std;

namespace caosGL {
	namespace core {
		/**
		 *<br> class:		cParser
		 *<br> namespace:	caosGL::core
		 *<br> inherits:	<none>
		 *<br> implements:	<none>
		 *<br> purpose:		
		 *
		 */

		class CAOSGL_API cParser {
		public:
			static const string toString (const string s);
			static const string toString (const tChar c);
			static const string toString (const tByte b);
			static const string toString (const tShort s);
			static const string toString (const tWord w);
			static const string toString (const tInt i);
			static const string toString (const tDWord dw);
			static const string toString (const tLong l);
			static const string toString (const tQWord qw);
			static const string toString (const tFloat d);
			static const string toString (const tDouble t);
			static const string toString (const tBool b);

			static const tChar   parseChar   (const string s);
			static const tByte   parseByte   (const string s);
			static const tShort  parseShort  (const string s);
			static const tWord   parseWord   (const string s);
			static const tInt    parseInt    (const string s);
			static const tDWord  parseDWord  (const string s);
			static const tLong   parseLong   (const string s);
			static const tQWord  parseQWord  (const string s);
			static const tDouble parseDouble (const string s);
			static const tFloat  parseFloat  (const string s);
			static const tBool   parseBool   (const string s);

			static tVoid parse (string  & v, const string s);
			static tVoid parse (tChar   & v, const string s);
			static tVoid parse (tByte   & v, const string s);
			static tVoid parse (tShort  & v, const string s);
			static tVoid parse (tWord   & v, const string s);
			static tVoid parse (tInt    & v, const string s);
			static tVoid parse (tDWord  & v, const string s);
			static tVoid parse (tLong   & v, const string s);
			static tVoid parse (tQWord  & v, const string s);
			static tVoid parse (tDouble & v, const string s);
			static tVoid parse (tFloat  & v, const string s);
			static tVoid parse (tBool   & v, const string s);
			
			static tVoid convert (string  & v, const tFloat s);
			static tVoid convert (tChar   & v, const tFloat s);
			static tVoid convert (tByte   & v, const tFloat s);
			static tVoid convert (tShort  & v, const tFloat s);
			static tVoid convert (tWord   & v, const tFloat s);
			static tVoid convert (tInt    & v, const tFloat s);
			static tVoid convert (tDWord  & v, const tFloat s);
			static tVoid convert (tLong   & v, const tFloat s);
			static tVoid convert (tQWord  & v, const tFloat s);
			static tVoid convert (tDouble & v, const tFloat s);
			static tVoid convert (tFloat  & v, const tFloat s);
			static tVoid convert (tBool   & v, const tFloat s);
			
		// do not allow to create an instance of this class
		private:
			cParser ();
			~cParser ();
		};
	}
}

#endif // CAOSGL_CORE_CPARSER

/**
 * The Catalyst of Design Software License, Version 1.0
 *
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by 
 *        Catalyst of Design (http://talsit.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "caosGL" and "Catalyst of Design" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact caosGL@talsit.org.
 *
 * 5. Products derived from this software may not be called "caosGL",
 *    nor may "caosGL" appear in their name, without prior written
 *    permission of Catalyst of Design.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CATALYST OF DESIGN OR ITS 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 */
// eof