;
; *** Listing 9-23 ***
;
; Performs bit-doubling of a byte in AL to a word in AX
; by using SAR. This is not as fast as bit-doubling with
; a look-up table, but it is faster than any other
; shift-based approach.
; (Conceived by Dan Illowsky.)
;
DOUBLE_BYTE	macro
	mov	bl,al
	rept	8
	shr	bl,1	;get the next bit to double
	rcr	ax,1	;move it into the msb...
	sar	ax,1	;...and replicate it
	endm
	endm
;
	call	ZTimerOn
BYTE_TO_DOUBLE=0
	rept	100
	mov	al,BYTE_TO_DOUBLE
	DOUBLE_BYTE
BYTE_TO_DOUBLE=(BYTE_TO_DOUBLE+1) and 0ffH
	endm
	call	ZTimerOff
