unit HDToken;

interface

function GetToken( s : String ) : String;
function GetParam( s : String ) : String;

implementation

procedure TrimRight( var s : String; c : Char );
begin
  While s[Length(s)] = c do
    Dec( s[0] )
end;

function GetToken( s : String ) : String;
var
  Loc : Byte;
begin
  TrimRight( s, ' ' );
  Loc := Pos( ' ', s );
  If Loc <> 0 then
    GetToken := Copy( s, 1, Loc - 1 )
  else
    GetToken := s
end; { GetToken }

function GetParam( s : String ) : String;
var
  Loc : Byte;
begin
  TrimRight( s, ' ' );
  Loc := Pos( ' ', s );
  If Loc <> 0 then
    GetParam := Copy( s, Loc + 1, Length( s ) - Loc )
  else
    GetParam := ''
end; { GetParam }

begin
end.
