	   	 /*-----------------------------------------------------+
		  |				         M44u3d.cpp					    |
		  |														|
		  |	   Les matrice 4x4 vont etre tres utiles pour       |
		  |	     les anims et tout le reste d'ailleur			|
		  |														|	
		  | 	U2^PoPsy TeAm 1999								|	
		  +-----------------------------------------------------*/


#include "U3D3.h"

//-------------------------------------------------------------------------
//					+------------------------------+
//					|    Les Variables globales    |
//					+------------------------------+
//-------------------------------------------------------------------------

static float identite[4][4]={
	1.,0.,0.,0.,
	0.,1.,0.,0.,
	0.,0.,1.,0.,
	0.,0.,0.,1.
};



//-------------------------------------------------------------------------
//						+---------------------+
//						|    Les Fonctions    |
//						+---------------------+
//-------------------------------------------------------------------------

//----------------------------------------------------------------------------
void m44_identite( Ufloat m[4][4] )
{
	memcpy(m, identite, 16*sizeof(Ufloat) );
}
//----------------------------------------------------------------------------
void m44_translate( Ufloat m[4][4], Ufloat x, Ufloat y, Ufloat z)
{
	m[0][3] += x*m[0][0] + y*m[0][1] + z*m[0][2];
	m[1][3] += x*m[1][0] + y*m[1][1] + z*m[1][2];
	m[2][3] += x*m[2][0] + y*m[2][1] + z*m[2][2];
	m[3][3] += x*m[3][0] + y*m[3][1] + z*m[3][2];
}
//----------------------------------------------------------------------------
void m44_scale( Ufloat m[4][4], Ufloat x, Ufloat y, Ufloat z )
{
	m[0][0] *= x;  m[1][0] *= x;  m[2][0] *= x;  m[3][0] *= x;
	m[0][1] *= y;  m[1][1] *= y;  m[2][1] *= y;  m[3][1] *= y;
	m[0][2] *= z;  m[1][2] *= z;  m[2][2] *= z;  m[3][2] *= z;
}
//----------------------------------------------------------------------------
void m44_multiply( Ufloat d[4][4],Ufloat s1[4][4],Ufloat s2[4][4] )
{
	S16   i;
	Ufloat   tmp[16], *tmpP;

	tmpP = tmp;
	for(i=0; i < 4; ++i)
	{
		Ufloat   xi0 = s1[i][0], xi1 = s1[i][1], xi2 = s1[i][2], xi3 = s1[i][3];

		tmpP[0] = xi0 * s2[0][0] + xi1 * s2[1][0] + xi2 * s2[2][0] + xi3 * s2[3][0];
		tmpP[1] = xi0 * s2[0][1] + xi1 * s2[1][1] + xi2 * s2[2][1] + xi3 * s2[3][1];
		tmpP[2] = xi0 * s2[0][2] + xi1 * s2[1][2] + xi2 * s2[2][2] + xi3 * s2[3][2];
		tmpP[3] = xi0 * s2[0][3] + xi1 * s2[1][3] + xi2 * s2[2][3] + xi3 * s2[3][3];
		tmpP += 4;
	}
	memcpy( d, tmp, 16*sizeof(Ufloat) );
}
//----------------------------------------------------------------------------
