///////////////////////////////////////////////
// Copyright
///////////////////////////////////////////////
//
// Text mode demo compo 5 invitation demo
// Copyright (c) 2002 Jari Komppa
//
//
///////////////////////////////////////////////
// License
///////////////////////////////////////////////
// 
//     This software is provided 'as-is', without any express or implied
//     warranty.    In no event will the authors be held liable for any damages
//     arising from the use of this software.
// 
//     Permission is granted to anyone to use this software for any purpose,
//     including commercial applications, and to alter it and redistribute it
//     freely, subject to the following restrictions:
// 
//     1. The origin of this software must not be misrepresented; you must not
//        claim that you wrote the original software. If you use this software
//        in a product, an acknowledgment in the product documentation would be
//        appreciated but is not required.
//     2. Altered source versions must be plainly marked as such, and must not be
//        misrepresented as being the original software.
//     3. This notice may not be removed or altered from any source distribution.
// 
// (eg. same as ZLIB license)
// 
//
///////////////////////////////////////////////
//
// I originally meant to make T, M, D and C meta-objects and make them
// fly around but got sidetracked to making different-colored balls
// that blended correctly together, which looked so ugly in textmode
// that I decided to use the resulting grayscale image as a bumpmap
// instead, and used the result as a background to those information
// scrollers. About 300% code wasted. =)
//
// Yes, it allocates memory on the first run which is never freed.
//


#include <math.h>
#include <string.h>

char * sprite = NULL;

static void generate()
{
    sprite = new char[256*256];
    memset(sprite,0,256*256);
    for (int i = 0, c = 0; i < 256; i++)
        for (int j = 0; j < 256; j++,c++)
        {
            int v  = (int)(0xff - pow((i-128)*(i-128)+(j-128)*(j-128),1/5.0f) * 50);                
            if (v < 0) v = 0;
            sprite[c] = (char)v;
        }
}

static void drawsprite(int *fb, int x, int y)
{
    x-=128;
    y-=128;
    for (int i = 0, c = 0; i < 256; i++)
        for (int j = 0; j < 256; j++, c++)
            if (x + i > 0 && x + i < 160 &&
                y + j > 0 && y + j < 100)
            {
                int coord = x + i + (y + j) * 160;
                int alpha = (sprite[c] & 0xff);
                int v = fb[coord] + alpha;
                if (v > 0xff) v = 0xff;
                fb[coord] = v;
            }       
}

static void alphaize(int *fb, int tick)
{
    for (int i = 1, c = 160; i < 99; i++)
        for (int j = 0; j < 160; j++, c++)
        {
            int y = i + ((((fb[c+160])) - ((fb[c-160])))>>1) + tick;
            int x = j + ((((fb[c+1])) - ((fb[c-1])))>>1) + tick;
            fb[c] = (((x >> 6) & 1) ^ ((y >> 6) & 1)) ? 0xff0000:0xff7700;
        }
    for (i = 0; i < 100; i++)
    {
        fb[i * 160] = 0;
        fb[i * 160+159] = 0;
    }
    memset(fb, 0, 320 * 2);
    memset(fb + 160*99,0,320*2);

}

void metaobjs(int tick, int *fb)
{
    if (sprite == NULL)
        generate();
    memset(fb,0,160*100*4);
    for (int i = 0; i < 4; i++)
    {
        drawsprite(fb, (int)((sin((tick + i*135) * 0.0163872) * cos((tick + i*34) * 0.0064342) )*80) + 80,
                       (int)((sin((tick + i*30) * 0.0133872) * sin((tick + i*306) * 0.0242354) )*50) + 50);
    }
    alphaize(fb, tick);
}