///////////////////////////////////////////////
// Copyright
///////////////////////////////////////////////
//
// Text mode demo compo 5 invitation demo
// Copyright (c) 2002 Jari Komppa
//
//
///////////////////////////////////////////////
// License
///////////////////////////////////////////////
// 
//     This software is provided 'as-is', without any express or implied
//     warranty.    In no event will the authors be held liable for any damages
//     arising from the use of this software.
// 
//     Permission is granted to anyone to use this software for any purpose,
//     including commercial applications, and to alter it and redistribute it
//     freely, subject to the following restrictions:
// 
//     1. The origin of this software must not be misrepresented; you must not
//        claim that you wrote the original software. If you use this software
//        in a product, an acknowledgment in the product documentation would be
//        appreciated but is not required.
//     2. Altered source versions must be plainly marked as such, and must not be
//        misrepresented as being the original software.
//     3. This notice may not be removed or altered from any source distribution.
// 
// (eg. same as ZLIB license)
// 
//
///////////////////////////////////////////////
//
// 3d fun. Uses d3dx8 math. Almost the same as do3d.cpp, except that
// this one uses an actual mesh, hand-hacked from 3ds max .ASE file.
//
// In case you're wondering, yes, all of those tick*0.375 values 
// are randomly whacked in until they look decent.

#include <d3dx8.h>
#include <math.h>
#include "misc.h"
#include "sphere.h"

// from demo.cpp
extern int blendmode, blendvalue;
extern int backface(vertexuvfloat * vtx);

// now, these probably should be in the sphere.h file..
#define VERTS 42
#define POLYS 80

void do3d3(int tick, int *fb)
{
    memset(fb,0,160*100*4);
    
    D3DXMATRIX camera, projection, world;
// please note the hacky way of doing the zooming:
    D3DXMatrixLookAtLH(&camera,&D3DXVECTOR3(0,0,-100 + (float)sin(tick * 0.0234)*25),&D3DXVECTOR3(0,0,0),&D3DXVECTOR3(0,1,0));  
    D3DXMatrixPerspectiveFovLH(&projection, (3.14f / 360) * 90, 1.0f / 1.3f, 1, 1000);
    D3DXMatrixRotationYawPitchRoll(&world, tick * 0.0324f, tick * 0.0342f, tick * 0.0244f);
    
    D3DXMATRIX res = world;
    D3DXMatrixMultiply(&res,&res,&camera);
    D3DXMatrixMultiply(&res,&res,&projection);
    
    D3DXVECTOR3 src[VERTS];
    srand(0xc0cac01a);
    
    for (int i = 0; i < VERTS; i++)
    {
        src[i].x = verts[i*3+0] * (float)(fabs(sin((tick + i*5) * 0.0234) * sin((tick + i) * 0.01514)) + 0.5f);            
        src[i].y = verts[i*3+1] * (float)(fabs(sin((tick + i*5) * 0.0243) * sin((tick + i*10) * 0.01641)) + 0.5f);
        src[i].z = verts[i*3+2] * (float)(fabs(sin((tick + i*5) * 0.0251) * sin((tick + i*20) * 0.01735)) + 0.5f);
    }
    
    D3DXVECTOR4 tgt[VERTS];
    
    for (i = 0; i < VERTS; i++)
    {
        D3DXVec3Transform(&tgt[i],&src[i],&res);
        tgt[i].x = ((tgt[i].x / tgt[i].w) * 160) + 80;
        tgt[i].y = ((tgt[i].y / tgt[i].w) * 160) + 50;
    }
    
    for (int pass = 0; pass < 2; pass ++)
        for (i = 0; i < POLYS; i++)
        {
            vertexuvfloat vtx[3];
            vtx[0].x = tgt[polys[i*3+0]].x;
            vtx[0].y = tgt[polys[i*3+0]].y;
            vtx[1].x = tgt[polys[i*3+1]].x;
            vtx[1].y = tgt[polys[i*3+1]].y;
            vtx[2].x = tgt[polys[i*3+2]].x;
            vtx[2].y = tgt[polys[i*3+2]].y;
            blendmode = 2;
            blendvalue = 192;
            // Render backfaced polys first..
            if (pass == 0)
            {
                if (backface(vtx))
                {
                    vertexuvfloat temp = vtx[1];
                    vtx[1] = vtx[2];
                    vtx[2] = temp;
                    DrawFlatTriangle(vtx, (i & 1)?0xffffff:0x770000);
                }
            }
            else // ..and then the forward facing ones..
            {
                if (!backface(vtx))
                    DrawFlatTriangle(vtx, (i & 1)?0xffffff:0x770000);
            } // ..and voila, no sorting needed.
        }              
}