///////////////////////////////////////////////
// Copyright
///////////////////////////////////////////////
//
// Text mode demo compo 5 invitation demo
// Copyright (c) 2002 Jari Komppa
//
//
///////////////////////////////////////////////
// License
///////////////////////////////////////////////
// 
//     This software is provided 'as-is', without any express or implied
//     warranty.    In no event will the authors be held liable for any damages
//     arising from the use of this software.
// 
//     Permission is granted to anyone to use this software for any purpose,
//     including commercial applications, and to alter it and redistribute it
//     freely, subject to the following restrictions:
// 
//     1. The origin of this software must not be misrepresented; you must not
//        claim that you wrote the original software. If you use this software
//        in a product, an acknowledgment in the product documentation would be
//        appreciated but is not required.
//     2. Altered source versions must be plainly marked as such, and must not be
//        misrepresented as being the original software.
//     3. This notice may not be removed or altered from any source distribution.
// 
// (eg. same as ZLIB license)
// 
//
///////////////////////////////////////////////
//
// This was meant to be a chaos zoomer but ended up being something else.
//

#include <stdlib.h>
#include <math.h>
#include <string.h>
#include "misc.h"

static void zoom(int * src, int * tgt)
{
    memcpy(tgt,src,160*100*4);
    int i,j;

    for (i = 1; i < 99; i++)
        for (j = 1; j < 159; j++)
        {
            int ofs = i * 160 + j;
            src[ofs] =
                ((tgt[ofs - 1] & 0xf0f0f0) + 
                (tgt[ofs + 1] & 0xf0f0f0) + 
                (tgt[ofs - 160] & 0xf0f0f0) + 
                (tgt[ofs + 160] & 0xf0f0f0) +
                ((tgt[ofs] & 0xf0f0f0) * 12)
                ) >> 4;
        }

        // hand-hacked kludgy coordinates. Fun.

        vertexuvfloat vtx[3];
        vtx[0].x = 0;
        vtx[0].y = 0;
        vtx[0].u = 0+3 +2;
        vtx[0].v = 0+3 -2;
        vtx[1].x = 0;
        vtx[1].y = 99;
        vtx[1].u = 0+3 -2;
        vtx[1].v = 99-3 -2;        
        vtx[2].x = 159;
        vtx[2].y = 0;
        vtx[2].u = 159-3 +2;
        vtx[2].v = 0+3 +2;
        DrawArbitraryTextureTriangle(vtx, src, 160);

        vtx[0].x = 159;
        vtx[0].y = 0;
        vtx[0].u = 159-3 +2;
        vtx[0].v = 0+3 +2;
        vtx[1].x = 0;
        vtx[1].y = 99;
        vtx[1].u = 0+3 -2;
        vtx[1].v = 99-3 -2;        
        vtx[2].x = 159;
        vtx[2].y = 99;
        vtx[2].u = 159-3 -2;
        vtx[2].v = 99-3 +2;        
        DrawArbitraryTextureTriangle(vtx, src, 160);


}

void chaos(int tick, int *fb)
{
    int * src;
    src = new int[160*100];
    memcpy(src,fb,160*100*4);
    
    for (int loops = 0; loops < 8; loops++)
    {
        int x = (int)(sin(tick * (0.053327 * ((loops * 0.2341432) + 1))) * 40) + 80;
        int y = (int)(cos(tick * (0.053454 * ((loops * 0.2341324) + 1))) * 30) + 50;
        x -= 4;
        y -= 4;
        for (int i = 0; i < 8; i++)
            for (int j = 0; j < 8; j++)
                src[(i + y) * 160 + j + x] = 0xf00fff << ((loops) * 2);
        tick += 23801;
    }

    zoom(src,fb);
    delete[] src;
}