;
;                   STARS.COM - 333 bytes star scroller
;
model tiny
codeseg
P286
        org     100h
;
;                                   CODE
;

MAIN:   mov     ax,13h
        int     10h

; Set palette for stars
        mov     dx,3C8h
        mov     al,1
        out     dx,al
        inc     dx
        mov     si,offset StarPal
        mov     cx,Planes*3
        rep     outsb

; Save palette for fading
        call    GetPalette

        mov     ax,0A000h
        mov     es,ax

; Initialize starfield
        call    InitStars

; Main loop
@@1:    cmp     Frame,MaxFrames
        ja      @@2                             
        inc     Frame
        call    WaitVREnd
        call    SetPalette
@@2:    call    WaitVRStart
        call    MoveStars

; Repeat until keypressed
        mov     ah,1
        int     16h
        jz      @@1

; Fade to black, but keep the stars moving
@@3:    call    WaitVREnd
        call    SetPalette
        call    WaitVRStart
        call    MoveStars
        dec     Frame
        jnz     @@3

; Read key pressed and exit program
@@4:    xor     ah,ah
        int     16h
        mov     ax,3
        int     10h

        ret

; GetPalette
; Save palette for fading
; Assumes:  es=data
; Destroys: ax,bx,cx,dx,di
GetPalette      PROC NEAR
        mov     di,offset Palette
        xor     al,al
        mov     cx,768
        mov     dx,3C7h
        out     dx,al
        inc     dx
        inc     dx
        mov     bl,MaxFrames
@G1:    in      al,dx
        shl     ax,8
        div     bl
        stosb
        loop    @G1
        ret
ENDP

; SetPalette
; Sets whole palette
; Assumes:  ds=data
; Destroys: ax,bx,cx,dx,si
SetPalette      PROC NEAR
        xor     al,al
        mov     si,offset Palette
        mov     cx,768
        mov     dx,3C8h
        out     dx,al
        inc     dx
        mov     bl,Frame
@S1:    lodsb
        mul     bl
        shr     ax,8
        out     dx,al
        loop    @S1
        ret
ENDP

; WaitVRStart
; Waits Vertical Retrace to begin
; Assumes:  nothing
; Destroys: ax,dx
WaitVRStart     PROC NEAR
        mov     dx,3DAh
@W1:    in      al,dx
        test    al,8
        jz      @W1
        ret
ENDP

; WaitVREnd
; Wait Vertical Retrace to end
; Assumes:  nothing
; Destroys: ax,dx
WaitVREnd       PROC NEAR
        mov     dx,3DAh
@W2:    in      al,dx
        test    al,8
        jnz     @W2
        ret
ENDP

; InitStars
; Initializes starfield
; Assumes:  ds=data
; Destroys: ax,bx,cx,dx,di,si
InitStars       PROC NEAR
        xor     si,si
        mov     cx, StarCount
        mov     bl,1                            ; bl = star color = speed
        mov     bh,StarCount/Planes             ; bh = star counter

@I1:    call    GetRandom

@I2:    cmp     ax,320                          ; Make sure that X
        jb      @I3                             ; is between 0 and 319
        sub     ax,320
        jmp     @I2

@I3:    mov     [si+TheStars.X],ax              ; save X coord

        call    GetRandom

@I4:    cmp     ax,200
        jb      @I5                             ; Make sure that Y
        sub     ax,200                          ; is between 0 and 199
        jmp     @I4

@I5:    mov     [si+TheStars.Y],ax              ; save Y coord
        mov     [si+TheStars.Z],bl              ; set distance
        mov     [si+TheStars.OldDI],64000       ; set stars old position
                                                ; outside screen
        add     si,(size star)

        dec     bh                              ; all stars in plane processed
        jnz     @I6                             ; no,jump
        mov     bh,StarCount/Planes             ; yes, process next plane
        inc     bl                              ; with different color

@I6:    loop    @I1                             ; process all stars

@@OUT:  ret
ENDP

; GetRandom
; Returns random number in ax
; Assumes:  nothing
; Destroys: (ax)
GetRandom       PROC NEAR
        in      al,40h                          ; get byte from DMA counter
        mov     ah,al
        in      al,40h
        xor     ax,seed                         ; make word random
        mov     seed,ax
        ret
endp

; MoveStars
; Moves starfield
; Assumes:  DS=data, ES=A000
; Destroys: ax,bx,cx,di,si
MoveStars       PROC NEAR
        xor     si,si
        mov     cx, StarCount                   ; process all stars
@M1:    mov     di,[si+TheStars.OldDI]          ; erase old star
        xor     al,al
        stosb

        mov     ax,[si+TheStars.Y]

        shl     ax,6                            ; Multiply Y with 320
        mov     di,ax
        shl     ax,2
        add     di,ax

        mov     ax,[si+TheStars.X]              ; get previous X
        mov     bl,[si+TheStars.Z]              ; get speed
        xor     bh,bh
        sub     ax,bx                           ; get next position
        jns     @NoWrap
        add     ax,319                          ; wrap if negative
@NoWrap:add     di,ax
        mov     [si+TheStars.X],ax
        test    byte ptr [es:di],0              ; Is background 0 (black)?
        jnz     @@OHI2                          ; No, jump
        mov     [si+TheStars.OldDI],di          ; Yes, save DI
        mov     al,[si+TheStars.Z]              ; get color
        stosb                                   ; and draw pixel

@@OHI2: add     si,(size star)                  ; next star
        loop    @M1
        ret
ENDP
;
;                                   DATA
;

; Star structure
star struc
X       dw ?                    ; stars X coord.
Y       dw ?                    ; stars Y coord.
Z       db ?                    ; stars distance
OldDI   dw ?                    ; stars previous position
ends

; INITIALIZED DATA 

StarCount equ 200               ; Count of Stars
Planes    equ 5                 ; Count of Planes
MaxFrames equ 150               ; Frames for fading

; Palette for stars
; NOTE!: There MUST be at least Planes*3 bytes
StarPal:
db      20,20,20                ; The furthest star
db      30,30,30                ;        .
db      40,40,40                ;        .
db      50,50,50                ;        .
db      63,63,63                ; The nearest star

Frame    db 0                   ; Current frame in fading

; ZERO DATA - TO BE REMOVED 
db       0FFh                   ; End of file -marker

Seed     dw 0                   ; random seed

TheStars star StarCount dup (?)
Palette:                        ; Palette for fading
db 768 dup (?)         

end     MAIN
;
                                    END
;
