#include "readasc.h"


typedef struct
{
	float x,y,z;
} POINT3D;

typedef struct
{
		SLONG a,b,c,sm;
} TRI;



#define MAXASCPOINTS 50000
#define MAXTRIS 50000

int ll[MAXTRIS*3][2];

typedef float P3D[3];

SLONG numascpoints,numtris;
int numl=0;
P3D *lascpoint;
POINT3D *ascpoint;
TRI *tri;
FILE *fi;


findword(char *s,LONG n)
{
	char s2[1024];

	do {
		fscanf(fi,"%s",s2);
	} while (strncmp(s2,s,n));
}

void addl(int a, int b)
{
        int c1;
        for (c1=0;c1<numl;c1++) if ((ll[c1][0]==a && ll[c1][1]==b) || (ll[c1][0]==b && ll[c1][1]==a)) return;
        ll[c1][0]=a;
        ll[c1][1]=b;
        numl++;
}

main(int argc, char *argv[])
{
	if (argc!=3)
	{
		printf("usage: readasc infi outfi\n");
		exit(1);
	}
	printf("converting %s --> %s...\n",argv[1],argv[2]);
	ascpoint = (POINT3D*)calloc(sizeof(POINT3D),MAXASCPOINTS);
	lascpoint = (P3D*)ascpoint;
	tri = (TRI*)calloc(sizeof(TRI),MAXTRIS);

	numascpoints=numtris=0;


	SLONG c1,c2,a,b,c;

	fi=fopen(argv[1],"r");
	SLONG numv,numf;
	char s[128],s2[128],s1[128];
	float ax,ay,az,bx,by,bz;
	bx=100000;by=100000;bz=100000;
	ax=-100000;ay=-100000;az=-100000;

	while (fscanf(fi,"%s",s)!=EOF)
	{
		if (strncmp("object:",s,7)==0)
		{
			fscanf(fi,"%s",s);
			printf("object = %s has:\n",s);
		}
		if (strncmp("Tri-mesh",s,8)==0)
		{
			SLONG fixup;
			fixup=numascpoints;
			fscanf(fi,"%s %d %s %d",s1,&numv,s2,&numf);
			printf("vertices = %d  faces = %d \n",numv,numf);
			findword("list",4);
			for (c1=0;c1<numv;c1++)
			{
				findword("Vertex",6);
				fscanf(fi,"%d",&c2);
				if (c2!=c1)
				{
					printf("Vertex mismatch error\n");
					exit(1);
				}
				float x,y,z,u,v;
				if (c1 % 64 == 0) printf(".");
                                fscanf(fi,"%s X:%f Y:%f Z:%f U:%f V:%f",s1,&x,&y,&z,&u,&v);

				if (x<bx) bx=x;if (x>ax) ax=x;
				if (y<by) by=y;if (y>ay) ay=y;
				if (z<bz) bz=z;if (z>az) az=z;
				ascpoint[numascpoints].x=x;ascpoint[numascpoints].y=y;ascpoint[numascpoints].z=z;
				numascpoints++;
			}
			findword("Face",4);
			findword("list",4);
			findword("Face",4);
			for (c1=0;c1<numf;c1++)
			{
				fscanf(fi,"%d",&c2);
				if (c2!=c1)
				{
					printf("Face mismatch error\n");
					exit(1);
				}
				int ab,bc,ca;
				fscanf(fi,"%s A:%d B:%d C:%d AB:%d BC:%d CA:%d",s1,&a,&b,&c,&ab,&bc,&ca);
				a+=fixup;
				b+=fixup;
				c+=fixup;

                                if (ab) addl(a,b);
                                if (bc) addl(b,c);
                                if (ca) addl(c,a);
								int sm=0;
				do {	// oh god this is so ugly but fuck it.
					if (fscanf(fi,"%s",s1)==EOF) goto finishedface;
										if (strncmp("smoothing:",s1,9)==0)
                                        {
                                                sscanf(s1,"Smoothing: %d",sm);
                                                sm--;
                                        }
					if (strncmp("Face",s1,4)==0) goto finishedface;
				} while (1==1);
finishedface:
				tri[numtris].a=a;tri[numtris].b=b;tri[numtris].c=c;
                                tri[numtris].sm=sm;
				//tri[numtris].pad=0;
				numtris++;
				if (c1 % 64 == 0) printf(".");
			}
		}
	}

	#define SCALE 1
        ax=(ax+bx)/2;ay=(ay+by)/2;az=(az+bz)/2;
	for (c1=0;c1<numascpoints;c1++)
	{
		//ascpoint[c1].x-=ax;ascpoint[c1].y-=ay;ascpoint[c1].z-=az;
		//ascpoint[c1].x*=SCALE;ascpoint[c1].y*=-SCALE/1.2;ascpoint[c1].z*=-SCALE;

	}
	printf("\nfinished loading skin mesh.\n");
	fclose( fi);
	printf("%d p, %d t, %d l\n",numascpoints,numtris,numl);

	fi=fopen(argv[2],"wb");
	fwrite(&numascpoints,1,4,fi);
	fwrite(&numtris,1,4,fi);
	//fwrite(&numl,1,4,fi);
	fwrite(ascpoint,numascpoints,sizeof(POINT3D),fi);
	fwrite(tri,numtris,sizeof(TRI),fi);
	//fwrite(ll,numl,8,fi);
	printf("output file size =%d\n",ftell(fi));
	fclose(fi);


}
