;***********************************************************************
; Copyright Alex "Statix" Evans 1995
;
; ASSEMBLER MACROS
;
;***********************************************************************

externdef		gfxprinteax : near
externdef curpos : dword


externdef _sintab:dword;
externdef _reciptab:dword;

sendeoi 	macro	; sends end of interrupt
			mov	al,20h
			out	20h,al
			out	0a0h,al
			endm	

waitborder	macro
			local	w1,w2
			mov	dx,3dah
w1:			in	al,dx
			test	al,8
			jnz	w1
w2:			in	al,dx
			test	al,8
			jz	w2
			endm

setborder	macro	r,g,b
			push	ax
			push	dx
			mov	dx,3c8h
			xor	al,al
			out	dx,al
			inc	dl
			mov	al,r
			out	dx,al
			mov	al,g
			out	dx,al
			mov	al,b
			out	dx,al
			pop	dx
			pop	ax
			endm


sin		macro	  outr,inr   ; gets sin "inr" in "outr"
		ifb <inr>
		  inr = eax
		endif
		ifb <outr>
		  outr = eax
		endif
		ifdif <inr>,<outr>
		  mov		  outr,inr
		endif
		and		outr,1023
		mov		outr,_sintab[outr*4]
		endm

cos		macro	outr,inr	; gets cos "inr" in "outr"
		ifb <inr>
		  inr = eax
		endif
		ifb <outr>
		  outr = eax
		endif
		ifdif <inr>,<outr>
		  mov		  outr,inr
		endif
		add		outr,1024/4
		and		outr,1023
		mov		outr,_sintab[outr*4]
		endm
