#ifndef __VECTORS_H__
#define __VECTORS_H__

#include <math.h>

// i doubt i need anymore than this
typedef float vector2t[2];

struct vector3t
{
   // constructors
   vector3t() {v[0] = v[1] = v[2] = 0;}
   vector3t(float px, float py, float pz) {v[0] = px; v[1] = py; v[2] = pz;}
   vector3t(const vector3t &pVec)
    {v[0] = pVec.v[0]; v[1] = pVec.v[1]; v[2] = pVec.v[2];}
   vector3t(const float *pVec) {v[0] = pVec[0]; v[1] = pVec[1]; v[2] = pVec[2];}

   // assign / equality / greater / less / etc
   vector3t operator=(const vector3t &pVec)
    {return vector3t(v[0] = pVec.v[0], v[1] = pVec.v[1], v[2] = pVec.v[2]);}
   vector3t operator=(const float *ptr)
    {return vector3t(v[0] = ptr[0], v[1] = ptr[1], v[2] = ptr[2]);}
   int operator==(const vector3t &pVec)
    {return (v[0] == pVec.v[0] && v[1] == pVec.v[1] && v[2] == pVec.v[2]);}
   int operator==(const float *pVec)
    {return (v[0] == pVec[0] && v[1] == pVec[1] && v[2] == pVec[2]);}
   inline int operator!=(const vector3t &pVec)
    {return !((*this) == pVec);}
   inline int operator!=(const float *pVec)
    {return !(pVec == (*this));}
   int operator<(const vector3t vec)
    {return ((v[0] < vec[0]) && (v[1] < vec[1]) && (v[2] < vec[2]));}
   int operator<=(const vector3t vec)
    {return ((v[0] <= vec[0]) && (v[1] <= vec[1]) && (v[2] <= vec[2]));}
   int operator>(const vector3t vec)
    {return ((v[0] > vec[0]) && (v[1] > vec[1]) && (v[2] > vec[2]));}
   int operator>=(const vector3t vec)
    {return ((v[0] >= vec[0]) && (v[1] >= vec[1]) && (v[2] >= vec[2]));}

   // indexing into the array, no bound checks
   const float &operator[](int ndx) const {return v[ndx];}
   float &operator[](int ndx)             {return v[ndx];}
   operator float*(void)                  {return v;}

   // + - / * operations
   vector3t &operator+=(const vector3t &pVec) {*this = *this + pVec; return *this;}
   vector3t &operator-=(const vector3t &pVec) {*this = *this - pVec; return *this;}
   vector3t &operator*=(const vector3t &pVec) {*this = *this * pVec; return *this;}
   vector3t &operator*=(float val)          {*this = *this * val; return *this;}
   vector3t &operator/=(const vector3t &pVec) {*this = *this / pVec; return *this;}
   vector3t &operator/=(float val)          {*this = *this / val; return *this;}

   vector3t operator+(const vector3t &pVec)
    {return vector3t(v[0] + pVec.v[0], v[1] + pVec.v[1], v[2] + pVec.v[2]);}
   vector3t operator-(const vector3t &pVec)
    {return vector3t(v[0] - pVec.v[0], v[1] - pVec.v[1], v[2] - pVec.v[2]);}
   vector3t operator*(const vector3t &pVec)
    {return vector3t(v[0] * pVec.v[0], v[1] * pVec.v[1], v[2] * pVec.v[2]);}
   vector3t operator*(float val)
    {return vector3t(v[0] * val, v[1] * val, v[2] * val);}
   friend vector3t operator*(float val, const vector3t &v)
    {return vector3t(v[0] * val, v[1] * val, v[2] * val);}
   vector3t operator/(const vector3t &pVec)  
    {return vector3t(v[0] / pVec.v[0], v[1] / pVec.v[1], v[2] / pVec.v[2]);}
   vector3t operator/(float val)
    {return vector3t(v[0] / val, v[1] / val, v[2] / val);}
   vector3t operator-(void) {return vector3t(-v[0], -v[1], -v[2]);}

   // + - * / operations that don't return a vector3t
   void Clear(void)                    {v[0] = v[1] = v[2] = 0;}
   void Set(float x, float y, float z) {v[0] = x; v[1] = y; v[2] = z;}
   void Set(vector3t &p)                 {v[0] = p[0]; v[1] = p[1]; v[2] = p[2];}
   void Add(vector3t &a, vector3t &b)
    {v[0] = a.v[0] + b.v[0]; v[1] = a.v[1] + b.v[1]; v[2] = a.v[2] + b.v[2];}
   void Add(vector3t &a)
    {v[0] += a.v[0]; v[1] += a.v[1]; v[2] += a.v[2];}
   void Subtract(vector3t &a, vector3t &b)
    {v[0] = a.v[0] - b.v[0]; v[1] = a.v[1] - b.v[1]; v[2] = a.v[2] - b.v[2];}
   void Subtract(vector3t &a)
    {v[0] -= a.v[0]; v[1] -= a.v[1]; v[2] -= a.v[2];}
   void Multiply(vector3t &a, vector3t &b)
    {v[0] = a.v[0] * b.v[0]; v[1] = a.v[1] * b.v[1]; v[2] = a.v[2] * b.v[2];}
   void Multiply(vector3t &a)
    {v[0] *= a.v[0]; v[1] *= a.v[1]; v[2] *= a.v[2];}
   void Divide(vector3t &a, vector3t &b)
    {v[0] = a.v[0] / b.v[0]; v[1] = a.v[1] / b.v[1]; v[2] = a.v[2] / b.v[2];}
   void Divide(vector3t &a)
    {v[0] /= a.v[0]; v[1] /= a.v[1]; v[2] /= a.v[2];}
   void Scale(float val)
    {v[0] *= val; v[1] *= val; v[2] *= val;}
   void Fabs(vector3t &src) {v[0] = (float) fabs(src.v[0]);
    v[1] = (float) fabs(src.v[1]); v[2] = (float) fabs(src.v[2]);}

   // misc garbage
   void Normalize(void);
   float Length(void);
   float Dot(const vector3t &pVec)
    {return v[0] * pVec.v[0] + v[1] * pVec.v[1] + v[2] * pVec.v[2];}
   void Cross(const vector3t &p, const vector3t &q);
   void Clamp(float min, float max);

   float GetDistance(const vector3t &dest);

   void RotateX(float amnt, vector3t &dest);
   void RotateY(float amnt, vector3t &dest);
   void RotateZ(float amnt, vector3t &dest);

   float v[3];
protected:
};

inline void vector3t::Normalize(void) 
{
	float length, len = 0;

	length = Length();

	if (length == 0)
		return;

	len = 1.0f / length;

	v[0] *= len;
	v[1] *= len;
	v[2] *= len;
}

inline float vector3t::Length(void) 
{
   double length = (v[0] * v[0]) + (v[1] * v[1]) + (v[2] * v[2]);
	
	return (float) sqrt(length);
}

inline void vector3t::Cross(const vector3t &p, const vector3t &q)
{
	v[0] = (p.v[1] * q.v[2]) - (p.v[2] * q.v[1]);
	v[1] = (p.v[2] * q.v[0]) - (p.v[0] * q.v[2]);
	v[2] = (p.v[0] * q.v[1]) - (p.v[1] * q.v[0]);
}

// should have some sort of wrap around, not important
inline void vector3t::Clamp(float min, float max)
{
   if (v[0] > max || v[0] < min)
      v[0] = 0;

   if (v[1] > max || v[1] < min)
      v[1] = 0;

   if (v[2] > max || v[2] < min)
      v[2] = 0;   
}

inline float vector3t::GetDistance(const vector3t &dest)
{
   float d1 = dest[0] - v[0];
   float d2 = dest[1] - v[1];
   float d3 = dest[2] - v[2];
   
   return (float) sqrt((d1 * d1) + (d2 * d2) + (d3 * d3));
}

inline void vector3t::RotateX(float amnt, vector3t &dest)
{
   float s = mSin(amnt);
   float c = mCos(amnt);
   float y = v[1];
   float z = v[2];

   dest[0] = v[0];
   dest[1] = (y * c) - (z * s);
   dest[2] = (y * s) + (z * c);
}

inline void vector3t::RotateY(float amnt, vector3t &dest)
{
   float s = mSin(amnt);
   float c = mCos(amnt);
   float x = v[0];
   float z = v[2];

   dest[0] = (x * c) + (z * s);
   dest[1] = v[1];
   dest[2] = (z * c) - (x * s);
}

inline void vector3t::RotateZ(float amnt, vector3t &dest)
{
   float s = mSin(amnt);
   float c = mCos(amnt);
   float x = v[0];
   float y = v[1];

   dest[0] = (x * c) - (y * s);
   dest[1] = (y * c) + (x * s);
   dest[2] = v[2];
}


#endif