#ifndef __MATHLIBH__
#define __MATHLIBH__

#include <math.h>

#define mFabs(a)   (a >= 0 ? a : -a) 
#define mMax(a, b) (a > b ? a : b)

static const double mPi = 3.14159265358979323846264338327950288419716939937510f;
static const float mEpsilon = 1.0e-05f;
static const double m2pi = 2 * mPi;

static float mCos(float angle)
 {return (float) cos(mPi * ((double) angle / 180));}
static float mSin(float angle)
 {return (float) sin(mPi * ((double) angle / 180));}


#endif