#ifndef __DEBUG_H_
#define __DEBUG_H_

#include <windows.h>
#include <stdio.h>
#include <stdarg.h>

#include <gl/gl.h>
#include <gl/glu.h>

#include "imageload.h"
#include "list.h"
#include "scenefactory.h"


typedef struct {
  GLint x, y;
  GLfloat r, g, b;
  char text[256];
} TDbgString;

#define INFOLINE_TIME 200

class TDemoDebug {
  Timage *font;
  TList<TDbgString*>*strings;
  int strCnt;
  GLuint texture;
  GLuint base;
  bool isSetup;

  GLvoid glPrint(GLint x, GLint y, const char *fmt, ...);
  int infoTime;
  char infoText[256];
public:
  bool showDebug;

  TDemoDebug();
  GLint setup();
  GLvoid buildFont(GLvoid);
  GLvoid killFont(GLvoid);
  GLvoid drawText(GLint x, GLint y, GLfloat r, GLfloat g, GLfloat b, const char *fmt, ...);
  GLvoid dumpDebugScreen(GLvoid);
  GLvoid free(GLvoid);
  GLvoid setInfo(const char *fmt, ...);
};

#endif