
#include "timer.h"
#include <time.h>

TTimer::TTimer(void) {
	QueryPerformanceFrequency(&counterFrequency);
}

void TTimer::start(void) {
	QueryPerformanceCounter(&startValue);
}

__int32 TTimer::getMs(void) {
	QueryPerformanceCounter(&actualValue);
	actualValue.LowPart -= startValue.LowPart;
	return MulDiv(actualValue.LowPart, 1000, counterFrequency.LowPart);
}

void TTimer::SetAtMs(__int64 where) {
	startValue.LowPart -= (unsigned long)((where*1000)/counterFrequency.LowPart);
}

__int32 TTimer::getPrecisionTimeCount(int precision) {
	QueryPerformanceCounter(&actualValue);
	actualValue.LowPart -= startValue.LowPart;
	return MulDiv(actualValue.LowPart, precision, counterFrequency.LowPart);
}

__int32 TTimer::getCurrentFrame(int totalframes, int totalms) {
	QueryPerformanceCounter(&actualValue);
	actualValue.LowPart -= startValue.LowPart;
	__int32 t=MulDiv(actualValue.LowPart, 1000, counterFrequency.LowPart);
	return MulDiv(totalframes, t, totalms);
}

__int32 TTimer::getTicks(void) {
	QueryPerformanceCounter(&actualValue);
	actualValue.LowPart -= startValue.LowPart;
	return actualValue.LowPart;
}

__int32 TTimer::getTicksPerSecond(void) {
	return counterFrequency.LowPart/1000;

}

