#ifndef _OGLREPOSITORY_H_
#define _OGLREPOSITORY_H_

#include <windows.h>
#include <gl/gl.h>
#include <gl/glu.h>
#include "list.h"
#include "Imageload.h"

#define USER_TEXTURE 10000

#define userTexture(x) (USER_TEXTURE + x)

enum {NOT_USE_ALPHA = 0, USE_ALPHA = 1};

typedef int TUseAlpha;

class TTextureItem {
public:
  int id;
  GLuint nTexture;
  Timage *image;
  bool isResource;
  TUseAlpha useAlpha;
};


class TTextureRepository {  
  TList <TTextureItem*>*textures;
  GLuint *baseTexture;
  GLint thisTexture;
  TTextureItem *textureExists(int id);
public:
  TTextureRepository();
  ~TTextureRepository();
  void insertTexture(int id, TUseAlpha alpha);  
  void insertTexture(int id, Timage *image, TUseAlpha alpha);
  void uploadTextures();
  void reset();
  void bindTexture(int id);
  GLuint getTextureId(int id);


};


#endif