#include "TextureRepository.h"


TTextureRepository::TTextureRepository()
{
  baseTexture = NULL;
  thisTexture=-1;
  textures = new TList<TTextureItem*>;
}


TTextureItem *TTextureRepository::textureExists(int id)
{
  TNode <TTextureItem*>*temp;

  for (temp = textures->front; temp != NULL; temp = temp->next)
    if (temp->getValue()->id == id)
      return temp->getValue();

  return NULL;
}


void TTextureRepository::insertTexture(int id, TUseAlpha alpha)
{
  TTextureItem *temp;
  if ((temp = textureExists(id)) != NULL)
  {
    temp->useAlpha |= alpha;    
    return;
  }

  TTextureItem *newItem = new TTextureItem;
  newItem->id = id;
  newItem->image = NULL;
  newItem->useAlpha = alpha;
  newItem->isResource = true;
  textures->insert(newItem);
}

void TTextureRepository::insertTexture(int id, Timage *textPtr, TUseAlpha alpha)
{
  TTextureItem *temp;
  if ((temp = textureExists(id)) != NULL)
  {
    temp->useAlpha |= alpha;    
    return;
  }

  TTextureItem *newItem = new TTextureItem;
  newItem->id = id;
  newItem->image = textPtr;
  newItem->useAlpha = alpha;
  newItem->isResource = false;
  textures->insert(newItem);
}


void TTextureRepository::uploadTextures()
{
  reset();
  if (baseTexture != NULL)
    delete baseTexture;
  baseTexture = new GLuint[textures->count];
	glGenTextures(textures->count, baseTexture);

  TNode <TTextureItem*>*temp;

  int i;
  for (temp = textures->front, i = 0; temp != NULL; temp = temp->next, i++)  
  {
    if (temp->getValue()->isResource == true)
      temp->getValue()->image = LoadResourceTGA(temp->getValue()->id);

	  glBindTexture(GL_TEXTURE_2D, baseTexture[i]);
    glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	  glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
    if (temp->getValue()->useAlpha == USE_ALPHA)
      glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, temp->getValue()->image->width, temp->getValue()->image->height, 0, GL_RGBA, GL_UNSIGNED_BYTE, temp->getValue()->image->data);
    else
      glTexImage2D(GL_TEXTURE_2D, 0, GL_RGB, temp->getValue()->image->width, temp->getValue()->image->height, 0, GL_RGBA, GL_UNSIGNED_BYTE, temp->getValue()->image->data);

    temp->getValue()->nTexture = baseTexture[i];

    if (temp->getValue()->isResource == true)
      freeImage(temp->getValue()->image);
  }
}

GLuint TTextureRepository::getTextureId(int id)
{
  TNode <TTextureItem*>*temp;

  for (temp = textures->front; temp != NULL; temp = temp->next)
    if (temp->getValue()->id == id)
      return temp->getValue()->nTexture;

  return GLuint(-1);
}

void TTextureRepository::bindTexture(int id)
{
  if(thisTexture!=id) {
    glBindTexture(GL_TEXTURE_2D, getTextureId(id));			// Select Our Texture  
    thisTexture=id;
  }
}

void TTextureRepository::reset()
{
  thisTexture=-1;
}

TTextureRepository::~TTextureRepository()
{
  delete baseTexture;

  textures->clear();
  delete textures;
}