
//
// Mote win32 test
//
// Copyright (c) 2000 Mikko Mononen <memon@inside.org>
//

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <memory.h>


#include "render.h"
#include "clax.h"
#include "filter.h"

extern "C" {
#include "tinyptc.h"
};


#define WIDTH 400
#define HEIGHT 300
#define SIZE WIDTH*HEIGHT
   
static int index;
static int pixel[SIZE];


int
loadPalette( char* name, int* pal )
{
  // load palette from .pcx picture

  FILE*  fp;

  if ( (fp = fopen( name, "rb" )) != 0 ) {
    fseek( fp, -(256 * 3), SEEK_END );
    
    for ( int i = 0; i < 256; i++ ) {
      pal[i] = (fgetc( fp ) << 16) | (fgetc( fp ) << 8) | fgetc( fp );
    }
    fclose( fp );
  } else
    return clax_err_badfile;
  
  return clax_err_ok;
}



int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{

	c_SCENE*   scene;
	c_CAMERA*  animCam;
	c_OBJECT*  obj;
	w_NODE*    node;

	float      frame, frames, zfar, curFrame;
	int        err;
	int      pal[256];
	int        edgepal[256];
	char*      file;
	int        faces;
	c_VIEWPORT   viewport;


	zfar = 4000.0;
	file = "1.3ds";
  
	err = loadPalette( "palette.pcx", pal );  
	if ( err != clax_err_ok ) {
		return 1;
	}


	clax_init( clax_transform | clax_hierarchy );
	clax_alloc_scene( &scene );

	// Load mesh
	err = clax_load_world( file, scene );
	if ( err != clax_err_ok ) {
		return 1;
	}

	// load keyframes
	err = clax_load_motion( file, scene );
	if ( err != clax_err_ok ) {
		return 1;
	}


	// *** INIT VIEWPORT ***

	// count faces
	faces = 0;

	for ( node = scene->world; node; node = node->next ) {
		if (node->type == clax_obj_object) {
			obj = (c_OBJECT *)node->object;
			faces += obj->numfaces;
		}
	}
	faces++;  // just for fun

	err = viewportOpen( WIDTH, HEIGHT, faces, &viewport );
	if ( err != clax_err_ok ) {
		clax_free_world( scene );
		clax_free_motion( scene );
		return 1;
	}
	viewportSetactive( &viewport );

  
	memset( viewport.outBuffer, 1, (viewport.iWidth * viewport.iHeight) );
	memset( viewport.trBuffer, 1, (viewport.iWidth * viewport.iHeight) );

	clax_setactive_scene( scene );

	// search camera
	animCam = 0;
	for (node = scene->world; node; node=node->next) {
		if (node->type == clax_obj_camera) {
			animCam = (c_CAMERA *)node->object;
			break;
		}
	}

	if ( !animCam ) {
		// there's no camera in scene
		clax_free_world( scene );
		clax_free_motion( scene );
		return 1;
	}
	animCam->xSize = WIDTH;
	animCam->ySize = HEIGHT;
	animCam->pixelHeight = 1;
	animCam->znear = 1.0;
	animCam->zfar  = zfar;
	clax_setactive_camera( animCam );

    if( !ptc_open( "test", WIDTH, HEIGHT ) ) {
		return -1;
	}

	clax_setactive_camera( animCam );
	cam_update( animCam );

	clax_getframes( &frame, &frames );

	curFrame = frame;

/*	for( int i = 0; i < 256; i++ ) {
		int a = (int)(255.0 * pow( (float)i / 255.0, 1.0 / 0.2 ));	// gamma 0.2
		edgepal[i] = a / 16;
	}
*/
	int	pale[256 * 16];

	for( int i = 0; i < 256; i++ ) {
		for( int j = 0; j < 16; j++ ) {
			int m = 15 - (int)(15.0 * pow( (float)j / 15.0, 1.0 / 0.2 ));	// gamma 0.2
			int r = (((pal[i] & 0xff0000) >> 16) * m) >> 4;
			int g = (((pal[i] & 0x00ff00) >> 8) * m) >> 4;
			int b = (((pal[i] & 0x0000ff) >> 0) * m) >> 4;
			pale[i * 16 + j] = (r << 16) | (g << 8) | b;
		}
	}

	OutputDebugString( "MOI\n" );

    while( 1 ) {

		memset( viewport.outBuffer, 120, (viewport.iWidth * viewport.iHeight) );
		memset( viewport.nzBuffer, 0, (viewport.iWidth * viewport.iHeight) * 2 );

		clax_setframe( curFrame );
		clax_update();
		flushPolys();

/*		FILE*	fp;
		fp = fopen( "nz.raw", "wb" );
		fwrite( viewport.nzBuffer, viewport.iWidth * viewport.iHeight * 2, 1, fp );
		fclose( fp );
*/
//		smoothMore( viewport.iWidth, viewport.iHeight, viewport.nzBuffer );
		smoothMore( viewport.iWidth, viewport.iHeight, viewport.nzBuffer );
		edge( viewport.iWidth, viewport.iHeight, viewport.nzBuffer, viewport.trBuffer );

/*		fp = fopen( "tr.raw", "wb" );
		fwrite( viewport.trBuffer, viewport.iWidth * viewport.iHeight, 1, fp );
		fclose( fp );
*/
		for( index = 0; index < SIZE; index++ ) {
//			pixel[index] = edgepal[(unsigned char)viewport.trBuffer[index]^255];
//			if( viewport.trBuffer[index] )
//				pixel[index] = 0;
//			else
//			pixel[index] = pal[(unsigned char)viewport.outBuffer[index]] & edgepal[(unsigned char)viewport.trBuffer[index]^255];
			pixel[index] = pale[((unsigned char)viewport.outBuffer[index] << 4) | (unsigned char)viewport.trBuffer[index]];
		}


        ptc_update(pixel);

		curFrame += .1;
		if( curFrame > frames )
			curFrame = frame;

    }
    ptc_close();

	clax_free_world( scene );
	clax_free_motion( scene );

	return 0;
}
