
//
// Mote win32 test
//
// Copyright (c) 2000 Mikko Mononen <memon@inside.org>
//

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <memory.h>


#include "render.h"
#include "clax.h"
#include "filter.h"

extern "C" {
#include "tinyptc.h"
};


#define WIDTH 400
#define HEIGHT 300
#define SIZE WIDTH*HEIGHT
   
static int index;
static int pixel[SIZE];


int
loadPalette( char* name, int* pal )
{
  // load palette from .pcx picture

  FILE*  fp;

  if ( (fp = fopen( name, "rb" )) != 0 ) {
    fseek( fp, -(256 * 3), SEEK_END );
    
    for ( int i = 0; i < 256; i++ ) {
      pal[i] = (fgetc( fp ) << 16) | (fgetc( fp ) << 8) | fgetc( fp );
    }
    fclose( fp );
  } else
    return clax_err_badfile;
  
  return clax_err_ok;
}



int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{

	c_SCENE*   scene;
	c_CAMERA*  animCam;
	c_OBJECT*  obj;
	w_NODE*    node;

	float      frame, frames, zfar, curFrame;
	int        err;
	int*      pal;
	char*      file;
	int        faces;
	c_VIEWPORT   viewport;


	zfar = 10000.0;
	file = "1.3ds";
  
	pal = new int[256];
	if( !pal ) {
		printf( "error: new pal[]\n" );
		return 1;
	}

	err = loadPalette( "palette.pcx", pal );  
	if ( err != clax_err_ok ) {
		return 1;
	}


	clax_init( clax_transform | clax_hierarchy );
	clax_alloc_scene( &scene );

	// Load mesh
	err = clax_load_world( file, scene );
	if ( err != clax_err_ok ) {
		return 1;
	}

	// load keyframes
	err = clax_load_motion( file, scene );
	if ( err != clax_err_ok ) {
		return 1;
	}


	// *** INIT VIEWPORT ***

	// count faces
	faces = 0;

	for ( node = scene->world; node; node = node->next ) {
		if (node->type == clax_obj_object) {
			obj = (c_OBJECT *)node->object;
			faces += obj->numfaces;
		}
	}
	faces++;  // just for fun

	err = viewportOpen( WIDTH, HEIGHT, faces, &viewport );
	if ( err != clax_err_ok ) {
		clax_free_world( scene );
		clax_free_motion( scene );
		delete [] pal;
		return 1;
	}
	viewportSetactive( &viewport );

  
	memset( viewport.outBuffer, 1, (viewport.iWidth * viewport.iHeight) );
	memset( viewport.trBuffer, 1, (viewport.iWidth * viewport.iHeight) );

	clax_setactive_scene( scene );

	// search camera
	animCam = 0;
	for (node = scene->world; node; node=node->next) {
		if (node->type == clax_obj_camera) {
			animCam = (c_CAMERA *)node->object;
			break;
		}
	}

	if ( !animCam ) {
		// there's no camera in scene
		clax_free_world( scene );
		clax_free_motion( scene );
		delete [] pal;
		return 1;
	}
	animCam->xSize = WIDTH;
	animCam->ySize = HEIGHT;
	animCam->pixelHeight = 1;
	animCam->znear = 1.0;
	animCam->zfar  = zfar;
	clax_setactive_camera( animCam );

    if( !ptc_open( "test", WIDTH, HEIGHT ) ) {
		return -1;
	}

	clax_setactive_camera( animCam );
	cam_update( animCam );

	clax_getframes( &frame, &frames );

	curFrame = frame;

    while( 1 ) {

		memset( viewport.outBuffer, 120, (viewport.iWidth * viewport.iHeight) );
		memset( viewport.nzBuffer, 0, (viewport.iWidth * viewport.iHeight) );

		clax_setframe( curFrame );
		clax_update();
		flushPolys();

		smoothMore( viewport.iWidth, viewport.iHeight, viewport.nzBuffer );
		edge( viewport.iWidth, viewport.iHeight, viewport.nzBuffer, viewport.trBuffer );

		for( index = 0; index < SIZE; index++ ) {
			if( viewport.trBuffer[index] )
				pixel[index] = 0;
			else
				pixel[index] = pal[(unsigned char)viewport.outBuffer[index]];
		}


        ptc_update(pixel);

		curFrame += 1.0;
		if( curFrame > frames )
			curFrame = frame;

    }
    ptc_close();

	clax_free_world( scene );
	clax_free_motion( scene );
	delete [] pal;

	return 0;
}
