/************************************************
 *           RGB <=> YCbCr convertion           *
 *                                              *
 * Skal 98                                      *
 ************************************************/

/*******************************************************
 *
 *  MATRICES:
 *
 * R = Y +            + 1.40200.Cr 
 * G = Y - 0.34414.Cb - 0.71414.Cr
 * B = Y + 1.77200.Cb
 *
 * Y  = 0.29900.R + 0.58700.G + 0.11400.B
 * Cb =-0.16874.R - 0.33126.G + 0.50000.B + 1/2
 * Cr = 0.50000.R - 0.41869.G - 0.08131.B + 1/2
 *
 *
 *******************************************************/

#define _USE_PRIVATE_

#include "main.h"
#include "./jpeg.h"

/*******************************************************/

#define K1  ( 0.29900 )
#define K2  ( 0.58700 )
#define K3  ( 0.11400 )

#define K4  ( -0.16874 )
#define K5  ( -0.33126 )
#define K6  (  0.50000 )

#define K7  (  0.50000 )
#define K8  ( -0.41869 )
#define K9  ( -0.08131 )

/*******************************************************/

EXTERN void RGB_To_Ycc( FLT In[3][64], FLT Out[3][64], FLT YShift )
{
   INT i;
   for( i=0; i<BLOCKSIZE; ++i )  // in-place replacement...
   {
      FLT R = In[0][i], G = In[1][i], B = In[2][i];
      Out[0][i] = (FLT)( R*K1 + G*K2 + B*K3 ) - YShift;
      Out[1][i] = (FLT)( R*K4 + G*K5 + B*K6 ); // + 128.0 - YShift;
      Out[2][i] = (FLT)( R*K7 + G*K8 + B*K9 ); // + 128.0 - YShift;
   }
}

/*******************************************************/
