/*

	Math Library

	M3D_math.h

*/

#ifndef _M3D_MATH_H
#define _M3D_MATH_H

#include <stdio.h>
#include <math.h>
#include <string.h>
#include <malloc.h>


/*

	General routines

*/

int		init_math (void);
float	fsin (int a);
float	fcos (int a);



/*

	Matrix operations

*/

typedef	float M3Dmatrix[4][4];

void	init_matrix (M3Dmatrix matrix);
void	copy_matrix (M3Dmatrix source, M3Dmatrix dest);
extern	void	mult_matrix_matrix (M3Dmatrix mat1, M3Dmatrix mat2, M3Dmatrix result);
void	translate (M3Dmatrix matrix, float x, float y, float z);
void	scale (M3Dmatrix matrix, float s);
void	rotate_XYZ (M3Dmatrix matrix, int x, int y, int z);
void	rotate_YXZ (M3Dmatrix matrix, int x, int y, int z);


/*

	Vector operations

*/

typedef	struct {
	float	x, y, z, w;
} M3Dvector;


void	vector_copy (M3Dvector *source, M3Dvector *dest);
extern	void	mult_vector_matrix (M3Dvector *vector, M3Dmatrix matrix, M3Dvector *result);
float	vector_dot (M3Dvector *a, M3Dvector *b);
float	vector_distance (M3Dvector *a, M3Dvector *b);
float	vector_magnitude (M3Dvector *a);
float	approx_vector_magnitude (M3Dvector *a);
void	vector_add (M3Dvector *a, M3Dvector *b, M3Dvector *result);
void	vector_sub (M3Dvector *a, M3Dvector *b, M3Dvector *result);
void	vector_normalize (M3Dvector *a);
void	approx_vector_normalize (M3Dvector *a);
void	vector_cross (M3Dvector *a, M3Dvector *b, M3Dvector *result);

#endif