/*

	Light library
	
	M3D_lite.c

*/

#include "M3D_lite.h"

/* depth-cueing */
float		M3Ddepth_scale;


M3Dlight	*light_list;
int		num_lights = 0;


int		init_lights (void)
{
	if ((light_list = (M3Dlight *)malloc(LIGHT_BUF * sizeof(M3Dlight))) == NULL) {
		printf("Out of Memory! (lights)\n");
		return (0);
	}
	
	num_lights = 0;
	
	return (1);
}

void	close_lights (void)
{
	free(light_list);
}


void	add_light (float x, float y, float z)
{
	light_list[num_lights].position.x = x;
	light_list[num_lights].position.y = y;
	light_list[num_lights].position.z = z;
	light_list[num_lights].position.w = 1;
	
	num_lights ++;
}


void	rotate_light (M3Dlight *light, float x, float y, float z)
{
	M3Dmatrix	mat;
	float		m11, m21, m31, m41;
	float		m12, m22, m32, m42;
	float		m13, m23, m33, m43;
	float		ox, oy, oz;

	init_matrix(mat);
	rotate_XYZ(mat, x, y, z);

	m11 = mat[0][0]; m21 = mat[1][0]; m31 = mat[2][0]; m41 = mat[3][0];
	m12 = mat[0][1]; m22 = mat[1][1]; m32 = mat[2][1]; m42 = mat[3][1];
	m13 = mat[0][2]; m23 = mat[1][2]; m33 = mat[2][2]; m43 = mat[3][2];
	
	ox = light->position.x;
	oy = light->position.y;
	oz = light->position.z;
				
	light->position.x = ox * m11 + oy * m21 + oz * m31 + m41;
	light->position.y = ox * m12 + oy * m22 + oz * m32 + m42;
	light->position.z = ox * m13 + oy * m23 + oz * m33 + m43;
}


void	translate_light (M3Dlight *light, float x, float y, float z)
{
	light->position.x += x;
	light->position.y += y;
	light->position.z += z;
}


void	tmp_float_to_int (float *a, int *b);
#pragma aux tmp_float_to_int = \
	"fld	dword ptr [eax]"\
	"fistp	dword ptr [ebx]"\
	parm [eax ebx];


void	process_lights (void)
{
	int			i, j, R, G, B, vi;
	float		dot;
	int			idot, ispec;
	M3Dvector	light;
	M3Dmaterial	*mate;
	M3Dtriangle	*pptr;

	for (i = 0; i < visible_polys; i ++) {
		if (sort_list[i].p_num < POLY_BUF) {	
			pptr = &poly_list[sort_list[i].p_num];
	
			/* process all visible (for camera) vertices */
			if ((vertex_list[pptr->v1].status & LIGHT) == LIGHT) {
				vi = pptr->v1;
				mate = &material_list[(pptr->material)];
	
				R = mate->ambient.R >> 2;
				G = mate->ambient.G >> 2;
				B = mate->ambient.B >> 2;
				/* process every lights */
				for (j = 0; j < num_lights; j ++) {
					/* calculate light vector (from light to vertice) */
					vector_sub(&light_list[j].cam_position, &vertex_list[vi].world, &light);
					approx_vector_normalize(&light);
	
					dot = vector_dot(&vertex_list[vi].wnormal, &light);
	
					/* handle only positive intensities */
					if (dot > 0) {
/*						calc_dot_n_spec(&dot, &idot, &ispec);*/
						idot = (int)(dot * 255);
						ispec = (int)(dot * dot * dot * dot * dot * dot * 255);
						R += (light_list[j].color.R * ( ((mate->diffuse.R * idot) >> 9) + ((mate->specular.R * ispec) >> 9)  ) >> 8);
						G += (light_list[j].color.G * ( ((mate->diffuse.G * idot) >> 9) + ((mate->specular.G * ispec) >> 9)  ) >> 8);
						B += (light_list[j].color.B * ( ((mate->diffuse.B * idot) >> 9) + ((mate->specular.B * ispec) >> 9)  ) >> 8);
					}
					
				}
				
				/* if intensity is too large make it smaller (max intensity == 255) */
				if (R <= 255) vertex_list[vi].color.R = (char)R;
				else vertex_list[vi].color.R = 255;
					
				if (G <= 255) vertex_list[vi].color.G = (char)G;
				else vertex_list[vi].color.G = 255;
	
				if (B <= 255) vertex_list[vi].color.B = (char)B;
				else vertex_list[vi].color.B = 255;
					
				vertex_list[vi].status -= LIGHT;
			}
			if ((vertex_list[pptr->v2].status & LIGHT) == LIGHT) {
				vi = pptr->v2;
				mate = &material_list[(pptr->material)];
	
				R = mate->ambient.R >> 2;
				G = mate->ambient.G >> 2;
				B = mate->ambient.B >> 2;
				/* process every lights */
				for (j = 0; j < num_lights; j ++) {
					/* calculate light vector (from light to vertice) */
					vector_sub(&light_list[j].cam_position, &vertex_list[vi].world, &light);
					approx_vector_normalize(&light);
	
					dot = vector_dot(&vertex_list[vi].wnormal, &light);
	
					/* handle only positive intensities */
					if (dot > 0) {
/*						calc_dot_n_spec(&dot, &idot, &ispec);*/
						idot = (int)(dot * 255);
						ispec = (int)(dot * dot * dot * dot * dot * dot * 255);
						R += (light_list[j].color.R * ( ((mate->diffuse.R * idot) >> 9) + ((mate->specular.R * ispec) >> 9)  ) >> 8);
						G += (light_list[j].color.G * ( ((mate->diffuse.G * idot) >> 9) + ((mate->specular.G * ispec) >> 9)  ) >> 8);
						B += (light_list[j].color.B * ( ((mate->diffuse.B * idot) >> 9) + ((mate->specular.B * ispec) >> 9)  ) >> 8);
					}
					
				}
				
				/* if intensity is too large make it smaller (max intensity == 255) */
				if (R <= 255) vertex_list[vi].color.R = (char)R;
				else vertex_list[vi].color.R = 255;
					
				if (G <= 255) vertex_list[vi].color.G = (char)G;
				else vertex_list[vi].color.G = 255;
	
				if (B <= 255) vertex_list[vi].color.B = (char)B;
				else vertex_list[vi].color.B = 255;
					
				vertex_list[vi].status -= LIGHT;
			}
			if ((vertex_list[pptr->v3].status & LIGHT) == LIGHT) {
				vi = pptr->v3;
				mate = &material_list[(pptr->material)];
	
				R = mate->ambient.R >> 2;
				G = mate->ambient.G >> 2;
				B = mate->ambient.B >> 2;
				/* process every lights */
				for (j = 0; j < num_lights; j ++) {
					/* calculate light vector (from light to vertice) */
					vector_sub(&light_list[j].cam_position, &vertex_list[vi].world, &light);
					approx_vector_normalize(&light);
	
					dot = vector_dot(&vertex_list[vi].wnormal, &light);
	
					/* handle only positive intensities */
					if (dot > 0) {
/*						calc_dot_n_spec(&dot, &idot, &ispec);*/
						idot = (int)(dot * 255);
						ispec = (int)(dot * dot * dot * dot * dot * dot * 255);
						R += (light_list[j].color.R * ( ((mate->diffuse.R * idot) >> 9) + ((mate->specular.R * ispec) >> 9)  ) >> 8);
						G += (light_list[j].color.G * ( ((mate->diffuse.G * idot) >> 9) + ((mate->specular.G * ispec) >> 9)  ) >> 8);
						B += (light_list[j].color.B * ( ((mate->diffuse.B * idot) >> 9) + ((mate->specular.B * ispec) >> 9)  ) >> 8);
					}
					
				}

				/* if intensity is too large make it smaller (max intensity == 255) */
				if (R <= 255) vertex_list[vi].color.R = (char)R;
				else vertex_list[vi].color.R = 255;
					
				if (G <= 255) vertex_list[vi].color.G = (char)G;
				else vertex_list[vi].color.G = 255;
	
				if (B <= 255) vertex_list[vi].color.B = (char)B;
				else vertex_list[vi].color.B = 255;
					
				vertex_list[vi].status -= LIGHT;
			}
		}
	}
}

void	draw_light (int num)
{
	int			sx, sy;
	float		x, y, z;
	float		ratio;
	M3Dlight	*light;
	
	light = &light_list[num];

	x = light->cam_position.x;
	y = light->cam_position.y;
	z = light->cam_position.z;

	if (z > 0) {
		ratio = (float)(1.0) / z;
		sx = M3Dview_center_x + (int)((x * M3Ddistance) * ratio);
		sy = M3Dview_center_y - (int)((y * M3Ddistance) * ratio);
		
		if((sx >= M3Dclip_left) && (sx < M3Dclip_right) && (sy >= M3Dclip_top) && (sy < M3Dclip_bot)) {
			M3Dout_buffer[(sx * 4) + (sy * 320 * 4)] = light->color.R;
			M3Dout_buffer[(sx * 4) + (sy * 320 * 4) + 1] = light->color.G;
			M3Dout_buffer[(sx * 4) + (sy * 320 * 4) + 2] = light->color.B;
		}
	}
}