; The "random" output is generated by dumping the content pointed to by ds:si
; column-wise to the vga screen via a bios call, writing one character at a
; time. In each row, the palette index is increased as a preparation for the
; subsequent color cycling effect. dx is required to be zero on entry. The
; destruction of si does not matter, as no memory access is necessary later. In
; the original work by Resident, the "random" input was filtered by explicitly
; skipping all characters which are below ASCII index 20h. However, a "nice"
; output can also be generated by masking in a bit such that the result is at
; least 20h, which is slightly smaller.

;------------------------------------------------------------------------------
;macro for setting up the "random" screen output
;ax, bx, cx, dx, si destroyed
;no result
;------------------------------------------------------------------------------
CreateText MACRO NumRows, NumColumns, ColorInc, Mode
LOCAL ColumnLoop, RowLoop, NextChar
     mov  cl, 01h         ;prepare output of one character
ColumnLoop:
     lodsb		  ;character at ds:si to al, increment si
     mov  bl, al
RowLoop:
     push bx
     xor  bx, bx
     mov  ah, 02h         ;set cursor position, bh=page, dh=row, dl=col
     int  10h
     pop  bx
     mov  ah, 09h         ;write char to cursor pos, al=char, bh=page, bl=col
NextChar:
     lodsb                ;character at ds:si to al for output, increment si
     IF Mode EQ 01h       ;compilation switch for different ways to generate
     or   al, 20h         ;some "nice" output as discussed at the top
     ELSE
     cmp  al, 20h
     jb   NextChar
     ENDIF
     int  10h             ;write character
     add  bl, ColorInc    ;increment color (larger value to make it slower)
     inc  dh              ;increment row index
     cmp  dh, NumRows     ;if the last row is not reached,
     jne  RowLoop         ;process the next row
     mov  dh, 00h
     inc  dx              ;increment column index
     cmp  dl, NumColumns  ;if the last column is not reached,
     jne  ColumnLoop      ;process the next column
ENDM
