;             Ss.
; ----- SSS -----cp437-
;             ~S
;   .s'~ ^~s.           .s'~ ^~s.
;  .SS       'SS.        .SS       'SS.
;  SSS  --  :SS  --  SSS  ----  :SS
;  S".      .SSS        SSS.      ."S
;      s.   .sSS'        'SSs.   .s
;       "*sS*            *Ss*"  Ss.
; .sS.        .s~^    ^~s.       .SSS
;  SSs.    .s"  .   ^~s. "s.    .sSS'
;    '*Ss*"  sS       'SS. "*sS*'
;             SSS  ----  :SS
;             SSS.      .SSS
; --- SSS s.   .sSS' --rac^dug-
;             "S  "*sS*

      DOSSEG              ;assembler directives for .com linking, in particular
     .MODEL tiny          ;this means that the screen output is the program
     .286                 ;itself; see the macro CreateText
     .CODE
      ORG 100h

     INCLUDE mode13h.asm
     INCLUDE clearpal.asm
     INCLUDE text.asm
     INCLUDE colcycle.asm
     INCLUDE retrace.asm
     INCLUDE textmode.asm
     INCLUDE terminat.asm

     NumColors   = 30h
     NumRows     = 19h
     NumColumns  = 28h
     PaletteStep = 08h
     SkipMode    = 01h
     KeyPort     = 60h

Main:
     Mode13h 00h          ;destroys ax

PaletteLoop:              ;the palette is initialized by calling the color
     call Cycle           ;cycling routine several times; the color cycling
     inc al               ;has been refactored as a subroutine -
     jnz PaletteLoop      ;as a glitch, the filling of the screen is visible
     
     CreateText NumRows NumColumns PaletteStep SkipMode

     xor  ax, ax          ;contains the palette index to start with
MainLoop:                 ;color cycling loop starts here
     call Cycle           ;do color cycling proper

     push ax
     WaitRetrace          ;destroys al, dx

     in   al, KeyPort     ;read keyboard,
     dec  al              ;if escape (scancode 1) is pressed,

     jz   Termination     ;then terminate
     pop  ax

     inc  ax              ;increment palette starting index
     jmp  MainLoop

Termination:
     Textmode             ;destroys ax
     Terminate

Cycle:
     ColorCycle NumColors
     ret

     END Main
