//ks_cwarp.cpp : Circle xor warp
//
//Idea from FC's 2nd real, though I didn't spend much
//time getting it to look the same. I'm pretty new to
//asm so if you can optimise the inner loop, tell me.
//
//Compile with bcc.
//
//Comments/Suggestions welcome : ks2@st-andrews.ac.uk
//
//I am not currently a member of any group so if you
//want me, mail me.
//
//Keith/Pixel Magic

#include <math.h>
#include <alloc.h>
#include <conio.h>
#include <dos.h>

char far* bm1;		//Circle bitmaps
char far* bm2;
char far* vga;		//13h screen
char far* mov1[256];	//Pointers used when moving bitmaps
char far* mov2[256];
char warp[256];		//Horizontal warping offsets

unsigned int vgaseg=0xA000;

void main()
{
 char far* tmp;

 bm1=(char far*)farmalloc(0xFFFF);
 bm2=(char far*)farmalloc(0xFFFF);

 if(!bm1||!bm2) return;

 unsigned segbm1=FP_SEG(bm1);
 unsigned segbm2=FP_SEG(bm2);

 long i;
 long j;

 int s=10;			//size of rings

 vga=(char far*)MK_FP(0xA000,0);

 tmp=bm1;

 for(j=-99;j<101;j++)
	for(i=-159;i<161;i++) {
		long dist=i*i+j*j;
		float sqr=sqrt(dist);
		*(tmp++)=((int)(sqr/(float)s)%2) ? 1 : 2;
		}

 tmp=bm2;

 for(j=-99;j<101;j++)
	for(i=-159;i<161;i++) {
		long dist=i*i+j*j;
		float sqr=sqrt(dist);
		*(tmp++)=((int)(sqr/(float)s)%2==0) ? 3 : 4;
		}

 for(i=0;i<256;i++) {

	long x=80.0*cos(((M_PI*2.0)/256.0)*(float)i);
	long y=50.0*sin(((M_PI*2.0)/256.0)*(float)i);

	x+=80;
	y+=50;

	mov1[i]=&bm1[x+y*320];

	x=80.0*cos(((M_PI*4.0)/256.0)*(float)i);	//2*Speed
	y=50.0*sin(((M_PI*4.0)/256.0)*(float)i);

	x+=80;
	y+=50;

	mov2[i]=&bm2[x+y*320];
	}

 for(i=0;i<256;i++) warp[i]=20.0*cos(((M_PI*8.0)/256.0)*(float)i);

 vga+=(80+320*50);	//get vga at center of screen (160x50)

 unsigned char c=0;

 unsigned char x,y;

 asm mov ah,0
 asm mov al,13h
 asm int 10h

 while(!kbhit()) {

	char far* tmpbm1=mov1[c];
	char far* tmpbm2=mov2[c];
	char far* tmpwarp1;
	char far* tmpwarp2;

	c++;

	tmp=vga;

	unsigned char w;

	for(y=0;y<100;y++) {

//		  asm push ax
		asm mov al,c
		asm add al,y
		asm mov w,al
//		  asm pop ax
		tmpwarp1=tmpbm1+warp[w];
		tmpwarp2=tmpbm2+warp[255-w];

		asm push di
		asm push si

//Check with td if ax,cx,bx are in use

//		  asm push cx
//		  asm push ax
//		  asm push bx

		asm mov di,OFFSET tmpwarp1
		asm mov si,OFFSET tmpwarp2

		asm mov cx,OFFSET tmp
		asm mov bx,cx
		asm add bx,160		//loop 160 times

		loop:

		asm mov es,segbm1
		asm mov al,[es:di]
		asm mov es,segbm2
		asm mov ah,[es:si]
		asm inc di
		asm inc si

		asm xor al,ah

		asm mov es,vgaseg
		asm xchg di,cx
		asm stosb
		asm xchg cx,di

		asm cmp cx,bx
		asm jne loop

//		  asm pop bx
//		  asm pop ax
//		  asm pop cx

		asm pop si
		asm pop di

		tmp+=320;
		tmpbm1+=320;
		tmpbm2+=320; }
 }

 getch();

 asm mov ah,0
 asm mov al,3
 asm int 10h
}

