#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>

#include "\sr\h\sr.h"
#include "\lib\h\control.h"
#include "\lib\h\memory.h"
#include "\lib\h\bitmap.h"
#include "h\inside.h"

static char        *palette,*qtable,*tmap,*logopic,*mask,*maskshd;
static char        *envmap;
static SR_FILE     *sro[10];
static SR_MAT      *mat[10];
static SR_SCENE    *scene;
static SR_CAMERA   *camera;
static SR_MESH     *ob[10];
static MATRIX3     obmtx[10],cammtx;
static VECTOR3     obloc[10],camloc;
static BITMAP      *logobmo,*intbmo;
static SR_LIGHT    *light[5];

static int logo_tag;
static int logo_on;
static MATRIX3     rotamatrix;

//-----------------------------------------------------------------------------

static void init_camera()
{
    camera = MEM_allocate_named(sizeof(SR_CAMERA),"camera");
	SR_camera_init(camera);
    SR_add_object  (scene, (SR_OBJ *)camera);

    scene->camera = camera;
    SR_vmake (camloc,0,0,100);
    SR_mrotxyz (cammtx,0,0,0);
}

//-----------------------------------------------------------------------------

static void initialize_objects()
{
    ob[0] = MEM_allocate_named (SR_SIZE(sro[0]),"logo scene object");
    SR_init_object((SR_OBJ *)ob[0]);
    SR_load_object(ob[0],sro[0],65536*1.0,mat[0]);
    SR_set_object_render(ob[0],SR_TEX_G);

    SR_add_object(scene,(SR_OBJ*)ob[0]);
    ob[0]->flags|=SR_DO_LIGHT;
    SR_vmake (obloc[0],0,0,0);
    SR_mrotxyz (obmtx[0],0,0,0);

    light[0] = MEM_allocate_named (sizeof(SR_LIGHT),"logo light source");
    SR_init_object ((SR_OBJ *)light[0]);
    light[0]->falloff = 550;
    light[0]->luminance = 100*16;
    light[0]->flags|=SR_ILLUMINATE;
    SR_add_object(scene,(SR_OBJ*)light[0]);

}

//-----------------------------------------------------------------------------

static void rota_object()
{

    SR_mmul (obmtx[0],rotamatrix);
}

//-----------------------------------------------------------------------------

void logo_irq()
{
    rota_object();
}

//-----------------------------------------------------------------------------

static void copy_locations()
{

    camera->x = camloc[0];      // copy camera parameters
    camera->y = camloc[1];
    camera->z = camloc[2];

    SR_mcopy (camera->matrix,cammtx);

    ob[0]->x = obloc[0][0];
    ob[0]->y = obloc[0][1];
    ob[0]->z = obloc[0][2];

    SR_mcopy (ob[0]->matrix,obmtx[0]);

}

//-----------------------------------------------------------------------------

void logo_turn_picture_on()
{
    logo_on = 1;
}

//-----------------------------------------------------------------------------

void logo_main_loop()
{

    scene->buffer = buffer1;

    file_io++;

    copy_locations();

    file_io--;

    SR_clear_view (scene,0);
    SR_render_view(scene);

    BITMAP_draw (intbmo,31,9);
    if (logo_on)
        BITMAP_draw (logobmo,34,13);

    show_info();
    flip_page();
}

//-----------------------------------------------------------------------------

void logo_load()
{
    file_io++;

    logo_tag = MEM_get_unused_tag();
    MEM_set_tag (logo_tag);

    SR_mrotxyz (rotamatrix,-0.01,0.0085,0.012345);

    tmap        = load_file ("logo/twlogo.raw");
    qtable      = load_file ("logo/logo.shd");
    palette     = load_file ("logo/logo.pal");
    logopic     = load_file ("logo/inside.raw");
    sro[0]      = load_file ("logo/obuke.sro");
    mask        = load_file ("logo/inmask.raw");
    maskshd     = load_file ("logo/inmask.shd");

    mat[0]      = MEM_allocate_named(sizeof(SR_MAT),"logo material");

    scene = MEM_allocate_named(sizeof(SR_SCENE),"logo scene");

    SR_init_scene (scene);
    SR_set_viewport(scene,320,200,0,0,320,200);

    logobmo = BITMAP_make_sprite8 (logopic, 249, 249,139, "logo text");
    logobmo->type = BITMAP8_M;

    intbmo = BITMAP_make_sprite8 (mask, 253, 253, 147, "logo mask");
    intbmo->shade = maskshd;

    intbmo->type = BITMAP8_MI;

    scene->buffer = buffer1;
    scene->perspective = 256/6;
    scene->front_clip_depth = 256*48;

    SR_set_material (mat[0],tmap,NULL,qtable,NULL,255,255,8,8);

    init_camera();
    initialize_objects();
    logo_on = 0;


    file_io--;
}

//-----------------------------------------------------------------------------

void logo_init()
{
    set_base_palette(palette);
    set_demo_irq  (&logo_irq);
    set_demo_loop (&logo_main_loop);

}

//-----------------------------------------------------------------------------

void logo_exit()
{
    set_demo_irq  (NULL);
    set_demo_loop (NULL);
    MEM_free_tagged (logo_tag);
}

//-----------------------------------------------------------------------------

