//-----------------------------------------------------------------------------

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "\sr\h\sr.h"
#include "\lib\h\control.h"
#include "\lib\h\memory.h"
#include "\lib\h\bitmap.h"
#include "h\inside.h"

//-----------------------------------------------------------------------------

#define GW 12
#define GL 10
#define PATHLENGTH 1024

#define SMOKECOUNT 12

static int GSIZ;
static int UVlut[(GL+1)*2];

static int credit_tag;

static SR_SCENE    *scene;
static SR_CAMERA   *camera;
static SR_MAT      *texture,*envmat;
static SR_FILE     *sro,*ballsro;
static SR_MESH     *obj,*obj2,*ball;
static char        *credtext[6];
static BITMAP      *credbmo[6],*mask;
static MATRIX3     cammtx,ballmtx;
static VECTOR3     camloc,balloc;

static char *creditpic;
static char *creditshade,*creditint,*smokeshade,*smokepic,*maskpic,*maskint,*envmap;
static char *palette;
static SR_BITMAPOBJ *smokebmo[SMOKECOUNT];

static SR_VERT     extravert[GL+1];

typedef struct
{
    int x,y,z;
    int g[GW];
    float w[GW];
} pathstruct;

static  pathstruct     *path;
static  float   camrot=0;
static  float   movement;

static  volatile int credpic;

static  volatile int ball_on;
static  volatile float ball_dist = 9.0;

//-----------------------------------------------------------------------------

void credit_ball_on()
{
    ball_on = 1;
}

//-----------------------------------------------------------------------------

void credit_next()
{
    strobo();
    credpic++;
}

//-----------------------------------------------------------------------------

void credit_irq()
{
    MATRIX3 m;
    int gz,mz;
    float f,x,y,z;

    camrot+=(DEGREE_TO_RAD(1.0));

    movement+=47.0;

    gz = movement/GSIZ;
    while (gz<0) gz+=PATHLENGTH;

    gz%=PATHLENGTH;

    mz = (int)movement%GSIZ;

    f = ((float)mz)/GSIZ;

    x = path[gz].x*(1-f) + path[gz+1].x*(f);
    y = path[gz].y*(1-f) + path[gz+1].y*(f);
    z = path[gz].z*(1-f) + path[gz+1].z*(f);

    camloc[0]=camloc[0]*0.8+x*0.2;
    camloc[1]=camloc[1]*0.8+y*0.2;
    camloc[2]=camloc[2]*0.8+z*0.2;

    SR_mrotxyz (m,0.01,0.008675,0.0123);       // rotate spike ball
    SR_mmul (ballmtx,m);

    if (ball_on) ball_dist-=0.015;

    gz+=(int)ball_dist+3;

    gz%=PATHLENGTH;

    x = path[gz].x*(1-f) + path[(gz+1)%PATHLENGTH].x*(f);
    y = path[gz].y*(1-f) + path[(gz+1)%PATHLENGTH].y*(f);
    z = path[gz].z*(1-f) + path[(gz+1)%PATHLENGTH].z*(f);

    balloc[0] = balloc[0]*0.96 + x*0.04;
    balloc[1] = balloc[1]*0.96 + y*0.04;
    balloc[2] = balloc[2]*0.96 + z*0.04;

}

//-----------------------------------------------------------------------------

void copy_locations ()
{
    int gz,mz;
    float x,y,z;
    float f;
    MATRIX3 m;
    VECTOR3 v,v2;

    gz = movement/GSIZ;
    while (gz<0) gz+=PATHLENGTH;

    gz%=PATHLENGTH;

    mz = (int)movement%GSIZ;
    f = ((float)mz)/GSIZ;

    camera->x = camloc[0];
    camera->y = camloc[1];
    camera->z = camloc[2];

    gz+=3;
    gz%=PATHLENGTH;

    x = path[gz].x*(1-f) + path[(gz+1)%PATHLENGTH].x*(f);
    y = path[gz].y*(1-f) + path[(gz+1)%PATHLENGTH].y*(f);
    z = path[gz].z*(1-f) + path[(gz+1)%PATHLENGTH].z*(f);

    SR_look_at_point (camera,camera->x*0.8+x*0.2,y,z);

    SR_mcopy (ball->matrix,ballmtx);            // copy spike ball matrix

    ball->x = balloc[0];
    ball->y = balloc[1];
    ball->z = balloc[2];
}

//-----------------------------------------------------------------------------

void copy_extra_vertices()
{
    int i;
    for (i=0; i<=GL; i++)
    {
        SR_vertex_copy (&(extravert[i]),&(obj->vertex[i*GW]));
        extravert[i].next=&(extravert[i+1]);
        extravert[i].u = 256*16+(256*16)/GSIZ;
    }

    extravert[GL].next = NULL;
}

//-----------------------------------------------------------------------------

void calculate_tunnel()
{
    int x,y,gx,gz,vv,mx,mz,ggz,z,g,i,gg;
    float w;
    SR_VERT *v,*v2;
    VECTOR3 ww;
    MATRIX3 m;

    obj->x = camera->x;
    obj->y = camera->y;
    obj->z = camera->z;

    ggz = (int)movement/GSIZ;

    gz = (int)movement/GSIZ;
    while (gz<0) gz+=GL;

    mz = gz%GL;

    v  = obj->vertex;
    v2 = obj2->vertex;

    for (z=0; z<=GL; z++)
    for (x=0; x<GW; x++,v++,v2++)
    {
        v->u = (x*256*16.0)/GW;
        v->v = UVlut[(mz+z)];

        w = path[(ggz+z)%PATHLENGTH].w[x];

        SR_vmake (ww,v2->x*w,v2->y*w,0);
        SR_mrotv (ww,camera->matrix);

        g = path[(ggz+z)%PATHLENGTH].g[x];
        v->x = (ww[0])+(path[(ggz+z)%PATHLENGTH].x)-camera->x;
        v->y = (ww[1])+(path[(ggz+z)%PATHLENGTH].y)-camera->y;
        v->z = (ww[2])+(path[(ggz+z)%PATHLENGTH].z)-camera->z;

        gg = (sqrt(v->x*v->x + v->y*v->y + v->z*v->z)-7*GSIZ);

        if (gg>0)
            g-=gg;

        if (g<7*16)
            g = 7*16;

        v->g = g;
    }

    for (i=0; i<SMOKECOUNT; i++)
    {
        smokebmo[i]->x = (path[(i+ggz)%PATHLENGTH].x)+180;
        smokebmo[i]->y = (path[(i+ggz)%PATHLENGTH].y)+180;
        smokebmo[i]->z = (path[(i+ggz)%PATHLENGTH].z)+0;
    }

    copy_extra_vertices();

    SR_mrotxyz (m,0,0,camrot);
    SR_mmul (camera->matrix,m);

}

//-----------------------------------------------------------------------------

void credit_main_loop()
{
	int x,y;
	SR_VERT *v;
    int mid;
    int tu,tv;

    scene->buffer      = buffer1;

    cli++;
    copy_locations();
    cli--;
    calculate_tunnel();

    if (ball_on)
        ball->flags&=~SR_DISABLE; else
        ball->flags|=SR_DISABLE;


    SR_clear_view(scene,0);
    SR_render_view(scene);

    if (!ball_on)
        BITMAP_draw(mask, 0, 0);
    if (credpic<5 && credpic>=0)
        BITMAP_draw(credbmo[credpic], 0, 117);


    show_info();
	flip_page();

}

//-----------------------------------------------------------------------------

void make_path()
{
    int i,j;
    float x,y,z,g,w;
    float x1,y1,z1;
    VECTOR3 v;


    path = MEM_allocate_named(sizeof(pathstruct)*PATHLENGTH,"credits flight path");

    x1 = 0;
    y1 = 0;
    z1 = 0;
    for (i=0; i<PATHLENGTH; i++)
    {
        x=(fabs(1500.0*sin(i/10.3))+fabs(5530.0*cos((i+20)/7.1))-1650.0*cos((i-10)/14.4)+2757*cos((i+20.4)/16.5)+fabs(3130.0*sin((i+15)/14.3)))*1.0;
        y=(fabs(1250.0*sin((i+111)/6.3))-fabs(4240.0*cos((i+20)/10.1))+2363.0*cos((i+60)/28.4)-2653*cos(i/14.5)-1100.0*sin((i+30)/21.3)*1.2);

        SR_vmake (v,x,y,GSIZ);
        SR_vabs (v,GSIZ);

        x1+=v[0];
        y1+=v[1];
        z1+=v[2];

        w = (float)(rand()%900)/1200.0 + 0.65;

        for (j=0; j<12; j++)
        {
            path[i].w[j] = w+fabs(sin((j)/3.1)*0.4)+(rand()%200)/1000.0;
            g = (0.4*sin((i+j*0.8)/3.05)+fabs(1.0*sin((i+j)/2.23)+(0.5*sin(i/10.3)+0.5*cos((i-j)/17.1)+0.8*sin((i+10)/13.1)+0.2*cos((i+10)/41.3))/3.0))*64*16;
            if (g<0) g = 0;
            if (g>63*16) g= 63*16;
            path[i].g[j] = g;
        }

        path[i].x = x1;
        path[i].y = y1;
        path[i].z = z1;
    }

}

//-----------------------------------------------------------------------------

void init_smokes()
{
    int i;

    SR_BITMAPOBJ *b;

    for (i=0; i<SMOKECOUNT;i++)
    {
        b = MEM_allocate_named (sizeof(SR_BITMAPOBJ),"tunnel smoke");

        SR_bitmap_init(b);

        b->pipeline = SR_BMOpipeline;
        b->render_func = &SR_BMP_I;
        b->bitmap = smokepic;
        b->qtable = smokeshade;
        b->physwidth= 64;
        b->xsiz   = 64;
        b->ysiz   = 64;
        b->refscale = 1;
        b->scale = 0.35;
        b->depth = 0;

        SR_add_object(scene,(SR_OBJ *)b);
        smokebmo[i]=b;
    }
}

//-----------------------------------------------------------------------------

void credit_load()
{
    int i;

    credit_tag = MEM_get_unused_tag();
    MEM_set_tag (credit_tag);

    file_io++;

    palette     = load_file ("credits/tunnel.pal");
    creditpic   = load_file ("credits/tunnel.raw");

    creditshade = load_file ("credits/tunnel.shd");  // gouraud table
    smokeshade  = load_file ("credits/smoke.shd");   // flare table

    smokepic    = load_file ("credits/sauhu.raw");
    creditint   = load_file ("credits/tunnel.int");  // crediittitekstit
    envmap      = load_file ("credits/piikkis.raw");

    credtext[0] = load_file ("credits/kredu1.raw");
    credtext[1] = load_file ("credits/kredu2.raw");
    credtext[2] = load_file ("credits/kredu3.raw");
    credtext[3] = load_file ("credits/kredu6.raw");
    credtext[4] = load_file ("credits/kredu7.raw");
    credtext[5] = load_file ("credits/kredu8.raw");
    maskpic     = load_file ("credits/wtrmask.raw");
    maskint     = load_file ("credits/wtrmask.int"); // mask intensity

    sro         = load_file ("credits/tuubi.sro");
    ballsro     = load_file ("credits/piikkis.sro");

    scene   = MEM_allocate_named(sizeof(SR_SCENE) ,"credit scene");
    camera  = MEM_allocate_named(sizeof(SR_CAMERA),"credit camera");
    texture = MEM_allocate_named(sizeof(SR_MAT)   ,"credit material");
    envmat  = MEM_allocate_named(sizeof(SR_MAT)   ,"credit spike envmap");
    obj     = MEM_allocate_named(SR_SIZE(sro)     ,"credit tunnel");
    obj2    = MEM_allocate_named(SR_SIZE(sro)     ,"credit tunnel");
    ball    = MEM_allocate_named(SR_SIZE(ballsro) ,"credit spikeball");


	SR_camera_init (camera);
    SR_init_scene (scene);

	SR_set_viewport(scene,320,200,0,0,320,200);

    scene->camera      = camera;
    scene->perspective = 256;
    scene->front_clip_depth = 64*256;

    SR_set_location((SR_OBJ *)camera, 0,0,0);
    SR_set_rotation((SR_OBJ *)camera, 0,0,0);
	SR_add_object(scene, camera);

    SR_init_object ((SR_OBJ *)obj);
    SR_load_object (obj,sro,65536*7,texture);
    SR_set_object_render(obj, SR_TEX_G);
	SR_add_object (scene, (SR_OBJ *)obj);

    SR_init_object ((SR_OBJ *)ball);
    SR_load_object (ball,ballsro,65536*0.8,envmat);
    SR_set_object_render(ball,SR_TEX);
    ball->flags|=SR_ENVLOCAL|SR_DISABLE;
    SR_add_object (scene, (SR_OBJ *)ball);
    SR_mrotxyz (ballmtx,0,0,0);

    obj->flags|=SR_NOCULL;

    SR_mesh_relocate_vertices(obj,0,0,-obj->vertex[0].z);

//-----------------------------------------------------------------------------

    SR_mesh_copy (obj2,obj);

    texture->bitmap1 = creditpic;
    texture->shade1  = creditshade;
    texture->shade2  = NULL;
	texture->flags	 = 0;
    texture->widthmask  = 0xFF;
    texture->heightmask = 0x3FF;
    texture->widthbits  = 8;
    texture->heightbits = 10;

    envmat->bitmap1 = envmap;
    envmat->shade1  = NULL;
    envmat->shade2  = NULL;
    envmat->flags   = 0;
    envmat->widthmask  = 0xFF;
    envmat->heightmask = 0xFF;
    envmat->widthbits  = 8;
    envmat->heightbits = 8;

    GSIZ = obj->vertex[13].z-obj->vertex[0].z;

    SR_mrotxyz (cammtx,0,0,0);
    SR_vmake(camloc,0,0,0);

    credbmo[0] = BITMAP_make_sprite8(credtext[0],173,173,75,"destop");
    credbmo[2] = BITMAP_make_sprite8(credtext[1],146,146,75,"jouni");
    credbmo[4] = BITMAP_make_sprite8(credtext[2],318,318,82,"yolk+legend");
    credbmo[5] = BITMAP_make_sprite8(credtext[3],294,294,75,"santtu");
    credbmo[1] = BITMAP_make_sprite8(credtext[4],129,129,75,"wili");
    credbmo[3] = BITMAP_make_sprite8(credtext[5],154,154,70,"jussi");

    mask       = BITMAP_make_sprite8(maskpic,320,320,200,"credit mask");

    mask->type = BITMAP8_I;
    mask->shade = maskint;


    for (i=0; i<6; i++)
    {
        credbmo[i]->type = BITMAP8_MI;
        credbmo[i]->shade = creditint;
    }

    file_io--;


    for (i=0; i<(GL+1)*2; i++)
        UVlut[i] = (256*16*i)/GL;

    obj->vertex[obj->vnum-1].next = &(extravert[0]);

    for (i=0; i<GL-1; i++)
    {
        obj->poly[(i+1)*2*GW-1].p2 = &(extravert[i+1]);
        obj->poly[(i+1)*2*GW-2].p2 = &(extravert[i+1]);
        obj->poly[(i+1)*2*GW-2].p1 = &(extravert[i]);
    }

    SR_mrotxyz (camera->matrix,0,0,0);
    SR_vmake (camloc,0,0,0);
    SR_vmake (balloc,0,0,0);

    make_path();
    init_smokes();
    credpic = -1;
    ball_on = 0;

}

//-----------------------------------------------------------------------------

void credit_init()
{

    set_demo_irq  (&credit_irq);
    set_demo_loop (&credit_main_loop);
    set_base_palette(palette);
}

//-----------------------------------------------------------------------------

void credit_exit()
{
	set_demo_irq  (NULL);
	set_demo_loop (NULL);
    MEM_free_tagged (credit_tag);
}

//-----------------------------------------------------------------------------
