
/**************************
   CODECONQUEST #4
   -Caleidoscopio-
   http://codepixel.com
   derethor@codepixel.com

   Versin MS Visual C++ 6.0
***************************/
 
#include <stdio.h>
#include <stdlib.h>
//incluir tinyptc
extern "C"{
#include "tinyptc/tinyptc.h"
}


//ancho y alto de la ventana
#define ANCHO	512
#define ALTO	512


// Vars y defines by  HgH
#define DWORD	unsigned int	
#define WORD	unsigned short 
#define BYTE	unsigned char

struct Vector2d
{
	float x;
	float y;
};

// Buffers de trabajo
DWORD imagen[256*256];
DWORD workBuffer[512*512];
DWORD kaleidoscope[512*512];

// Parametros leidos desde fichero
DWORD	minSizeK;
DWORD	maxSizeK;
char	ficheroBitmap[512];
float	incPhi;
float	incDespX;
float	incDespY;



bool loadIni(char *fileName)
{
	FILE *ff;
	ff= fopen(fileName,"r");
	if (ff==NULL)
		return false;
	
	fscanf(ff,"%d\n",&minSizeK);
	fscanf(ff,"%d\n",&maxSizeK);
	fscanf(ff,"%f\n",&incDespX);
	fscanf(ff,"%f\n",&incDespY);
	fscanf(ff,"%f\n",&incPhi);
	fscanf(ff,"%s\n",ficheroBitmap);

	fclose(ff);

	return true;
}

// Carga de un fichero RAW..
// Soy un vago y no me apetece cargar archivos
// comprimidos :P
bool loadRaw(char *fileName,DWORD *buffer, DWORD size)
{
	FILE *ff;
	
	ff = fopen(fileName,"rb");

	if (ff==NULL)
		return false;

	DWORD tmp;
	for (DWORD ind=0;ind<size;ind++)
	{
		fread(&tmp,4,1,ff);


		buffer[ind] = ((tmp & 0xff)<<16 );
		buffer[ind] += (tmp & 0xff00);
		buffer[ind] += ((tmp & 0xff0000)>>16);
	}
	fclose(ff);
		
	return true;
}

// Calculo de los adders para la rotacin del bitmap
void calcAdders(float phi,Vector2d *adderx,Vector2d *addery)
{
	float cosPhi;
	float sinPhi;

	// sacamos seno y coseno.
	// fpu ruuulz! ;)
	_asm
	{
		fld [phi]
		fsincos
		fstp [cosPhi];
		fstp [sinPhi];
	}

	adderx->x = cosPhi;
	adderx->y = -sinPhi;

	addery->x = sinPhi;
	addery->y = cosPhi;
}



// Rotacin2d del un bitmap
// bitmap original 256*256
// bitmap final, tamao libre
void rotateBitmapRGB(DWORD *origin, DWORD *dest, float phi, DWORD ancho, DWORD alto,float dx,float dy,DWORD power)
{
	Vector2d adderx,addery;
	DWORD  xx;
	DWORD  yy;
	DWORD  filaY;
	DWORD  andNumber = (1<<power)-1;

	calcAdders(phi,&adderx,&addery);

	float tmpx=0.0f,tmpy=0.0f;
	
	float origx=dx,origy = dy;

	
	for (yy=0;yy<alto;yy++)
	{
		origx += addery.x;
		origy += addery.y;
		
		tmpx = origx;
		tmpy = origy;

		filaY = yy*ancho;
		for (xx=0;xx<ancho;xx++)
		{
			
			tmpx+= adderx.x;
			tmpy+= adderx.y;
			
			DWORD dummy = DWORD(tmpx) & andNumber ;
			dummy += ((DWORD(tmpy) & andNumber )<<power);
			dest[filaY +xx] = origin[DWORD(dummy)];
		}
	}
}
// Dibujado del tringulo y su espejo
void drawK(DWORD *origen,DWORD *destino,DWORD ladoTri,DWORD anchoOrigen,DWORD anchoDestino)
{
	
	DWORD tmp;
	DWORD filaOrigen;
	DWORD filaDestino;

	for(DWORD yy=0;yy<ladoTri;yy++)
	{
		filaOrigen = yy*anchoOrigen;
		filaDestino = yy*anchoDestino;

		for(DWORD xx=yy;xx<ladoTri;xx++)
		{
			  tmp = origen[filaOrigen+xx];
			  destino[filaDestino+xx] = tmp;
			  destino[xx*anchoDestino+yy] = tmp;
		}
	}
}

// Mirror horizontal sobre el mismo buffer
void doMirrorH(DWORD *buffer, DWORD alto,DWORD ancho,DWORD anchoBuffer)
{
	DWORD xx,yy;

	DWORD filaBuffer;
	DWORD mirrorh = 2*ancho-1;

	for(yy=0;yy<alto;yy++)
	{
		filaBuffer = yy*anchoBuffer;
		for(xx=0;xx<ancho;xx++)
			buffer[filaBuffer +(mirrorh-xx)] = buffer[filaBuffer+xx];
		
	}
		

}

// Mirror vertical sobre el mismo buffer
void doMirrorV(DWORD *buffer, DWORD alto,DWORD ancho,DWORD anchoBuffer)
{
	DWORD xx,yy;

	DWORD filaBuffer;
	DWORD filaBufferMirror;
	DWORD mirrorv = 2*alto-1;

	for(yy=0;yy<alto;yy++)
	{
		filaBuffer = yy*anchoBuffer;
		filaBufferMirror =(mirrorv-yy)*anchoBuffer;

		for(xx=0;xx<ancho;xx++)
			buffer[filaBufferMirror +xx] = buffer[filaBuffer+xx];
		
	}
}



void doKaleydoscope(DWORD minSize,DWORD maxSize,float phi,float dx,float dy)
{
	DWORD sizeH,sizeV;


	// Rotar y mover el bitmap original
	rotateBitmapRGB(imagen,workBuffer,phi,512,512,dx,dy,8);
	
	// Dibujo el primer tringulo y su reflejo 
	drawK(workBuffer,kaleidoscope,minSize,512,maxSize);
	// Hago mirror en horizontal hasta el mximo
	sizeH = minSize;
	while (sizeH<maxSize)
	{
		doMirrorH(kaleidoscope,minSize,sizeH,maxSize);
		sizeH<<=1;
	}
	// Hago mirror vertical hasta el mximo
	sizeV = minSize;
	while (sizeV<maxSize)
	{
		doMirrorV(kaleidoscope,sizeV,maxSize,maxSize);
		sizeV<<=1;
	}
}

int main (int argc, char *argv[])
{

	if (!loadIni("config.hgh"))
		return -1;

	loadRaw(ficheroBitmap,imagen,256*256);
	//Abrir ventana (pon tu nombre en las interrogaciones)
	if (!ptc_open("Codeconquest#4 - Cutredoscopio por HgH ", ANCHO, ALTO)) 
		return -1;

	float phi = 0;
	float despx=0,despy=0;

	while(1)
	{
		doKaleydoscope(minSizeK,maxSizeK,phi,despx,despy);
		phi+=incPhi;
		despx+=incDespX;
		despy+=incDespY;
		//Volcar el buffer a la ventana
		ptc_update(kaleidoscope);
	}

	return 0;
}



