/*
**
**	Flag effect by pompy / ethereal
**  ported for Ethereal Demo Engine by FirEdge
**
*/


#include <windows.h>
#include <gl/gl.h>
#include <gl/glaux.h>

#include <memory.h>
#include <math.h>
#include <assert.h>



#include "fxFlag.hpp"



void fxFlag::doForceCalc(int mex, int mey, int himx, int himy) 
{
		vertex *me = &flag[mex][mey];
		vertex *him = &flag[himx][himy];
		vertex temp;

		temp.x = him->x - me->x;
		temp.y = him->y - me->y;
		temp.z = him->z - me->z;

		float len = (float) sqrt(temp.x*temp.x + temp.y*temp.y + temp.z*temp.z);

		int diffy = mey - himy;
		int diffx = mex - himx;

		float unlen = UNIT * (float) sqrt( diffy*diffy + diffx*diffx );

		float k = (len - unlen) / (len*len) * SPRINGCONST;

/*		if (k >  1.0f) k =  1.0f;
		if (k < -1.0f) k = -1.0f; // */

		assert( abs((int)k) < 1 );	// I'll try to find a solution using the demo engine.

		temp.x *= k;
		temp.y *= k;
		temp.z *= k;

		velocity[mex][mey].x += temp.x;
		velocity[mex][mey].y += temp.y;
		velocity[mex][mey].z += temp.z;
}
	
	
void fxFlag::calcSpringForce() 
{
		for(int x=1; x<XSIZE-1; x++) {
			for(int y=1; y<YSIZE-1; y++) {
				// nearest 4
				doForceCalc(x, y, x+1, y);
				doForceCalc(x, y, x, y+1);
				doForceCalc(x, y, x-1, y);
				doForceCalc(x, y, x, y-1);

				// next nearest 4
				doForceCalc(x, y, x+1, y-1);
				doForceCalc(x, y, x+1, y+1);
				doForceCalc(x, y, x-1, y-1);
				doForceCalc(x, y, x-1, y+1);

				// next ring
/*				doForceCalc(x, y, x+2, y);
				doForceCalc(x, y, x-2, y);
				doForceCalc(x, y, x+2, y+1);
				doForceCalc(x, y, x-2, y+1);
				doForceCalc(x, y, x+2, y-1);
				doForceCalc(x, y, x-2, y-1);
				doForceCalc(x, y, x+2, y+2);
				doForceCalc(x, y, x-2, y+2);
				doForceCalc(x, y, x+2, y-2);
				doForceCalc(x, y, x-2, y-2);
				doForceCalc(x, y, x+1, y+2);
				doForceCalc(x, y, x-1, y+2);
				doForceCalc(x, y, x+1, y-2);
				doForceCalc(x, y, x-1, y-2);
				doForceCalc(x, y, x, y+2);
				doForceCalc(x, y, x, y-2); // */
			}
		}
		for(x=1; x<XSIZE-1; x++) {
			// top row
			doForceCalc(x, 0, x+1, 0);
			doForceCalc(x, 0, x-1, 0);
			doForceCalc(x, 0, x, 1);
			doForceCalc(x, 0, x+1, 1);
			doForceCalc(x, 0, x-1, 1);
			// bottom row
			doForceCalc(x, YSIZE-1, x+1, YSIZE-1);
			doForceCalc(x, YSIZE-1, x-1, YSIZE-1);
			doForceCalc(x, YSIZE-1, x, YSIZE-2);
			doForceCalc(x, YSIZE-1, x+1, YSIZE-2);
			doForceCalc(x, YSIZE-1, x-1, YSIZE-2);

/*			// nearest 4
			doForceCalc(x, 1, x+1, 1);
			doForceCalc(x, 1, x, 2);
			doForceCalc(x, 1, x-1, 1);
			doForceCalc(x, 1, x, 0);
			// next nearest 4
			doForceCalc(x, 1, x+1, 0);
			doForceCalc(x, 1, x+1, 2);
			doForceCalc(x, 1, x-1, 0);
			doForceCalc(x, 1, x-1, 2);


			// nearest 4
			doForceCalc(x, YSIZE-2, x+1, YSIZE-2);
			doForceCalc(x, YSIZE-2, x, YSIZE-1);
			doForceCalc(x, YSIZE-2, x-1, YSIZE-2);
			doForceCalc(x, YSIZE-2, x, YSIZE-3);
			// next nearest 4
			doForceCalc(x, YSIZE-2, x+1, YSIZE-3);
			doForceCalc(x, YSIZE-2, x+1, YSIZE-1);
			doForceCalc(x, YSIZE-2, x-1, YSIZE-3);
			doForceCalc(x, YSIZE-2, x-1, YSIZE-1);*/

		}
		for(int y=1; y<YSIZE-1; y++) {
			doForceCalc(XSIZE-1, y, XSIZE-2, y);
			doForceCalc(XSIZE-1, y, XSIZE-1, y+1);
			doForceCalc(XSIZE-1, y, XSIZE-1, y-1);

			doForceCalc(XSIZE-1, y, XSIZE-2, y+1);
			doForceCalc(XSIZE-1, y, XSIZE-2, y-1);

/*			// nearest 4
			doForceCalc(XSIZE-2, y, XSIZE-2+1, y);
			doForceCalc(XSIZE-2, y, XSIZE-2, y+1);
			doForceCalc(XSIZE-2, y, XSIZE-2-1, y);
			doForceCalc(XSIZE-2, y, XSIZE-2, y-1);
			// next nearest 4
			doForceCalc(XSIZE-2, y, XSIZE-2+1, y-1);
			doForceCalc(XSIZE-2, y, XSIZE-2+1, y+1);
			doForceCalc(XSIZE-2, y, XSIZE-2-1, y-1);
			doForceCalc(XSIZE-2, y, XSIZE-2-1, y+1);

			// nearest 4
			doForceCalc(1, y, 1+1, y);
			doForceCalc(1, y, 1, y+1);
			doForceCalc(1, y, 1-1, y);
			doForceCalc(1, y, 1, y-1);
			// next nearest 4
			doForceCalc(1, y, 1+1, y-1);
			doForceCalc(1, y, 1+1, y+1);
			doForceCalc(1, y, 1-1, y-1);
			doForceCalc(1, y, 1-1, y+1);*/
		
		}
		// now for the corners:
		doForceCalc(XSIZE-1, 0, XSIZE-2, 0);
		doForceCalc(XSIZE-1, 0, XSIZE-2, 1) ;
		doForceCalc(XSIZE-1, 0, XSIZE-1, 1);

		doForceCalc(XSIZE-1, YSIZE-1, XSIZE-2, YSIZE-1);
		doForceCalc(XSIZE-1, YSIZE-1, XSIZE-2, YSIZE-2);
		doForceCalc(XSIZE-1, YSIZE-1, XSIZE-1, YSIZE-2);
}


void fxFlag::calcWindForce() {}

void fxFlag::gravitate() 
{
		for(int x=0; x<XSIZE; x++) {
			for(int y=0; y<YSIZE; y++) {
				velocity[x][y].y -= GRAVITY;
			}
		}
}


void fxFlag::mammaJamma(float t) 
{
	// the flag pole condition: the first column stays put
//		for(int y=0; y<YSIZE; y++) {
//			flag[0][y].z = 0.1*sin(5*t*3.1415926);// + (float)y/YSIZE;
//		}
		for(int x=1; x<XSIZE; x++) {
			for(int y=0; y<YSIZE; y++) {
				flag[x][y].x = oldflag[x][y].x + velocity[x][y].x;
				flag[x][y].y = oldflag[x][y].y + velocity[x][y].y;
				flag[x][y].z = oldflag[x][y].z + velocity[x][y].z;
				// ghetto wind resistance
				velocity[x][y].x *= VISCOSITY;		// FirEdge : modified the wind function...
				
				velocity[x][y].x += GHETTOWIND * (float)( (sin(t-2)*cos(t*1.5+1)*sin(cos(t*t)) ) * 0.5
					                                + (0.4 * sin(3*t+1) ) + 0.3 );

				velocity[x][y].y *= VISCOSITY;
				velocity[x][y].z *= VISCOSITY;
			}
		}
}



fxFlag::fxFlag() 
{
		for(int x=0; x<XSIZE; x++) {
			for(int y=0; y<YSIZE; y++) {
				flag[x][y].x = ((float)x)/((float)XSIZE)*XLEN;
				flag[x][y].y = ((float)y)/((float)YSIZE)*YLEN;
				flag[x][y].z = DELTA*((float)rand() / (float)RAND_MAX - 0.5f);
			}
		}
		memset(velocity, 0, XSIZE*YSIZE*sizeof(vertex));
}
	
	
void fxFlag::Render(float t, const Demo *env) 
{
	glLoadIdentity();
	
	// t isn't used because this isn't time-based
	// the wussy sin-wave crap here:
	/*	for(int x=0; x<XSIZE; x++) {
			for(int y=0; y<YSIZE; y++) {
				flag[x][y].z = 0.1*sin((float)(y)/(float)(YSIZE)*3.14159+(float)(x)/(float)(XSIZE)*3.1415926*2 - 5*t*3.1415926);
			}
		}*/
		memmove(oldflag, flag, XSIZE*YSIZE*sizeof(vertex));
		// the steps:
		// 1) calculate the force due to the springs
	 	calcSpringForce();
		// 2) calculate the force due to wind
		calcWindForce();
		// 3) add in gravity
		gravitate();
		// 4) update speed and position
		mammaJamma(t);
		// 5) and draw it!
		drawFlag(t);
}

	
void fxFlag::drawFlag(float t) 
{

		glLoadIdentity();
		glTranslatef( -0.241f , -0.01f , -0.8f );
		glRotatef( 50.0f * (float) cos(t) , 0, 1.0, 0);
	
		glColor3f(1, 1, 1);
		glBindTexture(GL_TEXTURE_2D, flagTexture);

		for(int x=0; x<XSIZE-1; x++) {
			for(int y=0; y<YSIZE-1; y++) {
		
				glBegin(GL_TRIANGLE_STRIP);
				
				glTexCoord2f((float)(x+1)/(float)XSIZE, (float)y/(float)YSIZE);

				glVertex3fv((float *)&flag[x+1][y]);
				
				glTexCoord2f((float)x/(float)XSIZE, (float)y/(float)YSIZE);
				
				glVertex3fv((float *)&flag[x][y]);
				
				glTexCoord2f((float)(x+1)/(float)XSIZE, (float)(y+1)/(float)YSIZE);
				
				glVertex3fv((float *)&flag[x+1][y+1]);
				
				glTexCoord2f((float)x/(float)XSIZE, (float)(y+1)/(float)YSIZE);
				
				glVertex3fv((float *)&flag[x][y+1]);
				
				glEnd();
			}
		}



}
	
	
fxFlag::~fxFlag() {}

bool fxFlag::Init(const Loader* l)
{
		AUX_RGBImageRec *flagData = auxDIBImageLoad("ethereal.bmp");

		if (flagData == NULL)
			return false;

		glGenTextures(1, (unsigned int *)&flagTexture);					
		glBindTexture(GL_TEXTURE_2D, flagTexture);
		glTexImage2D(GL_TEXTURE_2D, 0, 3, flagData->sizeX, flagData->sizeY, 0, GL_RGB, GL_UNSIGNED_BYTE, flagData->data);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
		free(flagData->data);
		free(flagData);

		return true;
}

void fxFlag::Push(ud type, float value) // This is unused, that's why it generates warnings.
{ // Might be used to modify the wind force ... just a suggest.
}

void fxFlag::DeInit()
{
}