/*------------------------------------------------------*\
|                                                        |
|            Synchronisation-Demo engine                 |
|                                                        |
|     by FirEdge / Ethereal , on 1.02.2001 at 01:02      |
|     modified by pompy / Ethereal on 06.06.2001		 |
|                                                        |
\*------------------------------------------------------*/


#ifndef _ETHEREAL_DEMO_ENGINE_1_
#define _ETHEREAL_DEMO_ENGINE_1_


#include <windows.h>
#include <windowsx.h> //Hodglim
#include <gl/gl.h>
#include <gl/glu.h>
#include <gl/glaux.h>
#include <iostream.h>
#include <fstream.h>
#include <stdio.h>


#include "FX.hpp"
#include "typedefs.h"
#include "startupDlg.hpp" //Hodglim
#include "resource.h"     //Hodglim
#include "music.hpp"
#include "Event.hpp"


extern int g_width;			//Hodglim
extern int g_height;		//Hodglim
extern int g_bpp;			//Hodglim
extern int g_zbuffer;
extern bool g_fullscreen;	//Hodglim


static float t = 0.0f;

#define MAX_EVENTS			1000
#define MAX_SLOTS			8			// <-- number of effects to be displayed simultaneously.

// Clear buffers:

#define COLORBUFFER 1
#define ZBUFFER		2
//#define STENCILBUFFER	4
//#define PBUFFER		8


// Slot 0 contains background effects whereas slot 7 contains the most foreground FX.
// The Slot 0 is reserved for Background pictures. If there is no background 
// picture, the engine will call the Clear method. In all ways, the engine clears the
// ZBuffer.

class CFX;
class FX;
class Event;
class Loader;


#define UNKNOWN 0
#define WIN95 1
#define WIN98 2
#define WINME 3
#define WINNT 4
#define WIN2K 5




/* Demo environement runtime : the heart of the engine */

class Demo 
{

protected:


	// the FX to be showed during loading:
	FX*				loadfx;

	// the current window configuration:
	int				width, height, bpp, zbuffer;
	bool			fullscreen;
	HINSTANCE		hInstance;
	uw				mouse_x;
	uw				mouse_y;
	
	// windows messaging stuff:
	MSG				msg;
	

	// private drawing methods:
	virtual void	Clear(int buffer) = 0;// <-- clear depends on the render method
	virtual void	Flip() = 0;			// <-- flip also depends on render method
	virtual void	SetRenderView( float x0, float y0, float x1, float y1 ) = 0;

	void			RenderFrame();
	bool			InitFX(const Loader &l);
	void			InitEvents();
	void			UpdateSlots( unsigned long msecs );
	int				GetWinVersion();

public:

	Event*			events[MAX_EVENTS];
	CFX*			slots[MAX_SLOTS];

	// the music player
	Player*			music_player;
	Loader*			loader;
	
	bool			done, active, loading;
	float			loadingprogress;

	int				OS;
	int				curr_event;
	unsigned long	basetime;


	Demo();

	void AddFX(FX *fx, unsigned int start, unsigned int end, int slot);
	void AddFX(int ID, unsigned int start, unsigned int end, int slot);
	void LoadFX(FX *f);
	void SetPlayer(Player *p);
	void SetLoader(Loader *l);
	
	// init must initialize the effects as well
	virtual bool Init(char *title, const Loader &l) = 0;  
	
	void DoTheDemo();
	
	~Demo();
};

class OpenGLDemo : public Demo
{

	friend LRESULT CALLBACK OpenGLWndProc(	HWND hWnd,
										    UINT uMsg,
											WPARAM wParam,
											LPARAM lParam	);

private:
	// OpenGL specific parameters:
	HDC				hDC;
	HGLRC			hRC;
	GLuint			PixelFormat;

	// OpenGL windowing methods:
	void			ReSizeGLScene(GLsizei width, GLsizei heigh);
	int 			InitGL();
	void			KillGLWindow(GLvoid);
	bool			CreateGLWindow(char* title,int width,int heigh,int bits,bool fullscreenflag);

	void			Clear(int buffer);
	void			Flip();
	void	SetRenderView( float x0, float y0, float x1, float y1 );

public:

	OpenGLDemo(HINSTANCE hInst);
	
	bool Init(char *title, const Loader &l);

	~OpenGLDemo();

};



#endif