
/*--------------------------------------------------------\
|                                                        *|
|            Synchronisation-Demo engine                 *|
|                                                        *|
|     by FirEdge / Ethereal , on 01.02.2001              *|
|                                                        *|
|         a major update on 23.02.2001                   *|
|         "   "     "     " 07.06.01 by pompy            *|
|                                                        *|
\*********************************************************/



#include "DemoEngine.hpp"


bool	keys[256];  // pompy
bool	active;		// pompy


//we need to ensure these defaults match those set in startDlg_OnInitDialog()
int g_width		  = 800;  //Hodglim
int g_height	  = 600;  //Hodglim
int g_bpp		  = 32;   //Hodglim
int g_zbuffer     = 16;   //FirEdge (#!~!%|#!@_, static variables suck)
bool g_fullscreen = true; //Hodglim

static 	HWND		hWnd;
Demo*		environement;


// DEMO METHODS ////////////////////////////////////////////////////////////////
Demo::Demo() 
{
	int i;
	
	loadfx = NULL;
	music_player = NULL;
	loader			= NULL;
	loadingprogress = -1.0f;
	curr_event	=	0;
	active		=	true;
	done		=	false;
	loading		=	false;
	width		=	g_width;		//Hodglim
	height		=	g_height;		//Hodglim
	bpp			=	g_bpp;			//Hodglim
	fullscreen	=	g_fullscreen;	//Hodglim
	zbuffer		=	g_zbuffer;
	
	environement = this;

	for ( i=0; i<MAX_SLOTS; i++ ) 
		slots[i] = NULL;

	for ( i=0; i<MAX_EVENTS; i++ )
		events[i] = NULL;

	for ( i=0; i<256; i++)
		keys[i] = false;

	InitEvents();

	OS = GetWinVersion();
	basetime = 0;
}


void Demo::RenderFrame() 
{
	unsigned long msecs;

	msecs = music_player->GetTicks() + basetime;

	if ( msecs >= 183000 ) // 3:03 seconds...
		done = true;	   // A bit violent, but the demo actually stops :o)

	UpdateSlots( msecs );

	if ( slots[0] != NULL )
	{
		Clear( ZBUFFER );
		slots[0]->DoFX( msecs, this );
	}
	else
	{
		Clear( COLORBUFFER | ZBUFFER ); // There is no background picture on the screen, we shall clear.
	}

	for (int i=1; i<MAX_SLOTS; i++) 
	{
		if ( slots[i] != NULL )	
		{
			slots[i]->DoFX(msecs, this); 											   
		}
	}

}


void Demo::DoTheDemo() 
{

	while ( PeekMessage(&msg,NULL,0,0,PM_REMOVE) )	// More of one message could have
													// arrrived while a frame is rendered.
	{
		if ( msg.message==WM_QUIT )	
		{
			done = true;
			PostQuitMessage(0);
			return;
		} else {
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	} 

	if (keys[VK_ESCAPE]) 
	{
		done = true;
	} 
	else 
	{	
		if (active)
		{
			RenderFrame();
			Flip();
		}
	}
}


bool Demo::InitFX(const Loader &l) 
{

/*	for ( int i=0; i<curr_effect; i++ ) 
	{
		if( !effects[slots[i]]->Init(l) ) return false;
	} */

	return music_player->Play();
}


Demo::~Demo() 
{
	// we have lots of stuff to delete:
	if( music_player ) delete music_player;
	if( loadfx ) delete loadfx;
	
	for( int i=0; i<MAX_SLOTS; i++ ) 
	{
		if (slots[i] != NULL)
			delete slots[i];
	}
}



void Demo::AddFX(FX *fx, unsigned int start, unsigned int end, int slot) 
{
	if ( slots[slot] != NULL )
	{
		delete slots[slot];
	}

	slots[slot] = new CFX(fx, start, end);
	slots[slot]->Init( loader );
}


void Demo::LoadFX(FX *f) 
{
	loadfx = f;
}


void Demo::SetPlayer(Player *p) 
{
	music_player = p;
}


void Demo::SetLoader(Loader* l)
{
	loader = l;
}


void Demo::UpdateSlots( unsigned long msecs )
{
	unsigned long curr_time;

	if (events[curr_event] == NULL)
		return;

	curr_time = events[curr_event]->time;
	
	while ( ( events[curr_event] != NULL) && ( msecs >= curr_time ) )
	{
		events[curr_event]->Execute();
		curr_time = events[curr_event]->time;
		curr_event++;
	}

}


int Demo::GetWinVersion()
{
	OSVERSIONINFO nfo;

	memset( &nfo, 0, sizeof( OSVERSIONINFO ) );
	
	nfo.dwOSVersionInfoSize = sizeof( OSVERSIONINFO );

	GetVersionEx( (LPOSVERSIONINFO) &nfo );

	if     ( ( nfo.dwPlatformId == VER_PLATFORM_WIN32_WINDOWS ) && 
	       ( ( nfo.dwMajorVersion == 4 ) && ( nfo.dwMinorVersion == 10 ) ) )
	   return WIN98; // Windows 98

	if     ( ( nfo.dwPlatformId == VER_PLATFORM_WIN32_NT ) && 
	       ( ( nfo.dwMajorVersion == 4 ) && ( nfo.dwMinorVersion == 0 ) ) ) 
	   return WINNT; // Windows NT 4

	if     ( ( nfo.dwPlatformId == VER_PLATFORM_WIN32_NT ) && 
	       ( ( nfo.dwMajorVersion == 5 ) && ( nfo.dwMinorVersion == 0 ) ) ) 
	   return WIN2K; // Windows 2000

	if     ( ( nfo.dwPlatformId == VER_PLATFORM_WIN32_WINDOWS ) && 
	       ( ( nfo.dwMajorVersion == 4 ) && ( nfo.dwMinorVersion == 0 ) ) ) 
	   return WIN95; // Windows 95

	if     ( ( nfo.dwPlatformId == VER_PLATFORM_WIN32_WINDOWS ) && 
	       ( ( nfo.dwMajorVersion == 4 ) && ( nfo.dwMinorVersion == 90 ) ) ) 
	   return WINME; // Windows Millenium Edition

	if ( nfo.dwMajorVersion < 4 )
	{
		MessageBox( 0, "Your operating system is too old to run this demonstration. Sorry.", "Error", 0 );
		done = true; // Stop the demo.
	}
	
	return UNKNOWN;
}



// OPENGLDEMO METHODS /////////////////////////////////////////////////////////
bool OpenGLDemo::Init(char *title, const Loader &l)
{
	// Initialize OpenGL according to selection

	if ( !CreateGLWindow(title,width,height,bpp,fullscreen) ) {
		MessageBox(NULL,"Can't set desired video mode","Error",MB_OK|MB_ICONEXCLAMATION);
		done = true;
		return false;
	}

	SetWindowLong(hWnd, GWL_USERDATA, (LONG)this);	

	return InitFX(l);
	
}


void OpenGLDemo::SetRenderView( float x0, float y0, float x1, float y1 )
{
	glViewport( (int) x0 * width, (int) y0 * height,
				(int) (x1 - x0) * width, (int) (y1-y0) * height );
}


GLvoid OpenGLDemo::ReSizeGLScene(GLsizei width, GLsizei heigh)
{
	if (heigh == 0)
		heigh=1;

	glViewport(0,0,width,heigh);
	
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();

	gluPerspective(45.0f , (GLfloat) width / (GLfloat) heigh , 0.1f,10000.0f);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
}


int OpenGLDemo::InitGL()
{
	glShadeModel(GL_SMOOTH);
	glClearColor(0.0f,0.0f,0.0f,0.0f);

	glClearDepth(10000.0f);
	glEnable(GL_DEPTH_TEST);
	glDepthFunc(GL_LEQUAL);

//	glHint(GL_PERSPECTIVE_CORRECTION_HINT , GL_NICEST);
	glHint(GL_PERSPECTIVE_CORRECTION_HINT , GL_FASTEST);

	glEnable(GL_TEXTURE_2D);

	return true;
}


GLvoid OpenGLDemo::KillGLWindow(GLvoid)
{
	if (fullscreen)
	{
		ChangeDisplaySettings(NULL , 0);
		ShowCursor(true);
	}

	if (hRC)
	{
		if (!wglMakeCurrent(NULL,NULL))
			MessageBox(NULL, "Release of device context and rendering context failed.","Exit Error",MB_OK);

		if (!wglDeleteContext(hRC))
			MessageBox(NULL, "Release rendering context failed","Exit Error",MB_OK);
		hRC=NULL;
	}

	if ( hDC && !ReleaseDC(hWnd,hDC) )
	{
		MessageBox(NULL,"Release Device Context Failed","Exit Error",MB_OK);
		hDC=NULL;
	}

	if (!UnregisterClass("etherealdemoengine",hInstance))
	{
//		MessageBox(NULL,"Could not unregister class","Exit Error",MB_OK|MB_ICONEXCLAMATION);
		hInstance=NULL;
	}

	//Unregister hotkeys
	UnregisterHotKey(hWnd, 0x01);
}


// Procedure that creates a fullscreen OpenGL Window:

bool OpenGLDemo::CreateGLWindow(char* title,int width,int heigh,int bits,bool fullscreenflag)
{
	WNDCLASS wc;

	DWORD	dwExStyle;
	DWORD   dwStyle;

	RECT WindowRect;
	WindowRect.left = (long)0;
	WindowRect.right = (long) width;
	WindowRect.top = (long) 0;
	WindowRect.bottom = (long) heigh;

	fullscreen=fullscreenflag;

	hInstance		= GetModuleHandle(NULL);
	wc.style		= CS_HREDRAW | CS_VREDRAW | CS_OWNDC;
	wc.lpfnWndProc	= (WNDPROC) OpenGLWndProc;
	wc.cbClsExtra	= 0;
	wc.cbWndExtra	= 0;
	wc.hInstance	= hInstance;
	wc.hIcon		= LoadIcon(NULL,IDI_WINLOGO);
	wc.hCursor		= LoadCursor(NULL,IDC_ARROW);
	wc.hbrBackground= NULL;
	wc.lpszMenuName = NULL;
	wc.lpszClassName= "etherealdemoengine";

	if (!RegisterClass(&wc))
	{
		MessageBox(NULL,"Failed To Register The Window Class.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return false;
	}
	
	if (fullscreen)
	{
	
		DEVMODE dmScreenSettings;
		memset(&dmScreenSettings , 0 , sizeof(dmScreenSettings));
		dmScreenSettings.dmSize		  = sizeof(dmScreenSettings);
		dmScreenSettings.dmPelsWidth  = width;
		dmScreenSettings.dmPelsHeight = heigh;
		dmScreenSettings.dmBitsPerPel = bits;
		dmScreenSettings.dmFields	  = DM_BITSPERPEL|DM_PELSWIDTH|DM_PELSHEIGHT;

		if (ChangeDisplaySettings(&dmScreenSettings,CDS_FULLSCREEN)!=DISP_CHANGE_SUCCESSFUL)
		{
			MessageBox(NULL,"The requested video mode is not supported by your hardware.","Error",MB_OK);
			UnregisterClass("OpenGL", hInstance);
			return false;
		}

	}

	if (fullscreen)
	{
		
		dwExStyle = WS_EX_APPWINDOW;
		dwStyle = WS_POPUP;
		ShowCursor(false);

	} else {

		dwExStyle = WS_EX_APPWINDOW | WS_EX_WINDOWEDGE;
		dwStyle = WS_OVERLAPPEDWINDOW;

	}

	AdjustWindowRectEx(&WindowRect, dwStyle, false, dwExStyle);

	if ( !(hWnd=CreateWindowEx(dwExStyle,
							   "etherealdemoengine",
							   title,
							   WS_CLIPSIBLINGS | WS_CLIPCHILDREN | dwStyle,
							   0, 0,
							   WindowRect.right-WindowRect.left,
							   WindowRect.bottom-WindowRect.top,
							   NULL,
							   NULL,
							   hInstance,
							   NULL)) )
	{
		KillGLWindow();
		MessageBox(NULL,"Window Creation Error","Error",MB_OK|MB_ICONEXCLAMATION);
		return false;
	}



	static PIXELFORMATDESCRIPTOR pfd=
	{
		sizeof(PIXELFORMATDESCRIPTOR),
		1,
		PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL | PFD_DOUBLEBUFFER,
		PFD_TYPE_RGBA,
		(unsigned char) bits,
		0,0,0,0,0,0,0,0,0,0,0,0,
		zbuffer,
		0,0,
		PFD_MAIN_PLANE,
		0,0,0,0 
	};

	if ( !(hDC=GetDC(hWnd)) )
	{
		KillGLWindow();
		MessageBox(NULL,"Can't create an OpenGL device context","Error",MB_OK|MB_ICONEXCLAMATION);
		return false;
	}

	if ( ! (PixelFormat=ChoosePixelFormat(hDC,&pfd)) )
	{
		KillGLWindow();
		MessageBox(NULL,"Can't find a suitable pixel format","Error",MB_OK|MB_ICONEXCLAMATION);
		return false;
	}

	if ( ! SetPixelFormat(hDC , PixelFormat , &pfd) )
	{
		KillGLWindow();
		MessageBox(NULL,"Can't find a suitable pixel format","Error",MB_OK|MB_ICONEXCLAMATION);
		return false;
	}


	if ( ! (hRC=wglCreateContext(hDC)) )
	{
		KillGLWindow();
		MessageBox(NULL,"Can't create OpenGL rendering context","Error",MB_OK|MB_ICONEXCLAMATION);
		return false;
	}



	if ( !wglMakeCurrent(hDC,hRC) )
	{
		KillGLWindow();
		MessageBox(NULL,"Can't setup rendering context","Error",MB_OK|MB_ICONEXCLAMATION);
		return false;
	}

	ShowWindow(hWnd,SW_SHOW);	// Crashes under windows 2000 (???) ...

	SetForegroundWindow(hWnd);
	SetFocus(hWnd);

	
	ReSizeGLScene(width,heigh);


	if ( !InitGL() )
	{
		KillGLWindow();
		MessageBox(NULL,"Initialisation Failed","Error",MB_OK|MB_ICONEXCLAMATION);
		return false;
	}

	//Disable ALT-TABBING by registering it as a hotkey
	RegisterHotKey(hWnd, 0x01, MOD_ALT, VK_TAB);
	
	return true;
}


// Message handling procedure for OpenGL demos:
LRESULT CALLBACK OpenGLWndProc(HWND hWnd,
						 UINT uMsg,
						 WPARAM wParam,
						 LPARAM lParam)
{
	
	OpenGLDemo* env = (OpenGLDemo *) GetWindowLong(hWnd, GWL_USERDATA);
	
	switch(uMsg)
	{
		// a key is pressed by the user.

		case WM_KEYDOWN:
		{
			keys[wParam] = true;

			if (wParam == VK_ESCAPE)
			{
				environement->done = true;
			}

			return 0;
		}

		// a key is released by the user.
		
		case WM_KEYUP:
		{
			keys[wParam] = false;
			return 0;
		}

		// The user is resizing the window.
		
		case WM_SIZE:
		{
			env->ReSizeGLScene(LOWORD(lParam),HIWORD(lParam));
			return 0;
		}

		case WM_ACTIVATE:
		{
			if ( !HIWORD(wParam) )
			{
				active = true;
			} else {
				active = false;
			}
			return 0;
		}

		// prevents the screensaver to launch or the monitor to 
		// enter in power saving mode.

		case WM_SYSCOMMAND:
		{
			switch (wParam)
			{
			case SC_SCREENSAVE:		// prevent the screensaver from starting
			case SC_MONITORPOWER:	// prevent the monitor to enter power saving mode.
				return 0;
			}
			break;
		}

		// in case the window is closed by the user.
		
		case WM_CLOSE:
		{
			environement->done = true;
//			PostQuitMessage(0);
			return 0;
		}


	} // switch

	return DefWindowProc(hWnd,uMsg,wParam,lParam);

} // procedure


OpenGLDemo::OpenGLDemo(HINSTANCE hInst) 
{
	hInstance	=	hInst;
	hDC			=	NULL;
	hRC			=	NULL;
	hWnd		=	NULL;
}


OpenGLDemo::~OpenGLDemo() 
{
	KillGLWindow();
}


void	OpenGLDemo::Clear(int buffer)
{
	if (( buffer & COLORBUFFER ) != 0 )
		glClear( GL_COLOR_BUFFER_BIT );

	if (( buffer & ZBUFFER ) != 0 )
		glClear( GL_DEPTH_BUFFER_BIT );
}
	

void	OpenGLDemo::Flip()
{
	glFlush();
	SwapBuffers( hDC );
}

