PROGRAM floor1;
{
  Floor of Doom, first life
  - by Bjarke Vikse
  aug 1994

  Well, it does look nice. But let's face it, it's not Doom.
  One could make a really nice game with this (Jazz JackRabbit ;) or
  what about a rally game...
  It uses a sort of ray-casting scheme everybody else seems to cherish
  so much!

  Tilegraphics is 'coded'. Ofcourse I should have taken the time to draw
  some really nice ones and used them, but I don't bother.
  You should replace the 'CreateTiles' with a LoadPix() to load a .lbm pix
  instead. By using all 256 colours cleverly you can even make triangles
  or round tiles!

  Tiles are 32x32 pixels placed in a 256x256 buffer. 8x8=64 different tiles
  in all. Map is 256x256 and consist of indexes to tiles ranging [0..63].
}

{$A+,B-,G+,E+,I+,N-,X+}
{$IFDEF DPMI}
{$C FIXED PRELOAD PERMANENT}
{$ENDIF}

USES
	DEMOINIT,MOUSE;

{{$DEFINE DEBUG}

CONST
	LINES = 70; {how many lines shall we paint}
	TILT = 2; {tilt floor how much?}

TYPE
	pBunk = ^BunkArray;
	BunkArray = ARRAY[0..254, 0..255] of byte;
	pArray = ^ArrayType;
	ArrayType = ARRAY[0..32760] of integer;
	LineArray = Array[0..LINES*4] of integer;

VAR
	map, tiles : pBunk;
	linetable : ^LineArray;
	xpos,ypos : integer;


(*------------------------------------------------*)

procedure SetColors;
{Setup ugly, more or less randomly picked, colours}
var
	i : integer;
begin
	for i:=0 to 7 do setRGB(i, i,i,i);
	for i:=8 to 15 do setRGB(i, (i-5)*2,0,0);
	for i:=16 to 23 do setRGB(i, 0,(i-10)*2,(i-8)*2);
	for i:=24 to 31 do setRGB(i, 0,0,42);
	for i:=32 to 39 do setRGB(i, 0,(i-15)*2,0);
	for i:=40 to 47 do setRGB(i, i,i,i);
	for i:=48 to 55 do setRGB(i, i,0,0);
end;


procedure CreateMap;
{Create map.
 Characters in string are indexes to tiles! 'a' is tile #0,
 'b' is #1 and so...}

 procedure Strip(ypos,xpos : integer; st : string);
 var
	j : integer;
 begin
		for j:=1 to length(st) do st[j]:=char(ord(st[j])-ord('a'));
		Move(st[1],map^[ypos,xpos],length(st));
 end;

var
	i : integer;
begin
	GetMem(map,65535);
	FillChar(map^,65535,#0);

	i:=20;
	while i<60 do begin
		Strip(i,30,'fgfgfgfgfgfgfgfgfgfg');
		Strip(i+1,30,'gfgfgfgfgfgfgfgfgfgf');
		if (i>35) AND (i<45) then begin Strip(i,39,'aaaaa'); Strip(i+1,39,'aaaaa'); end;
		inc(i,2);
	end;

	Strip(20,70,'bcbcbcbcbcbcbcbcbcbcbcbcbcbcbcbcbcbcbcbcbcbc');
	Strip(21,70,'cbcbcbcbcbcbcbcbcbcbcbcbcbcbcbcbcbcbcbcbcbcb');
	i:=22;
	while (i<42) do begin
		Strip(i,70,'bcaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaabc');
		Strip(i+1,70,'cbaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaacb');
		Strip(i,60,'dedede');
		Strip(i+1,60,'ededed');
		inc(i,2)
	end;
	Strip(42,70,'bcbcbcbcbcbcbcbcbcbcbcbcbcbcbcbcbcbcbcbcbcbc');
	Strip(43,70,'cbcbcbcbcbcbcbcbcbcbcbcbcbcbcbcbcbcbcbcbcbcb');
end;

procedure CreateTiles;
{Create some ugly tiles. We simple choose some colours and paint
 a brick with them}
var
	i,j : integer;
begin
	GetMem(tiles,65535);
	FillChar(tiles^,65535,#0);

	for i:=0 to 254 do {254, not 255, to get it running under DPMI!}
		for j:=0 to 255 do
			tiles^[i,j]:=((j DIV 32)*8) + random(8); {make dithered tile}
end;


procedure PrecalcLines;
const
	XPOS = 20;
var
	i,
	x1,y1,x2,y2 : integer;
	z : integer;
	pos : word;
begin
	New(LineTable);
	FillChar(LineTable^,SizeOf(LineArray),#0);

	z:=8000;
	pos:=0;
	for i:=1 to LINES do begin
		x1:=(-XPOS * 65536) DIV z;
		y1:=(i*TILT*65535) DIV z;
		linetable^[pos]:=x1;
		linetable^[pos+1]:=y1;

		x2:=(XPOS * 65535) DIV z;
		linetable^[pos+2]:=(longint(x2-x1) SHL 11) DIV 160;
		linetable^[pos+3]:=0;
		inc(pos,4);

		inc(z,310);
	end;
end;


procedure InitDemo;
var
	i : integer;
begin
	ClearWholeScreen;
	SetColors;

	CreateMap;
	CreateTiles;
	PrecalcLines;

	xpos:=1200; ypos:=800;
end;

procedure UninitDemo;
var
	i : integer;
begin
	FreeMem(map,65535);
	FreeMem(tiles,65535);
	Dispose(LineTable);
end;



(*------------------------------------------------*)

procedure DrawFloor(x,y : integer); assembler;
var
	mappos,tablepos : word;
	xadd : integer;
	height, counts : word;
asm
	push	ds
	mov	es,SEGA000
	mov	di,100*320
	mov	ax,WORD PTR [map+2]
	{mov fs,ax} DB $8E,$E0
	mov	ax,WORD PTR [linetable+2]
	{mov gs,ax} DB $8E,$E8
	mov	ax,WORD PTR [linetable]
	mov	[tablepos],ax
	mov	ds,WORD PTR [tiles+2]

	cld
	mov	[height],LINES
@y_run:

	mov	si,[tablepos]

	DB GS; mov	ax,[si+4]
	mov	[xadd],ax

	DB GS; mov	dx,[si]
	DB GS; mov	cx,[si+2]
	add	dx,[x]
	add	cx,[y]

	mov	bx,dx					{Find first tile}
	mov	ax,cx
	shr	ax,5
	shr	bx,5
	mov	bh,al
	mov	[mappos],bx
	DB FS; mov al,[bx]		{get tile-index from map}
	mov	ah,al					{find map position in map-buffer}
	and	al,7
	shr	ah,3
	shl	ax,5
	mov	si,ax

	shl	dx,11
	shl	cx,11
	xor	dx,$8000
	xor	cx,$8000

	mov	[counts],160
@x_run:
	mov	bh,dh		{get x-position of pixel}
	mov	bl,ch		{get y-position of pixel}
	shr	bx,3
	and	bx,$1F1F
	mov	al,[si+bx]	{get that pixel}
	mov	ah,al
	stosw					{store it... well, we draw it twice to gain speed!}

	add	dx,[xadd]
	jno	@noxadd
	inc	[mappos]
	mov	bx,[mappos]
	DB FS; mov al,[bx]		{get new tile-index from map}
	mov	ah,al					{find tile position in tile-buffer}
	and	al,7
	shr	ah,3
	shl	ax,5
	mov	si,ax
@noxadd:

	dec	[counts]
	jnz	@x_run

	add	[tablepos],8
	dec	[height]
	jnz	@y_run

	pop	ds
end;

(*------------------------------------------------*)

procedure RunOnce;
var
	x,y : integer;
begin
	VBLANK;
{$IFDEF DEBUG}	SetRGB(0,20,0,0); {$ENDIF}

	ReadMouseMotionCounters(x,y);
	inc(xpos,x);
	inc(ypos,y);
	if (xpos<200) then xpos:=200;
	if (xpos>16384) then xpos:=16384;
	if (ypos<200) then ypos:=200;
	if (ypos>16384) then ypos:=16384;

	DrawFloor(xpos,ypos);

{$IFDEF DEBUG}	SetRGB(0,0,0,0); {$ENDIF}
end;

begin
	if NOT MouseDriverPresent then begin writeln('No mouse...'); halt; end;
	InitMouse;

	SetScreenMode($13);
	InitDemo;
	repeat RunOnce until KeyPressed;
	UninitDemo;
	SetScreenMode(demoinit.TEXTMODE);
end.
