//      objects.cpp

#include <conio.h>
#include <math.h>
#include "mode13.h"
#include "obj3d.h"
#include "triangle.h"
#include "phongpal.h"
#include "lightsrc.h"
#include "vectors.h"
#include "cuadro.h"
#include "stuff.h"
#include "objects.h"

#include "cokebkgr.h"
#include "banner5.h"
#include "tex4.h"
#include "env5.h"
#include "banner9.h"

#include "mikaro.h"
#include "engrane.h"
#include "neuras.h"
#include "spherei.h"


double o_ZoomTable[256];
double n_ZoomTable[256];
int o_rottable[256][3];

void OBJECTS_Setup() {
        double ang;
        for (int i = 0; i < 128; i++) {
                o_ZoomTable[i] = 200 * sin(i * Pi / 64.0);
                o_ZoomTable[i + 128] = 400 * sin(i * Pi / 64.0);
        }
        for (i = 0; i < 256; i++) {
                ang = i * Pi / 128.0;
                o_rottable[i][0] = sin(ang) * 3.0 + 1.0;
                o_rottable[i][1] = cos(ang) * 3.0 + 2.0;
                o_rottable[i][2] = -cos(ang / 2.0) * 3.0 - 2.0;
        }
        for (i = 0; i < 64; i++)
                n_ZoomTable[i] = 100 * sin(i * Pi / 64.0);
        for (i = 0; i < 192; i++)
                n_ZoomTable[i + 64] = 600 * sin(i * Pi / 192.0);
}


void OBJECTS_RunFirst() {
        TObject3D *o_obj = new TObject3D();
        TObject3D *o_obj2 = new TObject3D();
        TObject3D *back = new TObject3D();
        PTVirtual vscr;
        unsigned int voff;
        int count;
        char a = 0;
        TPalette pal;
        double ambient, x, y, z;
        int rotx, roty, rotz;

        SetupVirtual(&vscr, &voff);
        ClearScreen(0, voff);
        GeneraCuadro(2, 240, back);
        back->SetCenter(160, 100);
        back->Scale(3.2, 2.0, 1.0);
        TextureOffset = (unsigned int)COKEBKGR;

        Read3DObject(MIKARO_VKX, o_obj);
        o_obj->SetCenter(160, 100);
        o_obj->Scale(1.2, 1.2, 1.2);
        Read3DObject(ENGRANE_VKX, o_obj2);
        o_obj2->Rotate(90, 0, 0);
        o_obj2->SetCenter(160, 100);
        o_obj2->Scale(1.5, 1.5, 1.5);

        StartCol = 240;
        WidthCol = 64;
        SetLightPosition(-1, 0, 0);
        x = 320; y = -80; z = 0;
        GetMusicInfo();
        ambient = 256.0;
        rotx = 2; roty = 3; rotz = -3;
        while (position < 7) {
                ClearScreen(0, voff);
                Fast256PhongPal(ambient, 192.0, 256.0, ambient, 0.0, 256.0,
                                ambient, 0.0, 256.0, pal);
                if (ambient > 0.0) ambient -= 8.0;
                if (StartCol > 32) StartCol -= 16;

                GlobalStyle = c_texturemapped;
                back->Traslate(0, 0, o_ZoomTable[a]);
                back->Draw(voff);
                back->Traslate(0, 0, -o_ZoomTable[a++]);

                if (rowflag && ((row & 7) == 0)) {
                        roty = -roty;
                        rotz = -rotz;
                        ambient = 64.0;
                        StartCol = 240;
                }
                if ((row & 7) > 3) o_obj->Rotate(rotx, roty, rotz);
                x -= 5;
                y = -80 + SinT[count % 180] * 160;
                z = SinT[(count++) % 180] * 200;
                o_obj->Traslate(x, y, z);
                StartCol /= 4;
                GlobalStyle = ca_wireframe;
                o_obj->Draw(voff);
                StartCol *= 4;
                GlobalStyle = c_particles;
                o_obj->DrawParticles(voff);
                o_obj->Traslate(-x, -y, -z);

                Blur(voff);
                if (row >= 48)
                        DrawBanner((unsigned int)BANNER5, 202, 110, 61, 15, voff);
                VRetrace();
                SetPalette(pal);
                CopyScreen(voff, VGA);
                Light.Rotate(0, -4, 0);
                GetMusicInfo();
                if (kbhit()) if (getch() == 27) { lastresult = NOT_OK; return; }
        }

        StartCol = 240;
        WidthCol = 64;
        SetLightPosition(-1, 0, 0);
        x = -320; y = -100; z = 0;
        GetMusicInfo();
        ambient = 256.0;
        rotx = 3; roty = -2; rotz = -3;
        count = 0;
        while (position < 8) {
                ClearScreen(0, voff);
                Fast256PhongPal(ambient, 192.0, 256.0, ambient, 48.0, 256.0,
                                ambient, 0.0, 256.0, pal);
                if (ambient > 0.0) ambient -= 8.0;
                if (StartCol > 32) StartCol -= 16;

                GlobalStyle = c_texturemapped;
                back->Traslate(0, 0, o_ZoomTable[a]);
                back->Draw(voff);
                back->Traslate(0, 0, -o_ZoomTable[a++]);

                if (rowflag && ((row & 7) == 0)) {
                        roty = -roty;
                        rotz = -rotz;
                        ambient = 64.0;
                        StartCol = 240;
                }
                if (rowflag && (row >= 48) && ((row & 1) == 0)) ambient = row * 4.0;
                if ((row & 7) > 3) o_obj2->Rotate(rotx, roty, rotz);
                x += 5;
                y = -80 + SinT[count % 180] * 200;
                z = SinT[(count++) % 180] * 200;
                o_obj2->Traslate(x, y, z);
                StartCol /= 4;
                GlobalStyle = ca_wireframe;
                o_obj2->Draw(voff);
                StartCol *= 4;
                GlobalStyle = c_particles;
                o_obj2->DrawParticles(voff);
                o_obj2->Traslate(-x, -y, -z);

                Blur(voff);
                if (row < 24)
                        DrawBanner((unsigned int)BANNER5, 202, 110, 61, 15, voff);
                VRetrace();
                SetPalette(pal);
                CopyScreen(voff, VGA);
                Light.Rotate(0, -4, 0);
                GetMusicInfo();
                if (kbhit()) if (getch() == 27) { lastresult = NOT_OK; return; }
        }

        ShutDownVirtual(&vscr);
        delete back;
        delete o_obj;
        delete o_obj2;
}


void o_DrawBanner(unsigned int banner, unsigned int where);
#pragma aux o_DrawBanner =      \
"mov edx, 200"  \
"loopy: mov ecx, 136"   \
"loopx: mov al, [esi]"  \
"       inc esi"        \
"       or al, al"      \
"       jz skip"        \
"       mov [edi], al"  \
"skip:  inc edi"        \
"       dec ecx"        \
"       jnz loopx"      \
"       add edi, 184"   \
"       dec edx"        \
"       jnz loopy"      \
parm [esi] [edi]        \
modify [eax ecx edx];


void OBJECTS_RunSecond() {
        TObject3D *sphere = new TObject3D();
        TObject3D *obj = new TObject3D();
        PTVirtual vscr;
        unsigned int voff;
        TPalette temp, pal;

        voff = (unsigned int)temp;
        _asm {
                mov edi, [voff]
                mov ecx, 192
                mov eax, 03F3F3F3Fh
                rep stosd
        }

        SetupVirtual(&vscr, &voff);
        ClearScreen(0, voff);
        Read3DObject(SPHEREI_VKX, sphere);
        sphere->Scale(3.6, 3.6, 3.6);
        sphere->SetCenter(160, 100);
        Read3DObject(NEURAS_VKX, obj);
        obj->Scale(1.0, 1.0, 1.0);
        obj->SetCenter(220, 100);
        obj->MapEnviroment();

        GlobalStyle = c_texturemapped;
        CopyPalette(TEX4_PAL, pal, 0, 63);
        CopyPalette(BANNER9_PAL, pal, 64, 127);
        CopyPalette(ENV5_PAL, pal, 128, 255);
        
        unsigned char c = 0;

        GetMusicInfo();

        while (position < 19) {
                TextureOffset = (unsigned int)TEX4;
                sphere->Draw(voff);
                obj->Traslate(0, 0, n_ZoomTable[c]);
                obj->MapEnviroment();
                TextureOffset = (unsigned int)ENV5;
                obj->Draw(voff);
                obj->Traslate(0, 0, -n_ZoomTable[c]);
                obj->Rotate(o_rottable[c][0], o_rottable[c][1], o_rottable[c][2]);
                sphere->Rotate(-o_rottable[c][0], 0, -o_rottable[c][2]);
                c += 2;
                if (row >= 40)
                        o_DrawBanner((unsigned int)BANNER9, voff);
                VRetrace();
                SetPalette(temp);
                CopyScreen(voff, VGA);
                GetMusicInfo();
                if (kbhit()) if (getch() == 27) { lastresult = NOT_OK; return; }
                FadePaletteTo(temp, pal, 0, 255);
        }

        VRetrace();
        SetPalette(pal);
        while (row < 60) {
                TextureOffset = (unsigned int)TEX4;
                sphere->Draw(voff);
                obj->MapEnviroment();
                obj->Traslate(0, 0, n_ZoomTable[c]);
                TextureOffset = (unsigned int)ENV5;
                obj->Draw(voff);
                obj->Traslate(0, 0, -n_ZoomTable[c]);
                obj->Rotate(o_rottable[c][2], o_rottable[c][1], o_rottable[c][0]);
                sphere->Rotate(-o_rottable[c][2], 0, -o_rottable[c][1]);
                c += 2;
                if (row < 56)
                        o_DrawBanner((unsigned int)BANNER9, voff);
                VRetrace();
                CopyScreen(voff, VGA);
                GetMusicInfo();
                if (kbhit()) if (getch() == 27) { lastresult = NOT_OK; return; }
        }

        delete obj;
        delete sphere;
        ShutDownVirtual(&vscr);
}

