//      flying.cpp

#include <conio.h>
#include <math.h>
#include "mode13.h"
#include "obj3d.h"
#include "triangle.h"
#include "phongpal.h"
#include "vectors.h"
#include "stuff.h"
#include "flying.h"

#include "torus.h"
#include "mono.h"

#include "tex2.h"
#include "paper.h"
#include "banner8.h"


double f_transtable[256][3], f_invtranstable[256][3];
int f_angletable[256];
unsigned char f_tindex;


void FLYING_Setup() {
	double ang;
	for (int i = 0; i < 256; i++) {
		ang = i * 3.14159265 / 128.0;
                f_transtable[i][0] = 1 + cos(ang) * 0.2;
                f_transtable[i][1] = 1 + sin(ang) * 0.2;
                f_transtable[i][2] = 1 - cos(ang * 2) * 0.4;
                f_invtranstable[i][0] = 1.0 / f_transtable[i][0];
                f_invtranstable[i][1] = 1.0 / f_transtable[i][1];
                f_invtranstable[i][2] = 1.0 / f_transtable[i][2];
                f_angletable[i] = 20.0 * sin(ang * 2);
	}
}


void f_Transform(TObject3D *o) {
        unsigned char t = f_tindex;
	for (int i = 0; i < o->NumVertex; i++) {
                o->Vertex[i]->x *= f_transtable[t][0];
                o->Vertex[i]->y *= f_transtable[t][1];
		t -= 2;
	}
}


void f_UnTransform(TObject3D *o) {
        unsigned char t = f_tindex;
	for (int i = 0; i < o->NumVertex; i++) {
                o->Vertex[i]->x *= f_invtranstable[t][0];
                o->Vertex[i]->y *= f_invtranstable[t][1];
		t -= 2;
	}
}


void FLYING_Run() {
		TObject3D *obj = new TObject3D();
		TObject3D *tun = new TObject3D();
		PTVirtual vscr;
                unsigned int voff;
                TPalette pal;


	SetupVirtual(&vscr, &voff);
        Read3DObject(MONO_VKX, obj);
        obj->Rotate(0, 0, 180);
        obj->Scale(0.8, 0.8, 0.8);
        obj->SetCenter(160, 50);
        obj->Traslate(0, 0, 100);
        for (int i = 0; i < obj->NumVertex; i++) obj->Vertex[i]->FakeNormal();
        obj->MapEnviroment();
        obj->Traslate(0, -200, -100);
        obj->Rotate(-45, 0, 0);
        Read3DObject(TUNNEL_VKX, tun);
        tun->Rotate(0, 90, 0);
        tun->Scale(7.2, 7.2, 7.2);
        tun->SetCenter(160, 350);

        StartCol = 64;
        WidthCol = 31;
        double ambient = 256.0;
        unsigned char a = 0;

        GetMusicInfo();
        while (position < 24) {
                Fast256PhongPal(ambient, 0.0, 256.0, ambient, 128.0, 256.0,
                                ambient, 128.0, 256.0, pal);
                if (rowflag && ((row & 15) == 8)) ambient = 64.0;
                ClearScreen(0, voff);
                f_Transform(obj);
                GlobalStyle = c_texturemapped;
                TextureOffset = (unsigned int)TEX2;
                tun->Draw(voff);
                GlobalStyle = ca_texturemapped2;
                obj->Rotate(0, 0, f_angletable[f_tindex]);
                TextureOffset = (unsigned int)PAPER;
        	obj->Draw(voff);
                GlobalStyle = c_particles;
                obj->DrawParticles(voff);
                obj->Rotate(0, 0, -f_angletable[f_tindex]);
                Blur(voff);
        	VRetrace();
                SetPalette(pal);
        	CopyScreen(voff, VGA);
                f_UnTransform(obj);
                f_tindex += 2;
                tun->Rotate(2, 0, 0);
                GetMusicInfo();
                if (kbhit()) if (getch() == 27) { lastresult = NOT_OK; return; }
                if (ambient > 0.0) ambient -= 16.0;
        }

        ambient = 256.0;
        while (position < 25) {
                Fast256PhongPal(ambient, 0.0, 256.0, ambient, 128.0, 256.0,
                                ambient, 128.0, 256.0, pal);
                if (rowflag && ((row & 15) == 8)) ambient = 64.0;
                ClearScreen(0, voff);
                f_Transform(obj);
                GlobalStyle = c_texturemapped;
                TextureOffset = (unsigned int)TEX2;
                tun->Draw(voff);
                GlobalStyle = ca_texturemapped2;
                obj->Rotate(0, 0, f_angletable[f_tindex]);
                TextureOffset = (unsigned int)PAPER;
        	obj->Draw(voff);
                GlobalStyle = c_particles;
                obj->DrawParticles(voff);
                obj->Rotate(0, 0, -f_angletable[f_tindex]);
                Blur(voff);
                DrawBanner((unsigned int)BANNER8, 320, 30, 0, 0, voff);
        	VRetrace();
                SetPalette(pal);
        	CopyScreen(voff, VGA);
                f_UnTransform(obj);
                f_tindex += 2;
                tun->Rotate(2, 0, 0);
                GetMusicInfo();
                if (kbhit()) if (getch() == 27) { lastresult = NOT_OK; return; }
                if (ambient > 0.0) ambient -= 16.0;
        }

        delete obj;    
        delete tun;
        ShutDownVirtual(&vscr);
}
