//      dlblogo.cpp


#include <conio.h>
#include <math.h>
#include "mode13.h"
#include "obj3d.h"
#include "triangle.h"
#include "phongpal.h"
#include "vectors.h"
#include "cuadro.h"
#include "stuff.h"
#include "dlblogo.h"

#include "env1.h"
#include "lillogo1.h"
#include "lillogo2.h"
#include "lillogo3.h"
#include "banner2.h"


double d_transtable[256][3];
double  d_paramtable[256 * 6];
unsigned char d_tindex;


void DLBLOGO_Setup() {
	double ang;
	for (int i = 0; i < 256; i++) {
		ang = i * 3.14159265 / 128.0;
                d_transtable[i][0] = cos(ang) * 10;
                d_transtable[i][1] = sin(ang) * 10;
                d_transtable[i][2] = -cos(ang) * 300;
	}
	for (i = 0; i < 64; i++) {
                d_paramtable[i * 6 + 0] = 40 + i;
                d_paramtable[i * 6 + 1] = 120 + i * 2;
                d_paramtable[i * 6 + 2] = 40;
                d_paramtable[i * 6 + 3] = 120;
                d_paramtable[i * 6 + 4] = 104 - i;
                d_paramtable[i * 6 + 5] = 248 - i * 2;
	}
	for (i = 0; i < 64; i++) {
                d_paramtable[(64 + i) * 6 + 0] = 104 - i;
                d_paramtable[(64 + i) * 6 + 1] = 248 - i * 2;
                d_paramtable[(64 + i) * 6 + 2] = 40 + i;
                d_paramtable[(64 + i) * 6 + 3] = 120 + i * 2;
                d_paramtable[(64 + i) * 6 + 4] = 40;
                d_paramtable[(64 + i) * 6 + 5] = 120;
	}
	for (i = 0; i < 64; i++) {
                d_paramtable[(128 + i) * 6 + 0] = 40 + i;
                d_paramtable[(128 + i) * 6 + 1] = 120 + i * 2;
                d_paramtable[(128 + i) * 6 + 2] = 104;
                d_paramtable[(128 + i) * 6 + 3] = 248;
                d_paramtable[(128 + i) * 6 + 4] = 40;
                d_paramtable[(128 + i) * 6 + 5] = 120;
	}
	for (i = 0; i < 64; i++) {
                d_paramtable[(192 + i) * 6 + 0] = 104 - i;
                d_paramtable[(192 + i) * 6 + 1] = 248 - i * 2;
                d_paramtable[(192 + i) * 6 + 2] = 104 - i;
                d_paramtable[(192 + i) * 6 + 3] = 248 - i * 2;
                d_paramtable[(192 + i) * 6 + 4] = 40 + i;
                d_paramtable[(192 + i) * 6 + 5] = 120 + i * 2;
	}
}


void d_Transform(TObject3D *o) {
        unsigned char t = d_tindex;
	for (int i = 0; i < o->NumVertex; i++) {
                o->Vertex[i]->x += d_transtable[t][0];
                o->Vertex[i]->y += d_transtable[t][1];
                o->Vertex[i]->z += d_transtable[t][2];
		o->Vertex[i]->FakeNormal();
		o->Vertex[i]->CalcEnvUV();
		t++;
	}
}

void d_UnTransform(TObject3D *o) {
        unsigned char t = d_tindex;
	for (int i = 0; i < o->NumVertex; i++) {
                o->Vertex[i]->x -= d_transtable[t][0];
                o->Vertex[i]->y -= d_transtable[t][1];
                o->Vertex[i]->z -= d_transtable[t][2];
		t++;
	}
}



void DrawLilLogo(unsigned int logo, unsigned int where);
#pragma aux DrawLilLogo =			\
"add edi, 32220"		\
"mov edx, 100"		\
"yloop:  mov ecx, 100"	\
"xloop:  mov al, [esi]"	\
"		inc al"	\
"		jz skip"	\
"		dec al"	\
"		mov [edi], al"	\
"skip:   inc esi"	\
"		inc edi"	\
"		dec ecx"	\
"		jnz xloop"	\
"		add edi, 220"	\
"		dec edx"	\
"		jnz yloop"	\
parm [esi] [edi]	\
modify [eax ecx edx];



void DLBLOGO_Run() {
		TObject3D *obj = new TObject3D();
		PTVirtual vscr;
		unsigned int voff;
		TPalette pal;
		unsigned int LogoIdx[3] = { (unsigned int)LILLOGO1,
                                            (unsigned int)LILLOGO2,
                                            (unsigned int)LILLOGO3 };
		
        SetupVirtual(&vscr, &voff);
        GeneraCuadro(16, 10, obj);
        obj->Scale(6.0, 6.0, 6.0);
        obj->SetCenter(160, 100);
        GlobalStyle = c_texturemapped;
        
        double *d_parameter = d_paramtable;
        char d_paramidx = 0;
        double ambient = 256.0;
        
        ClearScreen(0, voff);       
        
        d_tindex = 0;
        TextureOffset = (unsigned int)ENV1;
        GetMusicInfo();
        while (position < 26) {
                if (rowflag && ((row & 7) == 0)) ambient = 64.0;
                if ((d_paramidx++) == 0) d_parameter = d_paramtable;
                Fast256PhongPal( ambient, *(d_parameter++), *(d_parameter++),
                                 ambient, *(d_parameter++), *(d_parameter++),
                                 ambient, *(d_parameter++), *(d_parameter++), pal);
                d_Transform(obj);
        	obj->Draw(voff);
                DrawLilLogo(LogoIdx[(row >> 1) % 3], voff);
                Blur(voff);
                if (row >= 24)
                        DrawBanner((unsigned int)BANNER2, 158, 100, 0, 0, voff);
        	VRetrace();
        	SetPalette(pal);
        	CopyScreen(voff, VGA);
                d_UnTransform(obj);
                d_tindex -= 4;
        	obj->Rotate(0, 0, 2);
        	if (ambient > 0.0) ambient -= 16.0;
                GetMusicInfo();
                if (kbhit()) if (getch() == 27) { lastresult = NOT_OK; return; }
        }

        rowflag = 0;
        ambient = 128.0;
        while (row < 62) {
                if (rowflag && ((row & 7) == 0)) ambient = 64.0;
                if (rowflag && (row >= 48) && ((row & 1) == 0))
                        ambient = (row - 48) * 16.0;
                if ((d_paramidx++) == 0) d_parameter = d_paramtable;
                Fast256PhongPal( ambient, *(d_parameter++), *(d_parameter++),
                                 ambient, *(d_parameter++), *(d_parameter++),
                                 ambient, *(d_parameter++), *(d_parameter++), pal);
                d_Transform(obj);
        	obj->Draw(voff);
                DrawLilLogo(LogoIdx[(row >> 1) % 3], voff);
                Blur(voff);
                if (row < 40)
                        DrawBanner((unsigned int)BANNER2, 158, 100, 0, 0, voff);
        	VRetrace();
        	SetPalette(pal);
        	CopyScreen(voff, VGA);
                d_UnTransform(obj);
                d_tindex -= 4;
        	obj->Rotate(0, 0, 2);
        	if (ambient > 0.0) ambient -= 16.0;
                GetMusicInfo();
                if (kbhit()) if (getch() == 27) { lastresult = NOT_OK; return; }
        }

        delete obj;
        ShutDownVirtual(&vscr);
}

